/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.file;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.otto.jlineup.browser.BrowserStep;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.file.ScreenshotContextFileTracker;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@JsonDeserialize(builder=Builder.class)
public class FileTracker {
    public final JobConfig jobConfig;
    public final ConcurrentHashMap<Integer, ScreenshotContextFileTracker> contexts;
    public final ConcurrentHashMap<BrowserStep, String> browsers;

    private FileTracker() {
        this.jobConfig = null;
        this.contexts = null;
        this.browsers = null;
    }

    public FileTracker(JobConfig jobConfig, ConcurrentHashMap<Integer, ScreenshotContextFileTracker> contexts, ConcurrentHashMap<BrowserStep, String> browsers) {
        this.jobConfig = jobConfig;
        this.contexts = contexts;
        this.browsers = browsers;
    }

    private FileTracker(Builder builder) {
        this.jobConfig = builder.jobConfig;
        this.contexts = builder.contexts;
        this.browsers = builder.browsers;
    }

    public static Builder fileTrackerBuilder() {
        return new Builder();
    }

    public static Builder copyOfBuilder(FileTracker copy) {
        Builder builder = new Builder();
        builder.jobConfig = copy.getJobConfig();
        builder.contexts = copy.getContexts();
        builder.browsers = copy.getBrowsers();
        return builder;
    }

    @JsonProperty(value="job-config")
    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    public ConcurrentHashMap<Integer, ScreenshotContextFileTracker> getContexts() {
        return this.contexts;
    }

    public ConcurrentHashMap<BrowserStep, String> getBrowsers() {
        return this.browsers;
    }

    public static FileTracker create(JobConfig jobConfig) {
        return new FileTracker(jobConfig, new ConcurrentHashMap<Integer, ScreenshotContextFileTracker>(), new ConcurrentHashMap<BrowserStep, String>());
    }

    public ScreenshotContextFileTracker getScreenshotContextFileTracker(int hash) {
        assert (this.contexts != null);
        return this.contexts.get(hash);
    }

    public Map<Integer, Map<BrowserStep, String>> getScreenshotsForContext(int hash) throws IOException {
        assert (this.contexts != null);
        ScreenshotContextFileTracker screenshotContextFileTracker = this.contexts.get(hash);
        if (screenshotContextFileTracker == null) {
            throw new IOException("The files in the working directory don't fit the given config.\nAre you trying to run the 'compare' step for files made with a different config?\nPlease run JLineup before and after with the current config before trying again.");
        }
        return screenshotContextFileTracker.screenshots;
    }

    public void addScreenshot(ScreenshotContext screenshotContext, String path, int yPosition) {
        assert (this.contexts != null);
        ScreenshotContextFileTracker screenshotContextFileTracker = this.contexts.get(screenshotContext.contextHash());
        if (screenshotContextFileTracker == null) {
            ScreenshotContextFileTracker fileTrackerToPut = new ScreenshotContextFileTracker(screenshotContext);
            screenshotContextFileTracker = this.contexts.putIfAbsent(screenshotContext.contextHash(), fileTrackerToPut);
            if (screenshotContextFileTracker == null) {
                screenshotContextFileTracker = fileTrackerToPut;
            }
        }
        screenshotContextFileTracker.addScreenshot(screenshotContext, path, yPosition);
    }

    public boolean isContextAlreadyThere(ScreenshotContext screenshotContext) {
        assert (this.contexts != null);
        return this.contexts.get(screenshotContext.contextHash()) != null;
    }

    public void setBrowserAndVersion(ScreenshotContext screenshotContext, String browserAndVersion) {
        if (this.browsers != null) {
            this.browsers.put(screenshotContext.step, browserAndVersion);
        }
    }

    public void removeContext(ScreenshotContext screenshotContext) {
        assert (this.contexts != null);
        this.contexts.remove(screenshotContext.contextHash());
    }

    public static final class Builder {
        private JobConfig jobConfig;
        private ConcurrentHashMap<Integer, ScreenshotContextFileTracker> contexts;
        private ConcurrentHashMap<BrowserStep, String> browsers;

        private Builder() {
        }

        public Builder withJobConfig(JobConfig val) {
            this.jobConfig = val;
            return this;
        }

        public Builder withContexts(ConcurrentHashMap<Integer, ScreenshotContextFileTracker> val) {
            this.contexts = val;
            return this;
        }

        public Builder withBrowsers(ConcurrentHashMap<BrowserStep, String> val) {
            this.browsers = val;
            return this;
        }

        public FileTracker build() {
            return new FileTracker(this);
        }
    }
}

