/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.image;

import de.otto.jlineup.image.ImageService;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntiAliasingIgnoringComparator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double DEFAULT_BRIGHTNESS_TOLERANCE = 0.0;
    private static final double JUST_NOTICEABLE_DIFFERENCE = 2.3;

    public static boolean checkIsAntialiased(BufferedImage img1, BufferedImage img2, int x, int y) {
        boolean isPixelAntiAliased = AntiAliasingIgnoringComparator.isAntialiased(img2, x, y, img1) || AntiAliasingIgnoringComparator.isAntialiased(img1, x, y, img2);
        LOG.debug("Check if different pixel {}|{} is because of anti-aliasing: {}", new Object[]{x, y, isPixelAntiAliased});
        return isPixelAntiAliased;
    }

    private static boolean isAntialiased(BufferedImage img1, int xPos, int yPos, BufferedImage img2) {
        if (xPos >= img1.getWidth() || yPos >= img1.getHeight()) {
            return false;
        }
        Color color1 = ImageService.getColor(img1.getRGB(xPos, yPos));
        int width = img1.getWidth();
        int height = img1.getHeight();
        int x0 = Math.max(xPos - 1, 0);
        int y0 = Math.max(yPos - 1, 0);
        int x2 = Math.min(xPos + 1, width - 1);
        int y2 = Math.min(yPos + 1, height - 1);
        boolean checkExtremePixels = img2 == null;
        double brightnessTolerance = checkExtremePixels ? 2.3 : 0.0;
        int zeroes = 0;
        int positives = 0;
        int negatives = 0;
        double min = 0.0;
        double max = 0.0;
        int minX = 0;
        int minY = 0;
        int maxX = 0;
        int maxY = 0;
        for (int y = y0; y <= y2; ++y) {
            for (int x = x0; x <= x2; ++x) {
                if (x == xPos && y == yPos) continue;
                double delta = AntiAliasingIgnoringComparator.brightnessDelta(ImageService.getColor(img1.getRGB(x, y)), color1);
                if (Math.abs(delta) <= brightnessTolerance) {
                    ++zeroes;
                } else if (delta > brightnessTolerance) {
                    ++positives;
                } else {
                    ++negatives;
                }
                if (zeroes > 2) {
                    return false;
                }
                if (checkExtremePixels) continue;
                if (delta < min) {
                    min = delta;
                    minX = x;
                    minY = y;
                }
                if (!(delta > max)) continue;
                max = delta;
                maxX = x;
                maxY = y;
            }
        }
        if (checkExtremePixels) {
            return true;
        }
        if (negatives == 0 || positives == 0) {
            return false;
        }
        return !AntiAliasingIgnoringComparator.isAntialiased(img1, minX, minY, null) && !AntiAliasingIgnoringComparator.isAntialiased(img2, minX, minY, null) || !AntiAliasingIgnoringComparator.isAntialiased(img1, maxX, maxY, null) && !AntiAliasingIgnoringComparator.isAntialiased(img2, maxX, maxY, null);
    }

    private static double brightnessDelta(Color color1, Color color2) {
        return AntiAliasingIgnoringComparator.rgb2y(color1.getRed(), color1.getGreen(), color1.getBlue()) - AntiAliasingIgnoringComparator.rgb2y(color2.getRed(), color2.getGreen(), color2.getBlue());
    }

    private static double rgb2y(int r, int g, int b) {
        return (double)r * 0.29889531 + (double)g * 0.58662247 + (double)b * 0.11448223;
    }
}

