/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.image;

import de.otto.jlineup.image.AntiAliasingIgnoringComparator;
import de.otto.jlineup.image.LAB;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import java.util.Optional;

public class ImageService {
    public static final int SAME_COLOR = Color.BLACK.getRGB();
    public static final int HIGHLIGHT_COLOR = Color.WHITE.getRGB();
    public static final int DIFFERENT_SIZE_COLOR = Color.GRAY.getRGB();
    public static final int LOOK_SAME_COLOR = Color.BLUE.getRGB();
    public static final int ANTI_ALIAS_DETECTED_COLOR = Color.GREEN.getRGB();

    public ImageComparisonResult compareImages(BufferedImage image1, BufferedImage image2, int viewportHeight) {
        return this.compareImages(image1, image2, viewportHeight, false, true, 2.3f);
    }

    public ImageComparisonResult compareImages(BufferedImage image1, BufferedImage image2, int viewportHeight, boolean ignoreAntiAliased, boolean strictColorComparison, float maxColorDistance) {
        if (image1 == null || image2 == null) {
            throw new NullPointerException("Can't compare null imagebuffers");
        }
        if (ImageService.bufferedImagesEqualQuick(image1, image2)) {
            return new ImageComparisonResult(null, 0.0, 0);
        }
        int width1 = image1.getWidth();
        int height1 = image1.getHeight();
        int width2 = image2.getWidth();
        int height2 = image2.getHeight();
        int maxWidth = Math.max(image1.getWidth(), image2.getWidth());
        int maxHeight = Math.max(image1.getHeight(), image2.getHeight());
        int minWidth = Math.min(image1.getWidth(), image2.getWidth());
        int[] image1Pixels = image1.getRGB(0, 0, width1, height1, null, 0, width1);
        int[] image2Pixels = image2.getRGB(0, 0, width2, height2, null, 0, width2);
        int pixelCount1 = width1 * height1;
        int pixelCount2 = width2 * height2;
        int maxPixelCount = maxWidth * maxHeight;
        int minPixelCount = Math.min(pixelCount1, pixelCount2);
        int diffPixelCounter = 0;
        int antiAliasedDiffPixelCounter = 0;
        int lookSameDiffPixelCounter = 0;
        float maxDetectedColorDistance = 0.0f;
        int[] differenceImagePixels = new int[maxPixelCount];
        int i1 = 0;
        int i2 = 0;
        int iD = 0;
        int x = 0;
        int y = 0;
        while (iD < maxPixelCount) {
            if (image1Pixels[i1] != image2Pixels[i2]) {
                if (!strictColorComparison && ImageService.doColorsLookSame(image1Pixels[i1], image2Pixels[i2], maxColorDistance)) {
                    differenceImagePixels[iD] = LOOK_SAME_COLOR;
                    ++lookSameDiffPixelCounter;
                } else if (ignoreAntiAliased && AntiAliasingIgnoringComparator.checkIsAntialiased(image1, image2, x, y)) {
                    differenceImagePixels[iD] = ANTI_ALIAS_DETECTED_COLOR;
                    ++antiAliasedDiffPixelCounter;
                } else {
                    differenceImagePixels[iD] = HIGHLIGHT_COLOR;
                    ++diffPixelCounter;
                }
            } else {
                differenceImagePixels[iD] = SAME_COLOR;
            }
            ++i2;
            ++iD;
            if (++i1 % width1 == 0) {
                x = 0;
                ++y;
            } else {
                ++x;
            }
            if (width1 < width2 && i1 % minWidth == 0) {
                while (i2 % maxWidth != 0) {
                    ++i2;
                    differenceImagePixels[iD] = DIFFERENT_SIZE_COLOR;
                    ++diffPixelCounter;
                    ++iD;
                }
            } else if (width2 < width1 && i2 % minWidth == 0) {
                while (i1 % maxWidth != 0) {
                    ++i1;
                    differenceImagePixels[iD] = DIFFERENT_SIZE_COLOR;
                    ++diffPixelCounter;
                    ++iD;
                }
            }
            if (i1 != minPixelCount && i2 != minPixelCount) continue;
            while (iD < maxPixelCount) {
                if (iD % maxWidth < minWidth) {
                    differenceImagePixels[iD] = DIFFERENT_SIZE_COLOR;
                    ++diffPixelCounter;
                } else {
                    differenceImagePixels[iD] = SAME_COLOR;
                }
                ++iD;
            }
        }
        double difference = 1.0 * (double)diffPixelCounter / (double)Math.min(maxPixelCount, maxWidth * viewportHeight);
        BufferedImage out = new BufferedImage(maxWidth, maxHeight, 1);
        out.setRGB(0, 0, maxWidth, maxHeight, differenceImagePixels, 0, maxWidth);
        return new ImageComparisonResult(out, difference, lookSameDiffPixelCounter + antiAliasedDiffPixelCounter);
    }

    private static int[] getARGB(int pixel) {
        int alpha = pixel >> 24 & 0xFF;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return new int[]{alpha, red, green, blue};
    }

    static Color getColor(int pixel) {
        int[] argb = ImageService.getARGB(pixel);
        return new Color(argb[1], argb[2], argb[3], argb[0]);
    }

    public static boolean bufferedImagesEqual(BufferedImage image1, BufferedImage image2) {
        if (image1.getWidth() == image2.getWidth() && image1.getHeight() == image2.getHeight()) {
            for (int xPosition = 0; xPosition < image1.getWidth(); ++xPosition) {
                for (int yPosition = 0; yPosition < image1.getHeight(); ++yPosition) {
                    if (image1.getRGB(xPosition, yPosition) == image2.getRGB(xPosition, yPosition)) continue;
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    static boolean doColorsLookSame(int argbColor1, int argbColor2, double maxColorDistance) {
        LAB lab2;
        int[] argb1 = ImageService.getARGB(argbColor1);
        int[] argb2 = ImageService.getARGB(argbColor2);
        LAB lab1 = LAB.fromRGB(argb1[1], argb1[2], argb1[3], 0.0);
        double distance = LAB.ciede2000(lab1, lab2 = LAB.fromRGB(argb2[1], argb2[2], argb2[3], 0.0));
        return distance <= maxColorDistance;
    }

    public static boolean bufferedImagesEqualQuick(BufferedImage image1, BufferedImage image2) {
        DataBuffer dataBuffer1 = image1.getRaster().getDataBuffer();
        DataBuffer dataBuffer2 = image2.getRaster().getDataBuffer();
        if (dataBuffer1 instanceof DataBufferByte && dataBuffer2 instanceof DataBufferByte) {
            DataBufferByte dataBufferBytes1 = (DataBufferByte)dataBuffer1;
            DataBufferByte dataBufferBytes2 = (DataBufferByte)dataBuffer2;
            for (int bank = 0; bank < dataBufferBytes1.getNumBanks(); ++bank) {
                byte[] bytes2;
                byte[] bytes1 = dataBufferBytes1.getData(bank);
                if (Arrays.equals(bytes1, bytes2 = dataBufferBytes2.getData(bank))) continue;
                return false;
            }
        } else if (dataBuffer1 instanceof DataBufferInt && dataBuffer2 instanceof DataBufferInt) {
            DataBufferInt dataBufferInt1 = (DataBufferInt)dataBuffer1;
            DataBufferInt dataBufferInt2 = (DataBufferInt)dataBuffer2;
            for (int bank = 0; bank < dataBufferInt1.getNumBanks(); ++bank) {
                int[] ints2;
                int[] ints1 = dataBufferInt1.getData(bank);
                if (Arrays.equals(ints1, ints2 = dataBufferInt2.getData(bank))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static class ImageComparisonResult {
        private final BufferedImage differenceImage;
        private final double difference;
        private final int acceptedDifferentPixels;

        public ImageComparisonResult(BufferedImage differenceImage, double difference, int acceptedDifferentPixels) {
            this.differenceImage = differenceImage;
            this.difference = difference;
            this.acceptedDifferentPixels = acceptedDifferentPixels;
        }

        public Optional<BufferedImage> getDifferenceImage() {
            return Optional.ofNullable(this.differenceImage);
        }

        public double getDifference() {
            return this.difference;
        }

        public int getAcceptedDifferentPixels() {
            return this.acceptedDifferentPixels;
        }
    }
}

