/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.report;

import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.Cookie;
import de.otto.jlineup.config.DeviceConfig;
import de.otto.jlineup.report.ScreenshotComparisonResult;
import de.otto.jlineup.report.Summary;
import de.otto.jlineup.report.UsedInTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ContextReport {
    public final int contextHash;
    public final Summary summary;
    public final List<ScreenshotComparisonResult> results;
    public final ScreenshotContext screenshotContext;

    public ContextReport(int contextHash, ScreenshotContext screenshotContext, Summary summary, List<ScreenshotComparisonResult> results) {
        this.contextHash = contextHash;
        this.screenshotContext = screenshotContext;
        this.summary = summary;
        this.results = results;
    }

    @UsedInTemplate
    public String getUrl() {
        return BrowserUtils.buildUrl(this.screenshotContext.url, this.screenshotContext.urlSubPath, Collections.emptyMap());
    }

    @UsedInTemplate
    public String getShortenedUrl() {
        Object shortenedUrl = this.getUrl();
        if (((String)shortenedUrl).length() > 25) {
            shortenedUrl = "..." + ((String)shortenedUrl).substring(((String)shortenedUrl).lastIndexOf("/"), ((String)shortenedUrl).length());
        }
        return shortenedUrl;
    }

    @UsedInTemplate
    public int getContextHash() {
        return this.contextHash;
    }

    @UsedInTemplate
    public int getWidth() {
        return this.screenshotContext.deviceConfig.width;
    }

    @UsedInTemplate
    public List<Cookie> getShownCookies() {
        if (this.screenshotContext.cookies == null) {
            return null;
        }
        return this.screenshotContext.cookies.stream().filter(cookie -> cookie.showInReport != null && cookie.showInReport != false).collect(Collectors.toList());
    }

    @UsedInTemplate
    public String getShownCookiesString() {
        if (this.getShownCookies() == null) {
            return null;
        }
        String cookiesString = this.getShownCookies().stream().filter(Objects::nonNull).map(cookie -> cookie.name + ": " + cookie.value).collect(Collectors.joining(", "));
        try {
            cookiesString = URLDecoder.decode(cookiesString, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return cookiesString;
    }

    @UsedInTemplate
    public String getDeviceInfo() {
        StringBuilder sb = new StringBuilder();
        DeviceConfig dc = this.screenshotContext.deviceConfig;
        if (dc.isMobile()) {
            sb.append(dc.deviceName);
        }
        if (dc.isGenericMobile()) {
            sb.append("\n");
        }
        if (dc.isGenericMobile() || dc.isDesktop()) {
            sb.append(dc.width);
            sb.append("x");
            sb.append(dc.height);
            if (dc.pixelRatio != 1.0f) {
                sb.append("\nPixel ratio: ");
                sb.append(dc.pixelRatio);
            }
            if (dc.userAgent != null) {
                sb.append("\n");
                sb.append(dc.userAgent);
            }
            if (dc.isDesktop() && dc.touch) {
                sb.append("\n");
                sb.append("Touch enabled");
            }
        }
        return sb.toString();
    }

    @UsedInTemplate
    public List<ScreenshotComparisonResult> getResults() {
        return this.results;
    }

    @UsedInTemplate
    public boolean isSuccess() {
        for (ScreenshotComparisonResult result : this.results) {
            if (!(result.difference > 0.0)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextReport that = (ContextReport)o;
        return this.contextHash == that.contextHash && Objects.equals(this.summary, that.summary) && Objects.equals(this.results, that.results) && Objects.equals(this.screenshotContext, that.screenshotContext);
    }

    public int hashCode() {
        return Objects.hash(this.contextHash, this.summary, this.results, this.screenshotContext);
    }

    public String toString() {
        return "ContextReport{contextHash=" + this.contextHash + ", summary=" + this.summary + ", results=" + this.results + ", screenshotContext=" + this.screenshotContext + "}";
    }
}

