/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.report;

import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.Utils;
import de.otto.jlineup.browser.BrowserStep;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.DeviceConfig;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.image.ImageService;
import de.otto.jlineup.report.Report;
import de.otto.jlineup.report.ReportV2;
import de.otto.jlineup.report.ScreenshotComparisonResult;
import de.otto.jlineup.report.UsedInTemplate;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class HTMLReportWriter {
    private final FileService fileService;
    ClassLoaderTemplateResolver templateResolver = new ClassLoaderTemplateResolver();
    TemplateEngine templateEngine = new TemplateEngine();

    public HTMLReportWriter(FileService fileService) {
        this.fileService = fileService;
        this.templateResolver.setTemplateMode("HTML");
        this.templateResolver.setPrefix("templates/");
        this.templateResolver.setSuffix(".html");
        this.templateEngine = new TemplateEngine();
        this.templateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver);
    }

    public void writeReport(Report report) throws FileNotFoundException {
        this.fileService.writeHtmlReportLegacy(this.renderReport("report", report.config, report.getFlatResultList()));
    }

    public void writeReportV2(ReportV2 report) throws FileNotFoundException {
        this.fileService.writeHtmlReport(this.renderReportV2("report_wip", report), "report.html");
    }

    public void writeNotFinishedReport(RunStepConfig runStepConfig, JobConfig jobConfig) throws FileNotFoundException {
        this.fileService.writeHtmlReport(this.renderNotFinishedReport("report_not_finished", runStepConfig, jobConfig), "report.html");
        this.fileService.writeHtmlReportLegacy(this.renderNotFinishedReport("report_not_finished", runStepConfig, jobConfig));
    }

    String renderReport(String template, JobConfig config, List<ScreenshotComparisonResult> screenshotComparisonResults) {
        Map<String, Object> variables = this.prepareVariablesForReportTemplate(screenshotComparisonResults);
        variables.put("config", config);
        return this.templateEngine.process(template, (IContext)new Context(Locale.US, variables));
    }

    private String renderReport(String templateName, Report report) {
        HashMap<String, Report> variables = new HashMap<String, Report>();
        variables.put("report", report);
        return this.templateEngine.process(templateName, (IContext)new Context(Locale.US, variables));
    }

    private String renderReportV2(String templateName, ReportV2 report) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("report", report);
        this.enrichVariables(variables);
        return this.templateEngine.process(templateName, (IContext)new Context(Locale.US, variables));
    }

    String renderNotFinishedReport(String template, RunStepConfig runStepConfig, JobConfig config) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.enrichVariables(variables);
        variables.put("config", config);
        variables.put("report_dir", runStepConfig.getReportDirectory());
        variables.put("working_dir", runStepConfig.getWorkingDirectory());
        return this.templateEngine.process(template, (IContext)new Context(Locale.US, variables));
    }

    private Map<String, Object> prepareVariablesForReportTemplate(List<ScreenshotComparisonResult> screenshotComparisonResults) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        LinkedList<ScreenshotComparisonResultContext> screenshotComparisonResultContexts = new LinkedList<ScreenshotComparisonResultContext>();
        int lastContextKey = 0;
        ScreenshotComparisonResultContext currentContext = null;
        for (ScreenshotComparisonResult screenshotComparisonResult : screenshotComparisonResults) {
            int context = this.getContextHash(screenshotComparisonResult);
            if (context != lastContextKey) {
                lastContextKey = context;
                currentContext = new ScreenshotComparisonResultContext(screenshotComparisonResult.contextHash);
                screenshotComparisonResultContexts.add(currentContext);
            }
            currentContext.addResult(screenshotComparisonResult);
        }
        variables.put("resultContexts", screenshotComparisonResultContexts);
        this.enrichVariables(variables);
        return variables;
    }

    private void enrichVariables(Map<String, Object> variables) {
        variables.put("jlineup_version", Utils.readVersion());
        variables.put("jlineup_commit", Utils.readCommit());
        variables.put("legend_same_rgb", "#" + Integer.toHexString(ImageService.SAME_COLOR).substring(2));
        variables.put("legend_look_same_rgb", "#" + Integer.toHexString(ImageService.LOOK_SAME_COLOR).substring(2));
        variables.put("legend_anti_alias_rgb", "#" + Integer.toHexString(ImageService.ANTI_ALIAS_DETECTED_COLOR).substring(2));
        variables.put("legend_different_rgb", "#" + Integer.toHexString(ImageService.HIGHLIGHT_COLOR).substring(2));
        variables.put("legend_different_size_rgb", "#" + Integer.toHexString(ImageService.DIFFERENT_SIZE_COLOR).substring(2));
    }

    private int getContextHash(ScreenshotComparisonResult screenshotComparisonResult) {
        return screenshotComparisonResult.contextHash;
    }

    private class ScreenshotComparisonResultContext {
        private final List<ScreenshotComparisonResult> results = new LinkedList<ScreenshotComparisonResult>();
        private final ScreenshotContext screenshotContext;
        private final int contextHash;
        private final Map<BrowserStep, String> browsers;

        ScreenshotComparisonResultContext(int contextHash) {
            this.screenshotContext = HTMLReportWriter.this.fileService.getRecordedContext(contextHash);
            this.contextHash = contextHash;
            this.browsers = HTMLReportWriter.this.fileService.getBrowsers();
        }

        void addResult(ScreenshotComparisonResult result) {
            this.results.add(result);
        }

        @UsedInTemplate
        public int getContextHash() {
            return this.contextHash;
        }

        @UsedInTemplate
        public String getUrl() {
            return BrowserUtils.buildUrl(this.screenshotContext.url, this.screenshotContext.urlSubPath, Collections.emptyMap());
        }

        @UsedInTemplate
        public int getWidth() {
            return this.screenshotContext.deviceConfig.width;
        }

        @UsedInTemplate
        public String getBrowser(String step) {
            return this.browsers.get((Object)BrowserStep.valueOf(step));
        }

        @UsedInTemplate
        public String getDeviceInfo() {
            StringBuilder sb = new StringBuilder();
            DeviceConfig dc = this.screenshotContext.deviceConfig;
            if (dc.isMobile()) {
                sb.append(dc.deviceName);
            }
            if (dc.isGenericMobile()) {
                sb.append("\n");
            }
            if (dc.isGenericMobile() || dc.isDesktop()) {
                sb.append("Size: ");
                sb.append(dc.width);
                sb.append("x");
                sb.append(dc.height);
                if (dc.pixelRatio != 1.0f) {
                    sb.append("\nPixel ratio: ");
                    sb.append(dc.pixelRatio);
                }
                if (dc.userAgent != null) {
                    sb.append("\n");
                    sb.append(dc.userAgent);
                }
                if (dc.isDesktop() && dc.touch) {
                    sb.append("\n");
                    sb.append("Touch enabled");
                }
            }
            return sb.toString();
        }

        @UsedInTemplate
        public List<ScreenshotComparisonResult> getResults() {
            return this.results;
        }

        @UsedInTemplate
        public String getShortenedUrl() {
            Object shortenedUrl = this.getUrl();
            if (((String)shortenedUrl).length() > 25) {
                shortenedUrl = "..." + ((String)shortenedUrl).substring(((String)shortenedUrl).lastIndexOf("/"), ((String)shortenedUrl).length());
            }
            return shortenedUrl;
        }

        @UsedInTemplate
        public boolean isSuccess() {
            for (ScreenshotComparisonResult result : this.results) {
                if (!(result.difference > 0.0)) continue;
                return false;
            }
            return true;
        }
    }
}

