/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.report;

import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.report.ContextReport;
import de.otto.jlineup.report.ReportV2;
import de.otto.jlineup.report.ScreenshotComparisonResult;
import de.otto.jlineup.report.Summary;
import de.otto.jlineup.report.UrlReportV2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.stream.Collectors;

public class ReportGeneratorV2 {
    private final FileService fileService;

    public ReportGeneratorV2(FileService fileService) {
        this.fileService = fileService;
    }

    public ReportV2 generateReport(Map<String, List<ScreenshotComparisonResult>> screenshotComparisonResultLists, JobConfig config) {
        List<ScreenshotComparisonResult> resultList = screenshotComparisonResultLists.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        Summary summary = this.getSummary(resultList);
        ArrayList<UrlReportV2> urlReports = new ArrayList<UrlReportV2>();
        for (Map.Entry<String, List<ScreenshotComparisonResult>> resultForUrl : screenshotComparisonResultLists.entrySet()) {
            Summary urlSummary = this.getSummary(resultForUrl.getValue());
            Map resultsPerContextHash = resultForUrl.getValue().stream().collect(Collectors.groupingBy(res -> res.contextHash, Collectors.mapping(res -> res, Collectors.toList())));
            ArrayList<ContextReport> contextReports = new ArrayList<ContextReport>();
            for (Map.Entry resultPerHash : resultsPerContextHash.entrySet()) {
                Summary contextSummary = this.getSummary(resultPerHash.getValue());
                ContextReport contextReport = new ContextReport(resultPerHash.getKey(), this.fileService.getRecordedContext(resultPerHash.getKey()), contextSummary, resultPerHash.getValue());
                contextReports.add(contextReport);
            }
            contextReports.sort(Comparator.comparing(ContextReport::getUrl).thenComparing(ContextReport::getWidth).thenComparing(ContextReport::getShownCookiesString));
            UrlReportV2 urlReport = new UrlReportV2(resultForUrl.getKey(), config.urls.get((Object)resultForUrl.getKey()).url, urlSummary, contextReports);
            urlReports.add(urlReport);
        }
        return new ReportV2(summary, config, urlReports, this.fileService.getBrowsers());
    }

    private Summary getSummary(List<ScreenshotComparisonResult> resultList) {
        double differenceSum = resultList.stream().mapToDouble(scr -> scr.difference).sum();
        OptionalDouble differenceMax = resultList.stream().mapToDouble(scr -> scr.difference).max();
        int acceptedDifferentPixelsSum = resultList.stream().mapToInt(scr -> scr.acceptedDifferentPixels).sum();
        return new Summary(differenceSum > 0.0, differenceSum, differenceMax.orElseGet(() -> 0.0), acceptedDifferentPixelsSum);
    }
}

