/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.report;

import de.otto.jlineup.browser.BrowserStep;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.report.Summary;
import de.otto.jlineup.report.UrlReportV2;
import de.otto.jlineup.report.UsedInTemplate;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReportV2 {
    public final Summary summary;
    public final JobConfig config;
    public final List<UrlReportV2> urlReports;
    public final Map<BrowserStep, String> browsers;

    public ReportV2(Summary summary, JobConfig jobConfig, List<UrlReportV2> urlReports, Map<BrowserStep, String> browsers) {
        this.summary = summary;
        this.config = jobConfig;
        this.urlReports = urlReports;
        this.browsers = browsers;
    }

    @UsedInTemplate
    public String getBrowser(String step) {
        return this.browsers.get((Object)BrowserStep.valueOf(step));
    }

    public String toString() {
        return "ReportV2{summary=" + this.summary + ", config=" + this.config + ", urlReports=" + this.urlReports + ", browsers=" + this.browsers + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportV2 reportV2 = (ReportV2)o;
        return Objects.equals(this.summary, reportV2.summary) && Objects.equals(this.config, reportV2.config) && Objects.equals(this.urlReports, reportV2.urlReports) && Objects.equals(this.browsers, reportV2.browsers);
    }

    public int hashCode() {
        return Objects.hash(this.summary, this.config, this.urlReports, this.browsers);
    }
}

