/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.otto.jlineup.config.DeviceConfig;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.report.UsedInTemplate;
import java.util.Objects;

public class ScreenshotComparisonResult {
    public final int contextHash;
    @JsonProperty(value="url")
    public final String fullUrlWithPath;
    public final DeviceConfig deviceConfig;
    public final int verticalScrollPosition;
    public final double difference;
    public final String screenshotBeforeFileName;
    public final String screenshotAfterFileName;
    public final String differenceImageFileName;
    public final int acceptedDifferentPixels;

    public ScreenshotComparisonResult(int contextHash, String fullUrlWithPath, DeviceConfig deviceConfig, int verticalScrollPosition, double difference, String screenshotBeforeFileName, String screenshotAfterFileName, String differenceImageFileName, int acceptedDifferentPixels) {
        this.contextHash = contextHash;
        this.fullUrlWithPath = fullUrlWithPath;
        this.deviceConfig = deviceConfig;
        this.verticalScrollPosition = verticalScrollPosition;
        this.difference = difference;
        this.screenshotBeforeFileName = screenshotBeforeFileName;
        this.screenshotAfterFileName = screenshotAfterFileName;
        this.differenceImageFileName = differenceImageFileName;
        this.acceptedDifferentPixels = acceptedDifferentPixels;
    }

    @JsonIgnore
    @UsedInTemplate
    public String getScreenshotBeforeFileNameForHTML() {
        return this.convertToHtmlPath(this.screenshotBeforeFileName);
    }

    @JsonIgnore
    @UsedInTemplate
    public String getScreenshotAfterFileNameForHTML() {
        return this.convertToHtmlPath(this.screenshotAfterFileName);
    }

    @JsonIgnore
    @UsedInTemplate
    public String getDifferenceImageFileNameForHtml() {
        return this.convertToHtmlPath(this.differenceImageFileName);
    }

    private String convertToHtmlPath(String fileName) {
        if (fileName == null) {
            return null;
        }
        return fileName.replace(FileService.FILE_SEPARATOR, "/");
    }

    public static ScreenshotComparisonResult noBeforeImageComparisonResult(int contextHash, String url, DeviceConfig deviceConfig, int verticalScrollPosition, String screenshotAfterFileName) {
        return new ScreenshotComparisonResult(contextHash, url, deviceConfig, verticalScrollPosition, 1.0, null, screenshotAfterFileName, null, 0);
    }

    public static ScreenshotComparisonResult noAfterImageComparisonResult(int contextHash, String url, DeviceConfig deviceConfig, int verticalScrollPosition, String screenshotBeforeFileName) {
        return new ScreenshotComparisonResult(contextHash, url, deviceConfig, verticalScrollPosition, 1.0, screenshotBeforeFileName, null, null, 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScreenshotComparisonResult that = (ScreenshotComparisonResult)o;
        return this.contextHash == that.contextHash && this.verticalScrollPosition == that.verticalScrollPosition && Double.compare(that.difference, this.difference) == 0 && this.acceptedDifferentPixels == that.acceptedDifferentPixels && Objects.equals(this.fullUrlWithPath, that.fullUrlWithPath) && Objects.equals(this.deviceConfig, that.deviceConfig) && Objects.equals(this.screenshotBeforeFileName, that.screenshotBeforeFileName) && Objects.equals(this.screenshotAfterFileName, that.screenshotAfterFileName) && Objects.equals(this.differenceImageFileName, that.differenceImageFileName);
    }

    public int hashCode() {
        return Objects.hash(this.contextHash, this.fullUrlWithPath, this.deviceConfig, this.verticalScrollPosition, this.difference, this.screenshotBeforeFileName, this.screenshotAfterFileName, this.differenceImageFileName, this.acceptedDifferentPixels);
    }

    public String toString() {
        return "ScreenshotComparisonResult{contextHash=" + this.contextHash + ", url='" + this.fullUrlWithPath + "', deviceConfig=" + this.deviceConfig + ", verticalScrollPosition=" + this.verticalScrollPosition + ", difference=" + this.difference + ", screenshotBeforeFileName='" + this.screenshotBeforeFileName + "', screenshotAfterFileName='" + this.screenshotAfterFileName + "', differenceImageFileName='" + this.differenceImageFileName + "', acceptedDifferentPixels=" + this.acceptedDifferentPixels + "}";
    }
}

