/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jlineup.report;

import de.otto.jlineup.RunStepConfig;
import de.otto.jlineup.browser.BrowserStep;
import de.otto.jlineup.browser.BrowserUtils;
import de.otto.jlineup.browser.ScreenshotContext;
import de.otto.jlineup.config.JobConfig;
import de.otto.jlineup.config.RunStep;
import de.otto.jlineup.config.UrlConfig;
import de.otto.jlineup.file.FileService;
import de.otto.jlineup.image.ImageService;
import de.otto.jlineup.report.ScreenshotComparisonResult;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.IIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotsComparator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final RunStepConfig runStepConfig;
    private final JobConfig jobConfig;
    private final FileService fileService;
    private final ImageService imageService;

    public ScreenshotsComparator(RunStepConfig runStepConfig, JobConfig jobConfig, FileService fileService, ImageService imageService) {
        this.runStepConfig = RunStepConfig.copyOfBuilder(runStepConfig).withStep(RunStep.compare).build();
        this.jobConfig = jobConfig;
        this.fileService = fileService;
        this.imageService = imageService;
    }

    public Map<String, List<ScreenshotComparisonResult>> compare() throws IOException {
        LOG.debug("Comparing images...");
        if (this.jobConfig.urls == null) {
            LOG.debug("No urls configured, so no comparison.");
            return null;
        }
        HashMap<String, List<ScreenshotComparisonResult>> results = new HashMap<String, List<ScreenshotComparisonResult>>();
        List<ScreenshotContext> contextList = BrowserUtils.buildScreenshotContextListFromConfigAndState(this.runStepConfig, this.jobConfig);
        for (Map.Entry<String, UrlConfig> urlConfigEntry : this.jobConfig.urls.entrySet()) {
            ArrayList<ScreenshotComparisonResult> screenshotComparisonResults = new ArrayList<ScreenshotComparisonResult>();
            for (ScreenshotContext screenshotContext : contextList) {
                if (!urlConfigEntry.getKey().equals(screenshotContext.urlKey)) continue;
                String fullUrlWithPath = BrowserUtils.buildUrl(screenshotContext.url, screenshotContext.urlSubPath, screenshotContext.urlConfig.envMapping);
                Map<Integer, Map<BrowserStep, String>> screenshots = this.fileService.getFileTracker().getScreenshotsForContext(screenshotContext.contextHash());
                ArrayList<Integer> yPositions = new ArrayList<Integer>(screenshots.keySet());
                for (Integer yPosition : yPositions) {
                    String beforeFileName = screenshots.get(yPosition).get((Object)BrowserStep.before);
                    String afterFileName = screenshots.get(yPosition).get((Object)BrowserStep.after);
                    LOG.debug("Comparing file '{}' with '{}'", (Object)beforeFileName, (Object)afterFileName);
                    boolean error = false;
                    BufferedImage imageBefore = null;
                    if (beforeFileName == null) {
                        error = true;
                    } else {
                        try {
                            imageBefore = this.fileService.readScreenshot(beforeFileName);
                        }
                        catch (IIOException e) {
                            error = true;
                        }
                    }
                    if (error) {
                        screenshotComparisonResults.add(ScreenshotComparisonResult.noBeforeImageComparisonResult(screenshotContext.contextHash(), fullUrlWithPath, screenshotContext.deviceConfig, yPosition, this.buildRelativePathFromReportDir(afterFileName)));
                        continue;
                    }
                    BufferedImage imageAfter = null;
                    if (afterFileName == null) {
                        error = true;
                    } else {
                        try {
                            imageAfter = this.fileService.readScreenshot(afterFileName);
                        }
                        catch (IIOException e) {
                            error = true;
                        }
                    }
                    if (error) {
                        screenshotComparisonResults.add(ScreenshotComparisonResult.noAfterImageComparisonResult(screenshotContext.contextHash(), fullUrlWithPath, screenshotContext.deviceConfig, yPosition, this.buildRelativePathFromReportDir(beforeFileName)));
                        continue;
                    }
                    ImageService.ImageComparisonResult imageComparisonResult = this.imageService.compareImages(imageBefore, imageAfter, screenshotContext.deviceConfig.height, screenshotContext.urlConfig.ignoreAntiAliasing, screenshotContext.urlConfig.strictColorComparison, screenshotContext.urlConfig.maxColorDistance);
                    String differenceImageFileName = null;
                    if ((imageComparisonResult.getDifference() > 0.0 || imageComparisonResult.getAcceptedDifferentPixels() > 0) && imageComparisonResult.getDifferenceImage().isPresent()) {
                        differenceImageFileName = this.fileService.writeScreenshot(screenshotContext, imageComparisonResult.getDifferenceImage().orElse(null), yPosition);
                    }
                    screenshotComparisonResults.add(new ScreenshotComparisonResult(screenshotContext.contextHash(), fullUrlWithPath, screenshotContext.deviceConfig, yPosition, imageComparisonResult.getDifference(), this.buildRelativePathFromReportDir(beforeFileName), this.buildRelativePathFromReportDir(afterFileName), this.buildRelativePathFromReportDir(differenceImageFileName), imageComparisonResult.getAcceptedDifferentPixels()));
                }
            }
            screenshotComparisonResults.sort(Comparator.comparing(r -> r.fullUrlWithPath).thenComparing(r -> r.deviceConfig.width).thenComparing(r -> r.deviceConfig.height).thenComparing(r -> Float.valueOf(r.deviceConfig.pixelRatio)).thenComparing(r -> r.verticalScrollPosition));
            results.put(urlConfigEntry.getKey(), screenshotComparisonResults);
        }
        return results;
    }

    private String buildRelativePathFromReportDir(String imageFileName) {
        return imageFileName != null ? this.fileService.getRelativePathFromReportDirToScreenshotsDir() + imageFileName : null;
    }
}

