/*
 * Decompiled with CFR 0.152.
 */
package de.otto.jsonhome.client;

import de.otto.jsonhome.client.HttpStatusException;
import de.otto.jsonhome.client.JsonHomeClient;
import de.otto.jsonhome.client.JsonHomeClientException;
import de.otto.jsonhome.client.NotFoundException;
import de.otto.jsonhome.model.JsonHome;
import de.otto.jsonhome.parser.JacksonJsonHomeParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpJsonHomeClient
implements JsonHomeClient {
    private static Logger LOG = LoggerFactory.getLogger(HttpJsonHomeClient.class);
    private final HttpClient httpClient;
    private final HttpCacheStorage cacheStorage;

    public HttpJsonHomeClient() {
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(100).setMaxObjectSize(50000L).build();
        this.cacheStorage = new BasicHttpCacheStorage(cacheConfig);
        this.httpClient = CachingHttpClientBuilder.create().setHttpCacheStorage(this.cacheStorage).setCacheConfig(cacheConfig).build();
    }

    public HttpJsonHomeClient(HttpClient httpClient, CacheConfig cacheConfig) {
        this.cacheStorage = new BasicHttpCacheStorage(cacheConfig);
        this.httpClient = new CachingHttpClient(httpClient, this.cacheStorage, cacheConfig);
    }

    public HttpJsonHomeClient(HttpClient httpClient, HttpCacheStorage storage, CacheConfig cacheConfig) {
        this.cacheStorage = storage;
        this.httpClient = new CachingHttpClient(httpClient, this.cacheStorage, cacheConfig);
    }

    @Override
    public JsonHome updateAndGet(URI uri) {
        try {
            LOG.info("Expiring cached json-home document {}", (Object)uri);
            this.cacheStorage.removeEntry(uri.toString());
        }
        catch (IOException e) {
            throw new JsonHomeClientException("IOException caught while removing cache-entry: " + e.getMessage(), e);
        }
        return this.get(uri);
    }

    @Override
    public JsonHome get(URI uri) {
        HttpResponse response;
        HttpGet httpget = new HttpGet(uri);
        httpget.setHeader("Accept", "application/json");
        BasicHttpContext context = new BasicHttpContext();
        try {
            LOG.info("Getting json-home document {}", (Object)uri);
            response = this.httpClient.execute((HttpUriRequest)httpget, (HttpContext)context);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                LOG.warn("Json-home document {} not found. HTTP status is 404", (Object)uri);
                throw new NotFoundException("Resource " + uri + " not found");
            }
            if (statusCode >= 400) {
                String status = response.getStatusLine().toString();
                LOG.warn("Json-home document {} not found: {}", (Object)uri, (Object)status);
                throw new HttpStatusException(statusCode, "Failed to load json-home from " + uri + ": Received HTTP status code " + status);
            }
        }
        catch (IOException e) {
            LOG.warn("Error getting json-home document {}: {}", (Object)uri, (Object)e.getMessage());
            throw new JsonHomeClientException("Error getting json-home document " + uri, e);
        }
        finally {
            httpget.reset();
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            InputStream stream = null;
            try {
                stream = entity.getContent();
                JsonHome jsonHome = new JacksonJsonHomeParser().parse(stream);
                return jsonHome;
            }
            catch (IOException e) {
                throw new JsonHomeClientException("Exception caught while getting json-home from " + uri, e);
            }
            catch (RuntimeException e) {
                httpget.abort();
                throw new JsonHomeClientException("Exception caught while getting json-home from " + uri, e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        throw new JsonHomeClientException("No content returned when getting json-home resource from " + uri);
    }

    @Override
    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }
}

