package de.pco.sdk;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

import de.pco.sdk.enums.CameraSubtype;
import de.pco.sdk.enums.CameraSyncMode;
import de.pco.sdk.enums.CameraType;
import de.pco.sdk.enums.ImageTimeStatus;
import de.pco.sdk.enums.ImageType;
import de.pco.sdk.enums.SyncStatus;
import de.pco.sdk.enums.Timebase;
import de.pco.sdk.enums.TriggerMode;

/**
 * View on the PCO_METADATA_STRUCT.
 * @author PCO
 *
 */
public class PcoMetadataStruct 
{
    private BildStruct bildStruct;
    
    /**
     * Constructor
     * @param metadataBean
     */
    public PcoMetadataStruct(BildStruct bildStruct) {
        this.bildStruct = bildStruct;
    }
    
    public long getImageCounter() {
        return this.bildStruct.imageCounter;
    }
    
    public long getImageTimeUs() {
        return this.bildStruct.imageTimeUs;
    }
    
    public int getImageTimeSec() {
        return this.bildStruct.time.second;
    }
    
    public int getImageTimeMin() {
        return this.bildStruct.time.minute;
    }
    
    public int getImageTimeHour() {
        return this.bildStruct.time.hour;
    }
    
    public int getImageTimeDay() {
        return this.bildStruct.time.day;
    }
    
    public int getImageTimeMon() {
        return this.bildStruct.time.month;
    }
    
    public int getImageTimeYear() {
        return this.bildStruct.time.year;
    }
    
    public ImageTimeStatus getImageTimeStatus() {
        return this.bildStruct.imageTimeStatus;
    }
    
    public Timebase getExposureTimebase() {
        return this.bildStruct.exposureTimebase;
    }
    
    public long getExposureTime() {
        return this.bildStruct.exposureTime;
    }
    
    public long getFramerateMilliHz() {
        return this.bildStruct.framerateMilliHz;
    }
    
    /**
     * Gets the width.
     * @return
     */
    public int getImageSizeX() {
        return bildStruct.xRes;
    }
    
    /**
     * Gets the height.
     * @return
     */
    public int getImageSizeY() {
        return bildStruct.yRes;
    }
    
    /**
     * Sensor temperature
     * @return
     */
    public short getSensorTemperature() {
        return this.bildStruct.sensorTemperature;
    }
    
    /**
     * Current horizontal binning.
     * @return
     */
    public byte getBinningX() {
        return this.bildStruct.binningX;
    }
    
    /**
     * Current verticalBinning
     * @return
     */
    public byte getBinningY() {
        return this.bildStruct.binningY;
    }
    
    /**
     * Sensor readout frequency, pixel clock
     * @return
     */
    public long getSensorReadoutFrequency() {
        return this.bildStruct.sensorReadoutFrequency;
    }
    
    /**
     * Conversion factor of the sensor
     * @return
     */
    public int getSensorConvFactor() {
        return this.bildStruct.sensorConvFactor;
    }
    
    /**
     * Serial number of the camera
     * @return
     */
    public long getCameraSerialNo() {
        return this.bildStruct.cameraSerialNo;
    }
    
    public CameraType getCameraType() {
        return this.bildStruct.cameraType;
    }
    
    public int getBitResolution() {
        return this.bildStruct.bitRes;
    }
    
    public SyncStatus getSyncStatus() {
        return this.bildStruct.syncStatus;
    }    
    
    public int getDarkOffset() {
        return this.bildStruct.darkOffset;
    }
    
    public TriggerMode getTriggerMode() {
        return this.bildStruct.triggerMode;
    }
    
    public boolean isDoubleImageMode() {
        return this.bildStruct.isDouble;
    }
    
    public CameraSyncMode getCameraSyncMode() {
        return this.bildStruct.cameraSyncMode;
    }
    
    public ImageType getImageType() {
        return this.bildStruct.imageType;
    }
    
    public int getColorPattern() {
        return this.bildStruct.colorPattern;
    }
    
    public CameraSubtype getCameraSubtype() {
        return this.bildStruct.cameraSubtype;
    }
    
    public long getEventNumber() {
        return this.bildStruct.eventNumber;
    }
    
    public int imageSizeXoffset() {
        return this.bildStruct.imageSizeXoffset;
    }
    
    public int imageSizeYoffset() {
        return this.bildStruct.imageSizeYoffset;
    }
    
    /**
     * All the variables of PcoMetadataStruct are present in the BildStruct.
     * Therefore it is always backed by a BildStruct with filled variables
     * (opposite to the case in pco.sdk).
     * 
     * @return
     */
    public BildStruct getBackingBildStruct() {
        return this.bildStruct;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((bildStruct == null) ? 0 : bildStruct.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        PcoMetadataStruct other = (PcoMetadataStruct) obj;
        if (bildStruct == null) {
            if (other.bildStruct != null)
                return false;
        } else if (!bildStruct.equals(other.bildStruct))
            return false;
        return true;
    }

    @Override
    public String toString() {
        return "PcoMetadataStruct [bildStruct=" + bildStruct + "]";
    }
}
