package de.pco.sdk;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

/**
 * Container of the color correction coefficients for sRGB.
 * @author PCO
 *
 */
public class SRGBColorCorrectionCoefficients 
{
    public double a11, a12, a13;
    public double a21, a22, a23;
    public double a31, a32, a33;
    
    ///////////////////////////////////// GENERATED
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        long temp;
        temp = Double.doubleToLongBits(a11);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(a12);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(a13);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(a21);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(a22);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(a23);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(a31);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(a32);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        temp = Double.doubleToLongBits(a33);
        result = prime * result + (int) (temp ^ (temp >>> 32));
        return result;
    }
    
    @Override
    public boolean equals(Object obj) {
        final double EPSILON = 0.001;
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SRGBColorCorrectionCoefficients other = (SRGBColorCorrectionCoefficients) obj;
        if (Math.abs(Double.doubleToLongBits(a11) - Double.doubleToLongBits(other.a11)) >= EPSILON)
            return false;
        if (Math.abs(Double.doubleToLongBits(a12) - Double.doubleToLongBits(other.a12)) >= EPSILON)
            return false;
        if (Math.abs(Double.doubleToLongBits(a13) - Double.doubleToLongBits(other.a13)) >= EPSILON)
            return false;
        if (Math.abs(Double.doubleToLongBits(a21) - Double.doubleToLongBits(other.a21)) >= EPSILON)
            return false;
        if (Math.abs(Double.doubleToLongBits(a22) - Double.doubleToLongBits(other.a22)) >= EPSILON)
            return false;
        if (Math.abs(Double.doubleToLongBits(a23) - Double.doubleToLongBits(other.a23)) >= EPSILON)
            return false;
        if (Math.abs(Double.doubleToLongBits(a31) - Double.doubleToLongBits(other.a31)) >= EPSILON)
            return false;
        if (Math.abs(Double.doubleToLongBits(a32) - Double.doubleToLongBits(other.a32)) >= EPSILON)
            return false;
        if (Math.abs(Double.doubleToLongBits(a33) - Double.doubleToLongBits(other.a33)) >= EPSILON)
            return false;
        return true;
    }
    
    @Override
    public String toString() {
        return "SRGBColorCorrectionCoefficients [a11=" + a11 + ", a12=" + a12 + ", a13=" + a13 + ", a21=" + a21
                + ", a22=" + a22 + ", a23=" + a23 + ", a31=" + a31 + ", a32=" + a32 + ", a33=" + a33 + "]";
    }
}
