package de.pco.sdk;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

/**
 * Wrapper class that corresponds to the PCO_TIMESTAMP_STRUCT.
 * @author PCO
 *
 */
public class Timestamp 
{
    public long imgCounter;
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;
    public long microseconds;
    
    /////////////////////////////////// GENERATED
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + day;
        result = prime * result + hour;
        result = prime * result + (int) (imgCounter ^ (imgCounter >>> 32));
        result = prime * result + (int) (microseconds ^ (microseconds >>> 32));
        result = prime * result + minute;
        result = prime * result + month;
        result = prime * result + second;
        result = prime * result + year;
        return result;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Timestamp other = (Timestamp) obj;
        if (day != other.day)
            return false;
        if (hour != other.hour)
            return false;
        if (imgCounter != other.imgCounter)
            return false;
        if (microseconds != other.microseconds)
            return false;
        if (minute != other.minute)
            return false;
        if (month != other.month)
            return false;
        if (second != other.second)
            return false;
        if (year != other.year)
            return false;
        return true;
    }
    
    @Override
    public String toString() {
        return "Timestamp [imgCounter=" + imgCounter + ", year=" + year + ", month=" + month + ", day=" + day
                + ", hour=" + hour + ", minute=" + minute + ", second=" + second + ", microseconds=" + microseconds
                + "]";
    }
    
    
        
}
