package de.pco.sdk.enums;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

/**
 * Enumerator of the cameras including the family names.
 * @author PCO
 *
 */
public enum CameraType 
{
    UNDEFINED(0),
    PCO1200HS(0x0100),
    PCO1300(0x0200),
    PCO1600(0x0220),
    PCO2000(0x0240),
    PCO4000(0x0260),
    
 // pco.1300 types
    ROCHEHTC(0x0800), // Roche OEM
    XS284(0x00800),
    KODAK1300OEM(0x0820), // Kodak OEM
    
 // pco.1400 types
    PCO1400(0x0830),
    NEWGEN(0x0840),   // Roche OEM
    PROVEHR(0x0850),  // Zeiss OEM
    
 // pco.usb.pixelfly
    PCO_USBPIXELFLY(0x0900),
    
 // pco.dimax types
    PCO_DIMAX_STD(0x1000),
    PCO_DIMAX_TV(0x01010),
    
    PCO_DIMAX_AUTOMOTIVE(0x1020), // obsolete and not used for the pco.dimax, please remove from your sources!
    PCO_DIMAX_CS(0x1020),         // code is now used for pco.dimax CS
    
 // pco.sensicam types
    SC3_SONYQUE(0x1200),        // SC3 based - Sony 285
    SC3_EMTI(0x1210),           // SC3 based - TI 285SPD
    SC3_KODAK4800(0x1220),      // SC3 based - Kodak KAI-16000
    
 // pco.edge types
    PCO_EDGE(0x1300),       // pco.edge 5.5 (Sensor CIS2521) Interface: CameraLink , rolling shutter
    PCO_EDGE_42(0x1302),    // pco.edge 4.2 (Sensor CIS2020) Interface: CameraLink , rolling shutter
    PCO_EDGE_GL(0x1310),    // pco.edge 5.5 (Sensor CIS2521) Interface: CameraLink , global  shutter
    PCO_EDGE_USB3(0x1320),  // pco.edge     (all sensors   ) Interface: USB 3.0    ,(all shutter modes)
    PCO_EDGE_HS(0x1340),    // pco.edge     (all sensors   ) Interface: high speed ,(all shutter modes)
    PCO_EDGE_MT(0x1304),    // pco.edge MT2 (all sensors   ) Interface: CameraLink Base, rolling shutter
    
 // pco.flim types
    PCO_FLIM(0x1400),
 // pco.flow types
    PCO_FLOW(0x1500),
 // pco.panda types
    PCO_PANDA(0x1600),      // pco.panda (deprecated, use CAMERATYPE_PCO_FAMILY_PANDA for the future)
    
 // camera types for pco camera families
    PCO_FAMILY_PANDA(0x1600),   // pco.panda
    PCO_FAMILY_EDGE(0x1800),    // pco.edge
    PCO_FAMILY_DICAM(0x1700),   // pco.dicam
    PCO_FAMILY_DIMAX(0x1900),   // pco.dimax
    
    PCOUPDATE(0xFFFF);
    
    private int value;
    
    /**
     * Constructor
     * @param value
     */
    CameraType(int value) {
        this.value = value;
    }
    
    /**
     * Converter from the int value to the value of the enumerator
     * @param value
     * @return
     * @throws IllegalArgumentException
     */
    public static CameraType valueOf(int value) throws IllegalArgumentException 
    {
        for (CameraType e : values()) {
            if (e.value == value) {
                return e;
            }
        }
        return UNDEFINED;
    }
    
    /**
     * Checks if the enumerator value starts with PCO_FAMILY
     * @return
     */
    public boolean isCameraFamilyName() 
    {
        if (this.name().startsWith("PCO_FAMILY") == true) {
            return true;
        }
        else {
            return false;
        }
    }
    
    /**
     * Getter
     * @return
     */
    public int getValue() {
        return value;
    }
    
}
