package de.pco.sdk.enums;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

/**
 * Enumerator of the position of the timestamp
 * @author PCO
 *
 */
public enum TimestampPosition 
{
    NONE(0x00000),
    LEFT_TOP(0x0057E),
    MIRROR(0x1057E),
    FLIP(0x2057E),
    MIRROR_FLIP(0x3057E),
    NOT_IMPORTANT(0x4057E),
    UNDEFINED(0x7FFFF);

    private int value;
    
    /**
     * Constructor
     * @param value
     */
    TimestampPosition(int value) {
        this.value = value;
    }
    
    /**
     * Converter from the int value to the value of the enumerator.
     * @param value
     * @return
     * @throws IllegalArgumentException
     */
    public static TimestampPosition valueOf(int value) throws IllegalArgumentException 
    {
        if (value == 0) {
            return NONE;
        }
        int maskedValue = value & 0x000F0000;  
        switch (maskedValue) 
        {
            case 0x00000 : return LEFT_TOP;
            case 0x10000 : return MIRROR;
            case 0x20000 : return FLIP;
            case 0x30000 : return MIRROR_FLIP;
            case 0x40000 : return NOT_IMPORTANT;
            default : return UNDEFINED;  
        }
    }
    
    /**
     * Getter
     * @return
     */
    public int getValue() {
        return value;
    }
    
}
