package de.pco.common.exceptions;

/*-
 * #%L
 * pco-common
 * %%
 * Copyright (C) 2020 PCO
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

public enum PcoExceptionEnum 
{
    ///////////////////////// ENUM_VALUES
    UNDEFINED(0xFFFFFFFF);
    
    private int value;
    
    PcoExceptionEnum(int value) 
    {
        this.value = value;
    }
    
    /**
     * Convertor from the int value to the value of the enumerator
     * @param value
     * @return
     * @throws IllegalArgumentException
     */
    public static PcoExceptionEnum valueOf(int value) throws IllegalArgumentException 
    {
        for (PcoExceptionEnum e : values()) {
            if (e.value == value) {
                return e;
            }
        }
        return UNDEFINED;
    }
    
    public static PcoException getException(PcoExceptionEnum constant)
    {
        switch (constant) 
        {
            ////////////////////////////// EXCEPTION CLASSES
        }
        return new Warning(constant); // impossible
    }
    
    public PcoException getException() {
        return PcoExceptionEnum.getException(this);
    }
    
    
    public boolean isCommon() {
        if ((value & 0x20000000 >> 29) == 1) { 
            return true;
        }
        else {
            return false;
        }
    }
    
    public boolean isWarning() {
        if ((value & 0x40000000 >> 29) == 1) { 
            return true;
        }
        else {
            return false;
        }
    }
    
    public int getValue() {
        return this.value;
    }
    
    public static String getText(PcoExceptionEnum error) 
    {
        switch (error) 
        {
            /////////////////////////////// TEXT
        }
        return null;
    }
    
    public String getText() {
        return PcoExceptionEnum.getText(this);
    }
    
    
}
