/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.Attribute;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.NodeWithChildren;
import de.pdark.decentxml.Text;
import de.pdark.decentxml.XMLUtils;
import java.io.IOException;
import java.io.Writer;

public class XMLWriter
extends Writer {
    private final Writer writer;
    protected Node current;
    private String indent = null;
    private int level = 0;
    private boolean padCompact = false;

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    public void write(Node node, String s) throws IOException {
        this.current = node;
        this.writer.write(s);
    }

    public void writeAttributeValue(Node node, String value, char quoteChar) throws IOException {
        String escapeQuote;
        int pos;
        int start = pos = 0;
        String string = escapeQuote = quoteChar == '\"' ? "&quot;" : "&apos;";
        while (pos < value.length()) {
            char c = value.charAt(pos);
            String escape = null;
            if (c == quoteChar) {
                escape = escapeQuote;
            } else if (c == '&') {
                escape = "&amp;";
            } else if (c == '<') {
                escape = "&lt;";
            } else if (c == '>') {
                escape = "&gt;";
            }
            if (escape != null) {
                if (pos != start) {
                    this.write(node, value.substring(start, pos));
                }
                this.write(node, escape);
                start = pos + 1;
            }
            ++pos;
        }
        if (start < pos) {
            this.write(node, value.substring(start, pos));
        }
    }

    public void writeChildNodes(NodeWithChildren node) throws IOException {
        for (Node n : node.getNodes()) {
            n.toXML(this);
        }
    }

    public void write(Element e) throws IOException {
        this.writeBeginElement(e);
        this.writeChildNodes(e);
        this.writeEndElement(e);
    }

    public void writeEndElement(Element e) throws IOException {
        if (!this.isCompact(e)) {
            --this.level;
            if (this.indent != null && !this.hasSingleTextChild(e)) {
                this.nl();
                this.indent();
            }
            this.write(e, "</");
            this.write(e, e.getEndName());
            this.write(e, ">");
        }
    }

    public void writeBeginElement(Element e) throws IOException {
        if (this.indent != null && this.level > 0) {
            this.nl();
            this.indent();
        }
        this.write(e, "<");
        this.write(e, e.getBeginName());
        this.writeAttributes(e);
        this.write(e, e.getPostSpace());
        String end = ">";
        boolean compact = this.isCompact(e);
        if (compact) {
            end = this.padCompact && !" ".equals(e.getPostSpace()) ? " />" : "/>";
        }
        this.write(e, end);
        if (compact) {
            Element parent;
            if (this.indent != null && (parent = e.getParentElement()) != null) {
                Text t;
                Node n;
                int index = parent.nodeIndexOf(e);
                if (++index < parent.nodeCount() && XMLUtils.isText(n = parent.getNode(index)) && !(t = (Text)n).isWhitespace()) {
                    this.nl();
                    this.indent();
                }
            }
        } else {
            ++this.level;
            if (this.indent != null && !this.hasSingleTextChild(e) && e.hasNodes() && !XMLUtils.isElement(e.getNode(0))) {
                this.nl();
                this.indent();
            }
        }
    }

    public boolean isCompact(Element e) {
        return !e.hasNodes() && e.isCompactEmpty();
    }

    public boolean hasSingleTextChild(Element e) {
        if (e.nodeCount() != 1) {
            return false;
        }
        Node node = e.getNode(0);
        if (!XMLUtils.isText(node)) {
            return false;
        }
        Text t = (Text)node;
        return !t.isWhitespace();
    }

    public void indent() throws IOException {
        for (int i = 0; i < this.level; ++i) {
            this.writer.write(this.indent);
        }
    }

    public void nl() throws IOException {
        this.writer.write("\n");
    }

    public void writeAttributes(Element e) throws IOException {
        for (Attribute n : e.getAttributeMap().values()) {
            n.toXML(this);
        }
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public String getIndent() {
        return this.indent;
    }

    public void setPadCompact(boolean padCompact) {
        this.padCompact = padCompact;
    }

    public boolean isPadCompact() {
        return this.padCompact;
    }
}

