/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml.dtd;

import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLParseException;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLTokenizer;

public class DTDTokenizer
extends XMLTokenizer {
    protected int docTypeLevel;

    public DTDTokenizer(XMLSource source, int startPosition) {
        super(source);
        this.pos = startPosition;
    }

    public int getOffset() {
        return this.pos;
    }

    public Token next() {
        if (this.pos >= this.source.length() || this.docTypeLevel < 0) {
            return null;
        }
        Token token = this.createToken();
        char c = this.source.charAt(this.pos);
        switch (c) {
            case '[': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_BEGIN_SUBSET);
                ++this.docTypeLevel;
                break;
            }
            case ']': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_END_SUBSET);
                --this.docTypeLevel;
                break;
            }
            case '(': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_BEGIN_GROUP);
                ++this.docTypeLevel;
                break;
            }
            case ')': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_END_GROUP);
                --this.docTypeLevel;
                break;
            }
            case '?': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_ZERO_OR_ONE);
                break;
            }
            case '*': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_ZERO_OR_MORE);
                break;
            }
            case '+': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_ONE_OR_MORE);
                break;
            }
            case '|': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_ALTERNATIVE);
                break;
            }
            case ',': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_SEQUENCE);
                break;
            }
            case '<': {
                ++this.pos;
                this.parseDocTypeMarkupDeclaration(token);
                if (token.getType() == XMLTokenizer.Type.DOCTYPE) break;
                ++this.docTypeLevel;
                break;
            }
            case '>': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_END);
                --this.docTypeLevel;
                break;
            }
            case '\"': 
            case '\'': {
                ++this.pos;
                this.parseDocTypeQuotedText(token);
                break;
            }
            case '-': {
                ++this.pos;
                this.parseDocTypeComment(token);
                break;
            }
            case '#': {
                ++this.pos;
                this.parseDocTypeConstant(token);
                break;
            }
            case '%': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_PARAMETER_ENTITY);
                break;
            }
            case ';': {
                ++this.pos;
                token.setType(XMLTokenizer.Type.DOCTYPE_PARAMETER_ENTITY_END);
                break;
            }
            default: {
                if (Character.isWhitespace(c)) {
                    token.setType(XMLTokenizer.Type.DTD_WHITESPACE);
                    this.skipWhiteSpace();
                    break;
                }
                ++this.pos;
                this.parseDocTypeText(token);
            }
        }
        token.setEndOffset(this.pos);
        return token;
    }

    protected void parseDocTypeConstant(Token token) {
        int pos2;
        int errorOffset = this.pos - 1;
        int c = 0;
        if (this.pos < this.source.length()) {
            c = this.source.charAt(this.pos);
        }
        String expected = null;
        switch (c) {
            case 73: 
            case 105: {
                expected = "#IMPLIED";
                token.setType(XMLTokenizer.Type.DOCTYPE_IMPLIED);
                break;
            }
            case 80: 
            case 112: {
                expected = "#PCDATA";
                token.setType(XMLTokenizer.Type.DOCTYPE_PCDATA);
                break;
            }
            case 82: 
            case 114: {
                expected = "#REQUIRED";
                token.setType(XMLTokenizer.Type.DOCTYPE_REQUIRED);
                break;
            }
            case 70: 
            case 102: {
                expected = "#FIXED";
                token.setType(XMLTokenizer.Type.DOCTYPE_FIXED);
            }
        }
        String s = null;
        if (expected != null && (pos2 = errorOffset + expected.length()) < this.source.length()) {
            this.pos = pos2;
            s = this.source.substring(errorOffset, pos2);
        }
        if (expected == null || s == null) {
            throw new XMLParseException("Expected '#IMPLIED' or '#PCDATA'" + this.lookAheadForErrorMessage("but found", errorOffset, 20), this.source, errorOffset);
        }
        if (!expected.equalsIgnoreCase(s)) {
            throw new XMLParseException("Expected '" + expected + "'", this.source, errorOffset);
        }
    }

    protected void parseDocTypeComment(Token token) {
        this.expect('-');
        while (this.pos < this.source.length()) {
            char c = this.source.charAt(this.pos);
            if (c == '-' && (c = this.nextChar("Expected '--'")) == '-') {
                ++this.pos;
                break;
            }
            ++this.pos;
        }
        token.setType(XMLTokenizer.Type.DOCTYPE_COMMENT);
    }

    protected void parseDocTypeText(Token token) {
        token.setType(XMLTokenizer.Type.TEXT);
        --this.pos;
        while (this.pos < this.source.length() && this.getCharValidator().isNameChar(this.source.charAt(this.pos))) {
            ++this.pos;
        }
        String s = this.source.substring(token.getStartOffset(), this.pos);
        if (s.length() == 0) {
            throw new XMLParseException("Expected some text" + this.lookAheadForErrorMessage("but found", token.getStartOffset(), 20), token);
        }
        if ("SYSTEM".equals(s)) {
            token.setType(XMLTokenizer.Type.DOCTYPE_SYSTEM);
        } else if ("PUBLIC".equals(s)) {
            token.setType(XMLTokenizer.Type.DOCTYPE_PUBLIC);
        } else if ("NDATA".equals(s)) {
            token.setType(XMLTokenizer.Type.DOCTYPE_NDATA);
        }
    }

    protected void parseDocTypeQuotedText(Token token) {
        char c;
        token.setType(XMLTokenizer.Type.DOCTYPE_QUOTED_TEXT);
        int errorPos = this.pos - 1;
        char quoteChar = this.source.charAt(errorPos);
        boolean insideEntity = false;
        int entityStartPos = this.pos - 1;
        while (this.pos < this.source.length() && (c = this.source.charAt(this.pos)) != quoteChar) {
            if (c == '&') {
                entityStartPos = this.pos;
                insideEntity = true;
            } else if (c == ';') {
                if (insideEntity) {
                    this.verifyEntity(entityStartPos, this.pos + 1);
                }
                insideEntity = false;
            } else {
                String msg = this.getCharValidator().isValid(this.source, this.pos);
                if (msg != null) {
                    throw new XMLParseException("Illegal character found in quoted text. " + msg, this.source, this.pos);
                }
            }
            this.skipChar(c);
        }
        if (insideEntity) {
            throw new XMLParseException("Missing ';' after '&': " + this.lookAheadForErrorMessage(null, entityStartPos, 20), this.source, entityStartPos);
        }
        if (this.pos >= this.source.length()) {
            throw new XMLParseException("Couldn't find closing quote", this.getSource(), errorPos);
        }
        ++this.pos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseDocTypeMarkupDeclaration(Token token) {
        int errorPos = this.pos - 1;
        this.expect('!');
        char c = this.nextChar("Unexpeted end of file while reading doctype markup declaration");
        if (c == 'E') {
            c = this.nextChar("Unexpeted end of file while reading doctype markup declaration");
            if (c == 'L') {
                this.nextChars("<!ELEMENT", errorPos, "Expected '<!ELEMENT'");
                token.setType(XMLTokenizer.Type.DOCTYPE_ELEMENT);
                return;
            } else {
                if (c != 'N') throw new XMLParseException("Expected '<!ELEMENT' or '<!ENTITY'", this.source, errorPos);
                this.nextChars("<!ENTITY", errorPos, "Expected '<!ENTITY'");
                token.setType(XMLTokenizer.Type.DOCTYPE_ENTITY);
            }
            return;
        } else if (c == 'A') {
            this.nextChars("<!ATTLIST", errorPos, "Expected '<!ATTLIST'");
            token.setType(XMLTokenizer.Type.DOCTYPE_ATTLIST);
            return;
        } else if (c == 'N') {
            this.nextChars("<!NOTATION", errorPos, "Expected '<!NOTATION'");
            token.setType(XMLTokenizer.Type.DOCTYPE_NOTATION);
            return;
        } else {
            if (c == '-') {
                --this.docTypeLevel;
                this.parseComment(token);
                return;
            }
            if (c != 'D') throw new XMLParseException("Expected '<!ATTLIST', '<!DOCTYPE', '<!ELEMENT' or '<!ENTITY'", this.source, errorPos);
            this.nextChars("<!DOCTYPE", errorPos, "Expected '<!DOCTYPE'");
            token.setType(XMLTokenizer.Type.DOCTYPE);
        }
    }
}

