/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.googlemaps;

import de.pentabyte.googlemaps.StaticLatLon;
import de.pentabyte.googlemaps.StaticLatLonImpl;
import de.pentabyte.googlemaps.StaticPath;
import java.util.Collection;

public class InternalBoundingBox {
    private double latMin = Double.POSITIVE_INFINITY;
    private double latMax = Double.NEGATIVE_INFINITY;
    private double lonMin = Double.POSITIVE_INFINITY;
    private double lonMax = Double.NEGATIVE_INFINITY;
    private double latCenter;
    private double lonCenter;
    private double latRange;
    private double lonRange;

    protected InternalBoundingBox(Collection<? extends StaticLatLon> coords) {
        for (StaticLatLon staticLatLon : coords) {
            if (staticLatLon.getLatitude() > this.latMax) {
                this.latMax = staticLatLon.getLatitude();
            }
            if (staticLatLon.getLatitude() < this.latMin) {
                this.latMin = staticLatLon.getLatitude();
            }
            if (staticLatLon.getLongitude() > this.lonMax) {
                this.lonMax = staticLatLon.getLongitude();
            }
            if (!(staticLatLon.getLongitude() < this.lonMin)) continue;
            this.lonMin = staticLatLon.getLongitude();
        }
        this.latCenter = (this.latMin + this.latMax) / 2.0;
        this.lonCenter = (this.lonMin + this.lonMax) / 2.0;
        this.latRange = this.latMax - this.latMin;
        this.lonRange = this.lonMax - this.lonMin;
    }

    protected boolean contains(StaticLatLon coord) {
        double lat = coord.getLatitude();
        double lon = coord.getLongitude();
        return lat >= this.latMin && lat <= this.latMax && lon >= this.lonMin && lon <= this.lonMax;
    }

    protected boolean squareContains(StaticLatLon coord) {
        return this.squareContains(coord, 1.0);
    }

    protected boolean squareContains(StaticLatLon coord, double deviation) {
        double latEdge = this.latRange * deviation;
        double lonEdge = this.lonRange * deviation;
        double latMin = this.latCenter - latEdge / 2.0;
        double latMax = this.latCenter + latEdge / 2.0;
        double lonMin = this.lonCenter - lonEdge / 2.0;
        double lonMax = this.lonCenter + lonEdge / 2.0;
        double lat = coord.getLatitude();
        double lon = coord.getLongitude();
        return lat >= latMin && lat <= latMax && lon >= lonMin && lon <= lonMax;
    }

    protected double getLatitude() {
        return this.latCenter;
    }

    protected double getLongitude() {
        return this.lonCenter;
    }

    protected double getHeightMeters() {
        StaticLatLonImpl upperLeft = new StaticLatLonImpl(this.latMax, this.lonMin);
        StaticLatLonImpl bottomLeft = new StaticLatLonImpl(this.latMin, this.lonMin);
        return StaticPath.distanceAuto(upperLeft, bottomLeft);
    }

    protected StaticLatLon getUpperLeft() {
        return new StaticLatLonImpl(this.latMax, this.lonMin);
    }

    protected StaticLatLon getUpperRight() {
        return new StaticLatLonImpl(this.latMax, this.lonMax);
    }

    protected StaticLatLon getLowerLeft() {
        return new StaticLatLonImpl(this.latMin, this.lonMin);
    }

    protected StaticLatLon getLowerRight() {
        return new StaticLatLonImpl(this.latMin, this.lonMax);
    }

    protected StaticLatLon getCenter() {
        return new StaticLatLonImpl(this.latCenter, this.lonCenter);
    }

    protected double getLatRange() {
        return this.latRange;
    }

    protected double getLonRange() {
        return this.lonRange;
    }
}

