/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.googlemaps;

public class PolylineEncoder {
    private StringBuffer buffer = new StringBuffer();
    private int prevLat = 0;
    private int prevLon = 0;

    private void encodeSignedNumber(int num) {
        int sgn_num = num << 1;
        if (num < 0) {
            sgn_num ^= 0xFFFFFFFF;
        }
        this.encodeNumber(sgn_num);
    }

    private void encodeNumber(int num) {
        while (num >= 32) {
            int nextValue = (0x20 | num & 0x1F) + 63;
            this.buffer.append((char)nextValue);
            num >>= 5;
        }
        this.buffer.append((char)(num += 63));
    }

    public void add(double latitude, double longitude) {
        int lat = (int)(latitude * 100000.0);
        int lon = (int)(longitude * 100000.0);
        this.encodeSignedNumber(lat - this.prevLat);
        this.encodeSignedNumber(lon - this.prevLon);
        this.prevLat = lat;
        this.prevLon = lon;
    }

    public String toString() {
        return this.buffer.toString();
    }
}

