/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.googlemaps;

import de.pentabyte.googlemaps.StaticLatLon;
import de.pentabyte.googlemaps.StaticLatLonImpl;
import de.pentabyte.googlemaps.StaticLocation;
import de.pentabyte.googlemaps.StaticMarker;
import de.pentabyte.googlemaps.StaticPath;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.http.client.utils.URIBuilder;

public class StaticMap
implements Serializable {
    private static final long serialVersionUID = 155958884165520846L;
    private static String API_URL = "https://maps.googleapis.com/maps/api/staticmap";
    private final int width;
    private final int height;
    private String apiKey;
    private Maptype maptype;
    private int scale = 1;
    private StaticLocation center;
    private Integer zoom;
    private List<StaticMarker> markers;
    private List<StaticPath> paths;
    private Locale locale;

    public StaticMap(int width, int height, String apiKey) {
        if (width > 640) {
            throw new IllegalArgumentException("width must not exceed 640");
        }
        this.width = width;
        this.height = height;
        this.apiKey = apiKey;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setLocation(StaticLocation center, int zoom) {
        this.center = center;
        this.zoom = zoom;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidthPoints() {
        return this.width / this.scale;
    }

    public int getHeightPoints() {
        return this.height / this.scale;
    }

    public List<StaticMarker> getMarkers() {
        return this.markers;
    }

    public void setMarkers(List<StaticMarker> markers) {
        this.markers = markers;
    }

    public void addMarker(StaticMarker marker) {
        if (this.markers == null) {
            this.markers = new ArrayList<StaticMarker>();
        }
        this.markers.add(marker);
    }

    public List<StaticPath> getPaths() {
        return this.paths;
    }

    public void setPaths(List<StaticPath> paths) {
        this.paths = paths;
    }

    public void addPath(StaticPath path) {
        if (this.paths == null) {
            this.paths = new ArrayList<StaticPath>();
        }
        this.paths.add(path);
    }

    public String toString() {
        try {
            URIBuilder builder = new URIBuilder(API_URL);
            builder.addParameter("size", this.width + "x" + this.height);
            if (this.center != null && this.zoom != null) {
                builder.addParameter("center", this.center.toString());
                builder.addParameter("zoom", this.zoom.toString());
            }
            if (this.scale != 1) {
                builder.addParameter("scale", String.valueOf(this.scale));
            }
            if (this.maptype != null) {
                builder.addParameter("maptype", this.maptype.name());
            }
            if (this.getZoom() != null) {
                builder.addParameter("zoom", String.valueOf(this.getZoom()));
            }
            if (this.markers != null) {
                for (StaticMarker marker : this.markers) {
                    builder.addParameter("markers", marker.toString());
                }
            }
            if (this.paths != null) {
                for (StaticPath path : this.paths) {
                    if (path.getCoords() != null) {
                        InternalBoundingBox box = new InternalBoundingBox(path.getCoords());
                        double minDistance = box.getHeightMeters() / (double)Math.max(this.getHeight(), this.getWidth());
                        builder.addParameter("path", path.formatFor(minDistance, 40));
                        continue;
                    }
                    builder.addParameter("path", path.formatFor(0.0, 0));
                }
            }
            if (this.apiKey != null) {
                builder.addParameter("key", this.apiKey);
            }
            if (this.locale != null && this.locale.getLanguage() != null) {
                builder.addParameter("language", this.locale.getLanguage());
            }
            String url = builder.build().toString();
            return url.replace("%3A", ":").replace("%40", "@");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("kann nicht sein", e);
        }
    }

    private Integer getZoom() {
        StaticMarker marker;
        if (this.markers != null && this.markers.size() == 1 && (this.paths == null || this.paths.size() == 0) && (marker = this.markers.get(0)).getZoom() != null) {
            return marker.getZoom();
        }
        return null;
    }

    public Maptype getMaptype() {
        return this.maptype;
    }

    public void setMaptype(Maptype maptype) {
        this.maptype = maptype;
    }

    public boolean hasContent() {
        return this.markers.size() > 0 || this.paths.size() > 0;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private static class InternalBoundingBox {
        private double latMin = Double.POSITIVE_INFINITY;
        private double latMax = Double.NEGATIVE_INFINITY;
        private double lonMin = Double.POSITIVE_INFINITY;
        private double lonMax = Double.NEGATIVE_INFINITY;
        private double latCenter;
        private double lonCenter;
        private double latRange;
        private double lonRange;

        protected InternalBoundingBox(Collection<? extends StaticLatLon> coords) {
            for (StaticLatLon staticLatLon : coords) {
                if (staticLatLon.getLatitude() > this.latMax) {
                    this.latMax = staticLatLon.getLatitude();
                }
                if (staticLatLon.getLatitude() < this.latMin) {
                    this.latMin = staticLatLon.getLatitude();
                }
                if (staticLatLon.getLongitude() > this.lonMax) {
                    this.lonMax = staticLatLon.getLongitude();
                }
                if (!(staticLatLon.getLongitude() < this.lonMin)) continue;
                this.lonMin = staticLatLon.getLongitude();
            }
            this.latCenter = (this.latMin + this.latMax) / 2.0;
            this.lonCenter = (this.lonMin + this.lonMax) / 2.0;
            this.latRange = this.latMax - this.latMin;
            this.lonRange = this.lonMax - this.lonMin;
        }

        protected boolean contains(StaticLatLon coord) {
            double lat = coord.getLatitude();
            double lon = coord.getLongitude();
            return lat >= this.latMin && lat <= this.latMax && lon >= this.lonMin && lon <= this.lonMax;
        }

        protected boolean squareContains(StaticLatLon coord) {
            return this.squareContains(coord, 1.0);
        }

        protected boolean squareContains(StaticLatLon coord, double deviation) {
            double latEdge = this.latRange * deviation;
            double lonEdge = this.lonRange * deviation;
            double latMin = this.latCenter - latEdge / 2.0;
            double latMax = this.latCenter + latEdge / 2.0;
            double lonMin = this.lonCenter - lonEdge / 2.0;
            double lonMax = this.lonCenter + lonEdge / 2.0;
            double lat = coord.getLatitude();
            double lon = coord.getLongitude();
            return lat >= latMin && lat <= latMax && lon >= lonMin && lon <= lonMax;
        }

        protected double getLatitude() {
            return this.latCenter;
        }

        protected double getLongitude() {
            return this.lonCenter;
        }

        protected double getHeightMeters() {
            StaticLatLonImpl upperLeft = new StaticLatLonImpl(this.latMax, this.lonMin);
            StaticLatLonImpl bottomLeft = new StaticLatLonImpl(this.latMin, this.lonMin);
            return StaticPath.distanceAuto(upperLeft, bottomLeft);
        }

        protected StaticLatLon getUpperLeft() {
            return new StaticLatLonImpl(this.latMax, this.lonMin);
        }

        protected StaticLatLon getUpperRight() {
            return new StaticLatLonImpl(this.latMax, this.lonMax);
        }

        protected StaticLatLon getLowerLeft() {
            return new StaticLatLonImpl(this.latMin, this.lonMin);
        }

        protected StaticLatLon getLowerRight() {
            return new StaticLatLonImpl(this.latMin, this.lonMax);
        }

        protected StaticLatLon getCenter() {
            return new StaticLatLonImpl(this.latCenter, this.lonCenter);
        }

        protected double getLatRange() {
            return this.latRange;
        }

        protected double getLonRange() {
            return this.lonRange;
        }
    }

    public static enum Maptype {
        roadmap,
        satellite,
        hybrid,
        terrain;

    }
}

