/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.googlemaps;

import de.pentabyte.googlemaps.StaticColor;
import de.pentabyte.googlemaps.StaticLocation;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class StaticMarker
implements Serializable {
    private static final long serialVersionUID = -2566197476723898328L;
    private String color;
    private Character label;
    private final StaticLocation location;
    private String customIconUrl;
    private String anchor;
    private boolean shadow = true;
    private Integer zoom;
    private Integer zIndex;

    public StaticMarker(double lat, double lon) {
        this.location = new StaticLocation(lat, lon);
    }

    public StaticMarker(String query) {
        this.location = new StaticLocation(query);
    }

    public void setHexColor(String hexColor) {
        this.color = "0x" + hexColor;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(StaticColor color) {
        this.color = color.name();
    }

    public Character getLabel() {
        return this.label;
    }

    public void setLabel(Character label) {
        this.label = label;
    }

    public String getCustomIconUrl() {
        return this.customIconUrl;
    }

    public void setCustomIconUrl(String customIconUrl) {
        this.customIconUrl = customIconUrl;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public String toString() {
        ArrayList<String> defs = new ArrayList<String>();
        ArrayList<String> styles = new ArrayList<String>();
        if (this.color != null) {
            styles.add("color:" + this.color);
        }
        if (this.label != null) {
            styles.add("label:" + String.valueOf(this.label));
        }
        if (this.anchor != null) {
            styles.add("anchor:" + this.anchor);
        }
        if (this.customIconUrl != null) {
            styles.add("icon:" + this.customIconUrl);
            styles.add("scale:2");
            if (!this.shadow) {
                styles.add("shadow:false");
            }
        }
        if (styles.size() > 0) {
            defs.add(StringUtils.join(styles, (String)"|"));
        }
        defs.add(this.location.toString());
        return StringUtils.join(defs, (char)'|');
    }

    public Integer getzIndex() {
        return this.zIndex;
    }

    public void setzIndex(Integer zIndex) {
        this.zIndex = zIndex;
    }
}

