/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.maven.i18n.format.java;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class IndentedFileWriter {
    Writer writer;
    int indentation = 0;

    public IndentedFileWriter(File file) throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
    }

    public void writeLine(String line) throws IOException {
        for (int i = 0; i < this.indentation; ++i) {
            this.writer.write("\t");
        }
        this.writer.write(line + "\n");
    }

    public void incrementIndentation() {
        ++this.indentation;
    }

    public void decrementIndentation() {
        if (this.indentation == 0) {
            throw new RuntimeException("not possible");
        }
        --this.indentation;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void emptyLine() throws IOException {
        this.writer.write("\n");
    }

    public CommentWriter createCommentWriter() throws IOException {
        return new CommentWriter(this);
    }

    public CurlyBracketWriter createCurlyBracketWriter(String comment, String firstLine) throws IOException {
        this.emptyLine();
        this.writeComment(comment);
        return new CurlyBracketWriter(this, firstLine);
    }

    public void writeComment(String comment) throws IOException {
        if (comment != null && comment.length() > 0) {
            CommentWriter writer = this.createCommentWriter();
            writer.writeLines(comment.split("\n"));
            writer.close();
        }
    }

    public static class CurlyBracketWriter {
        final IndentedFileWriter fileWriter;

        public CurlyBracketWriter(IndentedFileWriter fileWriter, String firstLine) throws IOException {
            this.fileWriter = fileWriter;
            fileWriter.writeLine(firstLine + " {");
            fileWriter.incrementIndentation();
        }

        public void writeLine(String line) throws IOException {
            this.fileWriter.writeLine(line);
        }

        public void close() throws IOException {
            this.fileWriter.decrementIndentation();
            this.fileWriter.writeLine("}");
        }
    }

    public static class CommentWriter {
        final IndentedFileWriter fileWriter;

        public CommentWriter(IndentedFileWriter fileWriter) throws IOException {
            this.fileWriter = fileWriter;
            fileWriter.writeLine("/**");
        }

        public void writeLine(String line) throws IOException {
            this.fileWriter.writeLine(" * " + line);
        }

        public void writeLines(String[] lines) throws IOException {
            for (String line : lines) {
                this.writeLine(line);
            }
        }

        public void close() throws IOException {
            this.fileWriter.writeLine(" */");
        }
    }
}

