/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.maven.i18n.format.java;

import de.pentabyte.maven.i18n.format.java.IndentedFileWriter;
import de.pentabyte.tools.i18n.core.EntryNode;
import de.pentabyte.tools.i18n.core.JavaAccessor;
import de.pentabyte.tools.i18n.core.Table;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class JavaAccessorCreator {
    private final Table table;
    private final String keySeparator;
    private final File targetDir;
    private final String messagesBaseName;
    static Pattern PLACEHOLDER = Pattern.compile("\\{(\\d+)(,[^\\}]+)?\\}");

    public JavaAccessorCreator(Table table, String keySeparator, File targetDir, String messagesBaseName) {
        this.table = table;
        this.keySeparator = keySeparator;
        this.targetDir = targetDir;
        this.messagesBaseName = messagesBaseName;
    }

    public void write(Log log, JavaAccessor accessor) throws IOException {
        File accessorFile = new File(this.targetDir, accessor.getPackageName().replace('.', '/') + "/" + accessor.getClassName() + ".java");
        log.info((CharSequence)("NOW creating JAVA accessor in targetDir: " + accessorFile));
        accessorFile.getParentFile().mkdirs();
        String fileComment = "AUTO-GENERATED from schema file with i18n-maven-plugin.\nPlease do not edit this file manually!";
        IndentedFileWriter writer = new IndentedFileWriter(accessorFile);
        writer.writeLine("package " + accessor.getPackageName() + ";");
        writer.emptyLine();
        writer.writeLine("import java.text.MessageFormat;");
        writer.writeLine("import java.util.Locale;");
        writer.writeLine("import java.util.ResourceBundle;");
        writer.emptyLine();
        writer.writeComment(fileComment);
        IndentedFileWriter.CurlyBracketWriter classWriter = writer.createCurlyBracketWriter(null, "public class " + accessor.getClassName());
        classWriter.writeLine("private static String BASE_NAME = \"" + this.messagesBaseName + "\";");
        for (Map.Entry<String, EntryNode> entry : this.table.createHierarchy(this.keySeparator).entrySet()) {
            this.writeEntry(writer, accessor, entry, "");
        }
        classWriter.writeLine("public static String translate(Locale locale, String key, Object... params) {");
        classWriter.writeLine("\tResourceBundle bundle = ResourceBundle.getBundle(BASE_NAME, locale);");
        classWriter.writeLine("\tString pattern = bundle.getString(key);");
        classWriter.writeLine("\treturn (new MessageFormat(pattern, locale)).format(params);");
        classWriter.writeLine("}");
        classWriter.close();
        writer.close();
    }

    private void writeEntry(IndentedFileWriter writer, JavaAccessor accessor, Map.Entry<String, EntryNode> entry, String prefix) throws IOException {
        this.writeMethod(writer, accessor, entry, prefix);
        if (entry.getValue().getNodes().size() > 0) {
            IndentedFileWriter.CurlyBracketWriter classWriter = writer.createCurlyBracketWriter(entry.getValue().getDescription(), "public static class " + this.escapeClassName(entry.getKey()));
            String newPrefix = prefix + entry.getKey() + ".";
            for (Map.Entry<String, EntryNode> e : entry.getValue().getNodes().entrySet()) {
                this.writeEntry(writer, accessor, e, newPrefix);
            }
            classWriter.close();
        }
    }

    private void writeMethod(IndentedFileWriter writer, JavaAccessor accessor, Map.Entry<String, EntryNode> entry, String prefix) throws IOException {
        Map<String, String> textMap = entry.getValue().getTextMap();
        if (textMap.size() > 0) {
            String args;
            String argsWithType;
            String key = entry.getKey();
            Integer max = null;
            for (String text : entry.getValue().getTextMap().values()) {
                Matcher matcher = PLACEHOLDER.matcher(text);
                while (matcher.find()) {
                    int candidate = Integer.parseInt(matcher.group(1));
                    if (max != null && max >= candidate) continue;
                    max = candidate;
                }
            }
            if (max == null) {
                argsWithType = "";
                args = "";
            } else {
                ArrayList<String> list1 = new ArrayList<String>();
                ArrayList<String> list2 = new ArrayList<String>();
                for (int i = 0; i <= max; ++i) {
                    list1.add("param" + i);
                    list2.add("Object param" + i);
                }
                argsWithType = ", " + StringUtils.join(list2, (String)", ");
                args = ", " + StringUtils.join(list1, (String)", ");
            }
            String comment = "";
            if (StringUtils.isNotEmpty((CharSequence)entry.getValue().getDescription())) {
                comment = entry.getValue().getDescription() + "\n\n";
            }
            comment = comment + "Example: \"" + entry.getValue().getTextMap().entrySet().iterator().next().getValue() + "\"";
            writer.writeComment(comment);
            writer.writeLine("public static final String " + this.escapeIdentifier(key) + "$ = \"" + prefix + key + "\";");
            IndentedFileWriter.CurlyBracketWriter methodWriter = writer.createCurlyBracketWriter(comment, "public static String " + this.escapeMethodName(key) + "$(Locale locale" + argsWithType + ")");
            methodWriter.writeLine("return " + this.escapeClassName(accessor.getClassName()) + ".translate(locale, " + this.escapeIdentifier(key) + "$" + args + ");");
            methodWriter.close();
        }
    }

    private String escapeIdentifier(String identifier) {
        if (!SourceVersion.isName(identifier)) {
            throw new RuntimeException("[" + identifier + "] is no valid identifier.");
        }
        return identifier;
    }

    private String escapeMethodName(String name) {
        if (!SourceVersion.isName(name)) {
            throw new RuntimeException("[" + name + "] is no valid method name.");
        }
        return name;
    }

    private String escapeClassName(String key) {
        if (!SourceVersion.isName(key)) {
            throw new RuntimeException("[" + key + "] is no valid class name.");
        }
        return key;
    }
}

