/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.maven.i18n.format.javascript;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.pentabyte.maven.i18n.output.LanguageFileWriter;
import de.pentabyte.tools.i18n.core.Entry;
import de.pentabyte.tools.i18n.core.ExportedLocale;
import de.pentabyte.tools.i18n.core.LanguageFileFormat;
import de.pentabyte.tools.i18n.core.Output;
import de.pentabyte.tools.i18n.core.Table;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class JavascriptWriter
implements LanguageFileWriter {
    @Override
    public void write(File tableDirectory, String inputBasename, Output output, ExportedLocale locale, Table table, String fileComment) throws FileNotFoundException, IOException {
        String suffix = StringUtils.isEmpty((CharSequence)locale.getValue()) ? "" : "_" + locale.getValue();
        LinkedHashMap<String, Object> structure = new LinkedHashMap<String, Object>();
        for (String key : table.getEntries().keySet()) {
            Entry entry = table.getEntries().get(key);
            if (entry.getTextMap().size() <= 0) continue;
            String value = table.getEntryText(key, locale.getValue());
            JavascriptWriter.addToStructure(structure, key, value, ".");
        }
        String resultingBasename = output.getBasename() == null ? (inputBasename == null ? "messages" : inputBasename) : output.getBasename();
        ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter().without(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        PrintWriter writer = new PrintWriter(new File(output.getDirectory(), resultingBasename + suffix + "." + LanguageFileFormat.JAVASCRIPT.getExtension()));
        writer.write("/* " + fileComment + " */\n\n");
        writer.write("var " + resultingBasename + " = ");
        ow.writeValue((Writer)writer, structure);
        writer.write(";");
        writer.close();
    }

    private static void addToStructure(Map<String, Object> structure, String key, String value, String keySeparator) {
        String[] parts = key.split(Pattern.quote(keySeparator));
        String top = parts[0];
        if (parts.length == 1) {
            structure.put(top + "$", value);
        } else {
            LinkedHashMap<String, Object> subStructure = (LinkedHashMap<String, Object>)structure.get(top);
            if (subStructure == null) {
                subStructure = new LinkedHashMap<String, Object>();
            }
            structure.put(top, subStructure);
            JavascriptWriter.addToStructure(subStructure, key.substring((top + keySeparator).length()), value, keySeparator);
        }
    }
}

