/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.tools.i18n;

import de.pentabyte.tools.i18n.core.LanguageFileFormat;
import de.pentabyte.tools.i18n.core.TableProducer;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class TranslatePlugin
extends AbstractMojo {
    private File tableFile;
    private File tableDirectory;
    private File outputDirectory;
    private String inputBasename;
    private String outputBasename;
    private LanguageFileFormat outputFormat;
    private String keySeparator;
    private File targetDir;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Run-Configuration: (tableFile=" + this.tableFile + ", tableDirectory=" + this.tableDirectory + ", inputBasename=" + this.inputBasename + ", outputDirectory=" + this.outputDirectory + ", outputBasename=" + this.outputBasename + " (default: " + this.inputBasename + "), outputFormat=" + (Object)((Object)this.outputFormat) + ", keySeparator=" + this.keySeparator + ", targetDir=" + this.targetDir + ")"));
        if (this.tableFile != null) {
            try {
                TableProducer.transformFile(this.tableFile, this.outputDirectory, this.outputBasename, this.outputFormat, this.getLog(), this.keySeparator, this.targetDir);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error translating tableFile [" + this.tableFile + "]", e);
            }
            if (this.tableDirectory != null) {
                this.getLog().warn((CharSequence)"Skipping tableDirectory, because tableFile was set");
            }
        } else if (this.tableDirectory != null) {
            try {
                TableProducer.transformRecursively(this.tableDirectory, this.inputBasename, this.outputBasename, this.outputFormat, this.getLog(), this.keySeparator, this.targetDir);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error translating tableDirectory [" + this.tableDirectory + "]", e);
            }
        }
    }
}

