/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.tools.i18n.core;

import de.pentabyte.tools.i18n.core.Entry;
import de.pentabyte.tools.i18n.core.EntryNode;
import de.pentabyte.tools.i18n.core.ExportedLocale;
import de.pentabyte.tools.i18n.core.Output;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Table {
    private static Pattern PLACHOLDER_PATTERN = Pattern.compile("\\$\\{([^\\}]*)\\}");
    private List<ExportedLocale> exportedLocales;
    private Map<String, Entry> entries;
    private List<Output> output;

    public List<ExportedLocale> getExportedLocales() {
        if (this.exportedLocales == null) {
            this.exportedLocales = new ArrayList<ExportedLocale>();
        }
        return this.exportedLocales;
    }

    public void setExportedLocales(List<ExportedLocale> exportedLocales) {
        this.exportedLocales = exportedLocales;
    }

    public Map<String, Entry> getEntries() {
        if (this.entries == null) {
            this.entries = new LinkedHashMap<String, Entry>();
        }
        return this.entries;
    }

    public List<Output> getOutput() {
        if (this.output == null) {
            this.output = new ArrayList<Output>();
        }
        return this.output;
    }

    public void setOutput(List<Output> output) {
        this.output = output;
    }

    public String getEntryText(String key, String locale) {
        Entry entry = this.getEntries().get(key);
        if (entry == null) {
            throw new IllegalArgumentException("There is no key [" + key + "] for locale [" + locale + "]");
        }
        String value = entry.getTextMap().get(locale);
        if (value == null) {
            value = entry.getTextMap().get("");
        }
        if (value == null) {
            ExportedLocale exportedLocale = this.findExportedLocale(locale);
            if (exportedLocale == null) {
                throw new RuntimeException("The locale [" + locale + "] will not be exported.");
            }
            if (exportedLocale.getFallback() != null) {
                value = this.getEntryText(key, exportedLocale.getFallback());
            }
        }
        if (value == null) {
            throw new RuntimeException("Value is null for key [" + key + "] and locale [" + locale + "]");
        }
        Matcher m = PLACHOLDER_PATTERN.matcher(value);
        while (m.find()) {
            String find = m.group();
            String mnemonic = m.group(1);
            String replace = this.getEntryText(mnemonic, locale);
            value = value.replace(find, replace);
        }
        return value;
    }

    public ExportedLocale findExportedLocale(String locale) {
        for (ExportedLocale exported : this.getExportedLocales()) {
            if (!exported.getValue().equals(locale)) continue;
            return exported;
        }
        return null;
    }

    public Map<String, EntryNode> createHierarchy(String keySeparator) {
        LinkedHashMap<String, EntryNode> nodes = new LinkedHashMap<String, EntryNode>();
        for (Map.Entry<String, Entry> entry : this.getEntries().entrySet()) {
            String key = entry.getKey();
            Entry e = entry.getValue();
            String[] parts = key.split(Pattern.quote(keySeparator));
            EntryNode node = (EntryNode)nodes.get(parts[0]);
            if (node == null) {
                node = new EntryNode();
                nodes.put(parts[0], node);
            }
            for (int level = 0; level < parts.length; ++level) {
                if (level > 0) {
                    String keyFragment = parts[level];
                    EntryNode nextLevel = node.getNodes().get(keyFragment);
                    if (nextLevel == null) {
                        nextLevel = new EntryNode();
                        node.getNodes().put(keyFragment, nextLevel);
                        node.setDescription(e.getDescription());
                    }
                    node = nextLevel;
                }
                if (level != parts.length - 1) continue;
                node.getTextMap().putAll(e.getTextMap());
                node.setDescription(e.getDescription());
            }
        }
        return nodes;
    }
}

