/*
 * Decompiled with CFR 0.152.
 */
package de.pentabyte.tools.i18n.core;

import de.pentabyte.maven.i18n.format.java.JavaAccessorCreator;
import de.pentabyte.maven.i18n.format.java.JavaPropertiesWriter;
import de.pentabyte.maven.i18n.format.javascript.JavascriptWriter;
import de.pentabyte.maven.i18n.format.strings.StringsWriter;
import de.pentabyte.maven.i18n.output.LanguageFileWriter;
import de.pentabyte.tools.i18n.core.Constants;
import de.pentabyte.tools.i18n.core.Entry;
import de.pentabyte.tools.i18n.core.EntryNode;
import de.pentabyte.tools.i18n.core.ExportedLocale;
import de.pentabyte.tools.i18n.core.JavaAccessor;
import de.pentabyte.tools.i18n.core.LanguageFileFormat;
import de.pentabyte.tools.i18n.core.Output;
import de.pentabyte.tools.i18n.core.Table;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TableProducer {
    static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static void transformFile(File inputFile, File outputDirectory, String outputBasename, LanguageFileFormat outputFormat, Log log, String keySeparator, File targetDir) {
        if (outputDirectory == null) {
            outputDirectory = inputFile.getParentFile();
        }
        try {
            log.info((CharSequence)("processing: " + inputFile));
            TableProducer.transformXML(log, inputFile, FilenameUtils.getBaseName((String)inputFile.getName()), inputFile.getParentFile(), outputDirectory, outputBasename, outputFormat, keySeparator, targetDir);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem with [" + inputFile.getAbsolutePath() + "]", e);
        }
    }

    public static void transformRecursively(File tableDirectory, String inputBasename, String outputBasename, LanguageFileFormat outputFormat, Log log, String keySeparator, File targetDir) {
        File[] files;
        if (!tableDirectory.exists()) {
            throw new RuntimeException(tableDirectory + " does not exist!");
        }
        String inputFilename = inputBasename + ".xml";
        for (File file : files = tableDirectory.listFiles()) {
            if (file.getName().equalsIgnoreCase(inputFilename)) {
                TableProducer.transformFile(file, file.getParentFile(), outputBasename, outputFormat, log, keySeparator, targetDir);
            }
            if (!file.isDirectory()) continue;
            TableProducer.transformRecursively(file, inputBasename, outputBasename, outputFormat, log, keySeparator, targetDir);
        }
    }

    private static Table readXmlFile(File tableFile, String keySeparator) throws Exception {
        Table table = new Table();
        DocumentBuilder db = factory.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                throw new RuntimeException(exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw new RuntimeException(exception);
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw new RuntimeException(exception);
            }
        });
        Document doc = db.parse(tableFile);
        Element rootElem = doc.getDocumentElement();
        NodeList nodeList = rootElem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            if (e.getTagName().equals("locale-config")) {
                NodeList localeList = e.getChildNodes();
                for (int c = 0; c < localeList.getLength(); ++c) {
                    Node n3 = localeList.item(c);
                    if (!(n3 instanceof Element)) continue;
                    TableProducer.processLocale((Element)n3, table);
                }
            }
            if (e.getTagName().equals("entry")) {
                TableProducer.processEntry(e, table, "", keySeparator);
            }
            if (!e.getTagName().equals("output")) continue;
            TableProducer.processOutput(tableFile.getParentFile(), e, table);
        }
        return table;
    }

    private static void processLocale(Element element, Table table) {
        String value = element.getAttribute("value");
        String fallback = element.getAttribute("fallback");
        for (ExportedLocale test : table.getExportedLocales()) {
            if (!test.getValue().equals(value)) continue;
            throw new RuntimeException("Locale [" + value + "] has already been defined.");
        }
        ExportedLocale locale = new ExportedLocale();
        locale.setValue(value);
        if (!"".equals(fallback)) {
            locale.setFallback(fallback);
        }
        table.getExportedLocales().add(locale);
    }

    private static void processOutput(File tableDirectory, Element element, Table table) {
        String directory = element.getAttribute("directory");
        String basename = element.getAttribute("basename");
        String keySeparator = element.getAttribute("basename");
        String format = element.getAttribute("format");
        Output output = new Output();
        if (StringUtils.isNotEmpty((CharSequence)directory)) {
            output.setDirectory(new File(directory));
        }
        if (StringUtils.isNotEmpty((CharSequence)basename)) {
            output.setBasename(basename);
        }
        if (StringUtils.isNotEmpty((CharSequence)keySeparator)) {
            output.setKeySeparator(keySeparator);
        }
        if (StringUtils.isNotEmpty((CharSequence)format)) {
            output.setFormat(LanguageFileFormat.valueOf(format));
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element e;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(e = (Element)node).getTagName().equals("javaAccessor")) continue;
            output.setJavaAccessor(TableProducer.readJavaAccessor(tableDirectory, e));
        }
        table.getOutput().add(output);
    }

    private static JavaAccessor readJavaAccessor(File tableDirectory, Element e) {
        JavaAccessor accessor = new JavaAccessor();
        String packageName = e.getAttribute("packageName");
        String className = e.getAttribute("className");
        if (StringUtils.isNotEmpty((CharSequence)packageName)) {
            accessor.setPackageName(packageName);
        }
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            accessor.setClassName(className);
        }
        return accessor;
    }

    private static void processEntry(Element element, Table table, String keyPrefix, String keySeparator) throws DOMException {
        Entry entry = new Entry();
        String key = keyPrefix + element.getAttribute("key");
        if (table.getEntries().containsKey(key)) {
            throw new RuntimeException("Key [" + key + "] already exists.");
        }
        table.getEntries().put(key, entry);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node n = nodeList.item(i);
            if (!(n instanceof Element)) continue;
            Element e = (Element)n;
            if (e.getTagName().equals("description")) {
                entry.setDescription(e.getTextContent());
            }
            if (e.getTagName().equals("text")) {
                String localized = e.getTextContent();
                String locale = e.getAttribute("locale");
                if (entry.getTextMap().containsKey(locale)) {
                    throw new RuntimeException("Locale [" + locale + "] already exists for key [" + key + "]");
                }
                entry.getTextMap().put(locale, localized);
            }
            if (!e.getTagName().equals("entry")) continue;
            TableProducer.processEntry(e, table, key + keySeparator, keySeparator);
        }
    }

    private static void generateLocalizedFile(File tableDirectory, String inputBasename, ExportedLocale locale, Table table, Output output) throws IOException {
        LanguageFileWriter writer;
        String fallback = locale.getFallback() != null ? ", Fallback: " + locale.getFallback() : "";
        String fileComment = "AUTO-GENERATED from schema file [" + inputBasename + "] with i18n-maven-plugin. Localization: " + locale.getValue() + fallback + ". Please do not edit this file manually!";
        switch (output.getFormat()) {
            case JAVA_PROPERTIES: {
                writer = new JavaPropertiesWriter();
                break;
            }
            case STRINGS: {
                writer = new StringsWriter();
                break;
            }
            case JAVASCRIPT: {
                if (output.getKeySeparator() != null && !output.getKeySeparator().equals(".")) {
                    throw new RuntimeException("F\u00fcr JAVASCRIPT ist nur der Punkt als Separator erlaubt!");
                }
                writer = new JavascriptWriter();
                break;
            }
            default: {
                throw new RuntimeException("OutputFormat not implemented: " + (Object)((Object)output.getFormat()));
            }
        }
        writer.write(tableDirectory, inputBasename, output, locale, table, fileComment);
    }

    public static void generateLocalizedFiles(Log log, File tableDirectory, String keySeparator, String inputBasename, Table table, Output output, File targetDir) throws IOException {
        for (ExportedLocale locale : table.getExportedLocales()) {
            TableProducer.generateLocalizedFile(tableDirectory, inputBasename, locale, table, output);
        }
        if (output.getJavaAccessor() != null) {
            JavaAccessor accessor = output.getJavaAccessor();
            JavaAccessorCreator creator = new JavaAccessorCreator(table, keySeparator, targetDir, output.getBasename());
            creator.write(log, accessor);
        }
    }

    private static void transformXML(Log log, File inputFile, String inputBasename, File includePath, File outputDirectory, String outputBasename, LanguageFileFormat outputFormat, String keySeparator, File targetDir) throws Exception {
        Table table = TableProducer.readXmlFile(inputFile, keySeparator);
        Output pluginOutput = new Output();
        pluginOutput.setBasename(outputBasename);
        pluginOutput.setDirectory(outputDirectory);
        pluginOutput.setFormat(outputFormat);
        pluginOutput.setKeySeparator(keySeparator);
        if (table.getOutput().size() == 0) {
            TableProducer.generateLocalizedFiles(log, inputFile.getParentFile(), keySeparator, inputBasename, table, pluginOutput, targetDir);
        } else {
            for (Output output : table.getOutput()) {
                Output custom = new Output();
                custom.setBasename(output.getBasename() == null ? pluginOutput.getBasename() : output.getBasename());
                custom.setDirectory(output.getDirectory() == null ? pluginOutput.getDirectory() : output.getDirectory());
                custom.setFormat(output.getFormat() == null ? pluginOutput.getFormat() : output.getFormat());
                custom.setJavaAccessor(output.getJavaAccessor());
                TableProducer.generateLocalizedFiles(log, inputFile.getParentFile(), keySeparator, inputBasename, table, custom, targetDir);
            }
        }
    }

    public static void reengineer(Log log, String inputBasename, String outputBasename, LanguageFileFormat outputFormat, File tableFile, File tableDirectory, String keySeparator) throws FileNotFoundException, IOException, ParserConfigurationException, TransformerException {
        Table table = new Table();
        File directory = tableFile != null ? tableFile.getParentFile() : tableDirectory;
        if (inputBasename == null) {
            inputBasename = tableFile != null ? FilenameUtils.getBaseName((String)tableFile.getName()) : outputBasename;
        }
        if (outputBasename == null) {
            outputBasename = inputBasename;
        }
        if (inputBasename == null) {
            inputBasename = "i18n";
        }
        switch (outputFormat) {
            case JAVA_PROPERTIES: 
            case JAVASCRIPT: {
                File[] files = directory.listFiles();
                Pattern pattern = Pattern.compile(outputBasename + "(_(\\w+))\\." + outputFormat.getExtension());
                for (File file : files) {
                    Matcher matcher = pattern.matcher(file.getName());
                    if (!matcher.matches()) continue;
                    String lang = matcher.group(2);
                    if (StringUtils.isEmpty((CharSequence)lang)) {
                        lang = "de";
                    }
                    TableProducer.readLocalizedFile(log, file, table, lang, outputFormat);
                }
                break;
            }
            case STRINGS: {
                File[] dirs = directory.listFiles();
                Pattern filePattern = Pattern.compile(outputBasename + "\\." + outputFormat.getExtension());
                Pattern dirPattern = Pattern.compile("(\\w+_?\\w*)\\.lproj");
                for (File dir : dirs) {
                    Matcher dirMatcher;
                    if (!dir.isDirectory() || !(dirMatcher = dirPattern.matcher(dir.getName())).matches()) continue;
                    for (File file : dir.listFiles()) {
                        Matcher fileMatcher = filePattern.matcher(file.getName());
                        if (!fileMatcher.matches()) continue;
                        String lang = dirMatcher.group(1);
                        TableProducer.readLocalizedFile(log, file, table, lang, outputFormat);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("OutputFormat not implemented: " + (Object)((Object)outputFormat));
            }
        }
        TableProducer.writeTableToXml(log, table, new File(directory, inputBasename + ".xml"), keySeparator, outputFormat, outputBasename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readLocalizedFile(Log log, File file, Table table, String lang, LanguageFileFormat outputFormat) throws FileNotFoundException, IOException {
        ExportedLocale exported = new ExportedLocale();
        exported.setValue(lang);
        table.getExportedLocales().add(exported);
        Properties p = new Properties();
        switch (outputFormat) {
            case JAVA_PROPERTIES: {
                p.load(new FileInputStream(file));
                break;
            }
            case STRINGS: {
                Pattern pattern = Pattern.compile(" *\"?([^\"\\\\]*(?:\\\\.[^\"\\\\]*)*)\"? *= *\"([^\"\\\\]*(?:\\\\.[^\"\\\\]*)*)\" *; *(?://.*)?");
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));){
                    String line = br.readLine();
                    while (line != null) {
                        Matcher m = pattern.matcher(line);
                        if (m.matches()) {
                            String key = m.group(1).trim();
                            String value = m.group(2).replace("\\t", "\t").replace("\\n", "\n").replace("\\\"", "\"").trim();
                            p.put(key, value);
                        } else if (StringUtils.isNotEmpty((CharSequence)line)) {
                            log.warn((CharSequence)("Ignored line: " + line));
                        }
                        line = br.readLine();
                    }
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)outputFormat) + " is not supported");
            }
        }
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            Entry e = table.getEntries().get(key);
            if (e == null) {
                e = new Entry();
                table.getEntries().put(key, e);
            }
            e.getTextMap().put(lang, value);
        }
    }

    private static void writeTableToXml(Log log, Table table, File outputFile, String keySeparator, LanguageFileFormat format, String outputBasename) throws ParserConfigurationException, TransformerException {
        log.info((CharSequence)("Now creating language table: " + outputFile));
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element root = doc.createElement("table");
        root.setAttribute("xmlns", "http://pentabyte.de/maven/i18n");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "http://pentabyte.de/maven/i18n http://pentabyte.de/maven/i18n/" + Constants.schemaFileName);
        doc.appendChild(root);
        Element localeConfig = doc.createElement("locale-config");
        root.appendChild(localeConfig);
        for (ExportedLocale exported : table.getExportedLocales()) {
            Element exLocale = doc.createElement("exported-locale");
            exLocale.setAttribute("value", exported.getValue());
            localeConfig.appendChild(exLocale);
        }
        Element output = doc.createElement("output");
        root.appendChild(output);
        output.setAttribute("format", format.name());
        output.setAttribute("basename", outputBasename);
        Map<String, EntryNode> nodes = table.createHierarchy(keySeparator);
        for (Map.Entry entry : nodes.entrySet()) {
            TableProducer.append(doc, root, (String)entry.getKey(), (EntryNode)entry.getValue());
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outputFile);
        transformer.transform(source, result);
    }

    private static void append(Document doc, Element parent, String key, EntryNode value) {
        Element entry = doc.createElement("entry");
        parent.appendChild(entry);
        entry.setAttribute("key", key);
        for (Map.Entry<String, String> entry2 : value.getTextMap().entrySet()) {
            Element text = doc.createElement("text");
            entry.appendChild(text);
            text.setAttribute("locale", entry2.getKey());
            text.setTextContent(entry2.getValue());
        }
        for (Map.Entry<String, Object> entry3 : value.getNodes().entrySet()) {
            TableProducer.append(doc, entry, entry3.getKey(), (EntryNode)entry3.getValue());
        }
    }

    static {
        factory.setIgnoringElementContentWhitespace(true);
        factory.setNamespaceAware(true);
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = sf.newSchema(new StreamSource(TableProducer.class.getResourceAsStream(Constants.schemaFileName)));
            factory.setSchema(schema);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

