/*
 * Decompiled with CFR 0.152.
 */
package de.perdian.maven.plugins.macosappbundler.mojo;

import de.perdian.maven.plugins.macosappbundler.mojo.impl.AppGenerator;
import de.perdian.maven.plugins.macosappbundler.mojo.impl.DmgGenerator;
import de.perdian.maven.plugins.macosappbundler.mojo.model.AppConfiguration;
import de.perdian.maven.plugins.macosappbundler.mojo.model.DmgConfiguration;
import de.perdian.maven.plugins.macosappbundler.mojo.model.JdkConfiguration;
import de.perdian.maven.plugins.macosappbundler.mojo.model.NativeBinaryType;
import de.perdian.maven.plugins.macosappbundler.mojo.model.PlistConfiguration;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="bundle", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.PACKAGE)
public class BundleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project = null;
    @Parameter(required=true)
    private PlistConfiguration plist = null;
    @Parameter
    private AppConfiguration app = new AppConfiguration();
    @Parameter
    private DmgConfiguration dmg = new DmgConfiguration();
    @Parameter
    private JdkConfiguration jdk = new JdkConfiguration();
    @Parameter
    private NativeBinaryType nativeBinary = NativeBinaryType.UNIVERSAL;

    public void execute() throws MojoExecutionException {
        Validate.notNull((Object)this.getProject(), (String)"MavenProject cannot be null", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)this.plist.JVMMainClassName) && StringUtils.isEmpty((CharSequence)this.plist.JVMMainModuleName)) {
            throw new MojoExecutionException("Neither 'JVMMainClassName' nor 'JVMMainModuleName' have been defined!");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.plist.JVMMainClassName) && StringUtils.isNotEmpty((CharSequence)this.plist.JVMMainModuleName)) {
            throw new MojoExecutionException("Both 'JVMMainClassName' and 'JVMMainModuleName' have been defined! Make sure to define only one to signalize whether to use a classic classpath application or a moduel application.");
        }
        this.plist.CFBundleDisplayName = (String)StringUtils.defaultIfEmpty((CharSequence)this.plist.CFBundleDisplayName, (CharSequence)this.project.getName());
        this.plist.CFBundleName = (String)StringUtils.defaultIfEmpty((CharSequence)this.plist.CFBundleName, (CharSequence)this.project.getName());
        this.plist.CFBundleDevelopmentRegion = (String)StringUtils.defaultIfEmpty((CharSequence)this.plist.CFBundleDevelopmentRegion, (CharSequence)"English");
        this.plist.CFBundleIdentifier = (String)StringUtils.defaultIfEmpty((CharSequence)this.plist.CFBundleIdentifier, (CharSequence)(this.project.getGroupId() + "." + this.project.getArtifactId()));
        this.plist.CFBundleShortVersionString = (String)StringUtils.defaultIfEmpty((CharSequence)this.plist.CFBundleShortVersionString, (CharSequence)this.project.getVersion());
        this.plist.CFBundleExecutable = (String)StringUtils.defaultIfEmpty((CharSequence)this.plist.CFBundleExecutable, (CharSequence)"JavaLauncher");
        this.plist.CFBundlePackageType = (String)StringUtils.defaultIfEmpty((CharSequence)this.plist.CFBundlePackageType, (CharSequence)"APPL");
        String appName = StringUtils.defaultString((String)this.plist.CFBundleName, (String)this.project.getBuild().getFinalName());
        File targetDirectory = new File(this.project.getBuild().getDirectory());
        File appDirectory = new File(targetDirectory, appName + ".app");
        if (!appDirectory.exists()) {
            this.getLog().info((CharSequence)("Creating app directory at: " + appDirectory.getAbsolutePath()));
            appDirectory.mkdirs();
        }
        AppGenerator appGenerator = new AppGenerator(this.plist, this.app, this.getLog());
        appGenerator.setIncludeJdk(this.jdk.include);
        appGenerator.setJdkLocation(this.jdk.location);
        appGenerator.setNativeBinaryType(this.nativeBinary);
        appGenerator.generateApp(this.project, appDirectory);
        if (this.dmg.generate) {
            File bundleDirectory = new File(targetDirectory, "bundle");
            File dmgFile = new File(targetDirectory, this.createDmgFileName(appName));
            DmgGenerator dmgGenerator = new DmgGenerator(this.dmg, appName, this.getLog());
            dmgGenerator.generateDmg(this.project, appDirectory, bundleDirectory, dmgFile);
            try {
                FileUtils.deleteDirectory((File)bundleDirectory);
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)("Cannot delete bundle directory at: " + bundleDirectory.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private String createDmgFileName(String appName) {
        if (this.dmg.appendVersion) {
            return appName + "_" + this.project.getVersion() + ".dmg";
        }
        if (this.dmg.dmgFileName == null || this.dmg.dmgFileName.isEmpty()) {
            return appName + ".dmg";
        }
        return this.dmg.dmgFileName + ".dmg";
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

