/*
 * Decompiled with CFR 0.152.
 */
package de.perdian.maven.plugins.macosappbundler.mojo.impl;

import de.perdian.maven.plugins.macosappbundler.mojo.impl.support.IO;
import de.perdian.maven.plugins.macosappbundler.mojo.model.AppConfiguration;
import de.perdian.maven.plugins.macosappbundler.mojo.model.NativeBinaryType;
import de.perdian.maven.plugins.macosappbundler.mojo.model.PlistConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;

public class AppGenerator {
    private PlistConfiguration plistConfiguration = null;
    private NativeBinaryType nativeBinaryType = NativeBinaryType.UNIVERSAL;
    private boolean includeJdk = false;
    private String jdkLocation = null;
    private Log log = null;
    private AppConfiguration appConfiguration = null;

    public AppGenerator(PlistConfiguration plistConfiguration, AppConfiguration appConfiguration, Log log) {
        this.setPlistConfiguration(plistConfiguration);
        this.setAppConfiguration(appConfiguration);
        this.setLog(log);
    }

    private AppConfiguration getAppConfiguration() {
        return this.appConfiguration;
    }

    private void setAppConfiguration(AppConfiguration appConfiguration) {
        this.appConfiguration = appConfiguration;
    }

    public void generateApp(MavenProject project, File appDirectory) throws MojoExecutionException {
        this.copyApplicationDependencies(project, new File(appDirectory, "Contents/Java"));
        this.copyJdk(new File(appDirectory, "Contents/Java/jdk"));
        this.copyNativeExecutable(new File(appDirectory, "Contents/MacOS"));
        this.generatePlist(project, new File(appDirectory, "Contents/"));
        if (this.getAppConfiguration().additionalResources != null && !this.getAppConfiguration().additionalResources.isEmpty()) {
            this.getLog().info((CharSequence)"Copy additional app resources");
            this.copyAdditionalAppResources(project, this.getAppConfiguration().additionalResources, appDirectory);
        }
    }

    private void copyAdditionalAppResources(MavenProject project, List<FileSet> additionalResources, File appDirectory) throws MojoExecutionException {
        try {
            IO.copyFileSets(appDirectory, additionalResources);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Cannot copy additional app resources", (Throwable)e);
            throw new MojoExecutionException("Cannot copy additional app resources", e);
        }
    }

    private void copyApplicationDependencies(MavenProject project, File appJavaDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Copy application dependencies to: " + appJavaDirectory.getAbsolutePath()));
        try {
            if (StringUtils.isNotEmpty((CharSequence)this.getPlistConfiguration().JVMMainClassName)) {
                this.copyClasspathApplicationDependencies(project, new File(appJavaDirectory, "classpath"));
            } else if (StringUtils.isNotEmpty((CharSequence)this.getPlistConfiguration().JVMMainModuleName)) {
                this.copyModuleApplicationDependencies(project, new File(appJavaDirectory, "modules"));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot copy dependencies", (Exception)e);
        }
    }

    private void copyClasspathApplicationDependencies(MavenProject project, File classpathDirectory) throws IOException {
        DefaultRepositoryLayout repositoryLayout = new DefaultRepositoryLayout();
        this.copyClasspathApplicationDependencyArtifact(project.getArtifact(), classpathDirectory, (ArtifactRepositoryLayout)repositoryLayout);
        for (Artifact artifact : project.getArtifacts()) {
            this.copyClasspathApplicationDependencyArtifact(artifact, classpathDirectory, (ArtifactRepositoryLayout)repositoryLayout);
        }
    }

    private void copyClasspathApplicationDependencyArtifact(Artifact artifact, File targetDirectory, ArtifactRepositoryLayout repositoryLayout) throws IOException {
        File targetFile = new File(targetDirectory, repositoryLayout.pathOf(artifact));
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        FileUtils.copyFile((File)artifact.getFile(), (File)targetFile);
    }

    private void copyModuleApplicationDependencies(MavenProject project, File modulesDirectory) throws IOException {
        this.copyModuleApplicationDependencyArtifact(project.getArtifact(), modulesDirectory);
        for (Artifact artifact : project.getArtifacts()) {
            this.copyModuleApplicationDependencyArtifact(artifact, modulesDirectory);
        }
    }

    private void copyModuleApplicationDependencyArtifact(Artifact artifact, File modulesDirectory) throws IOException {
        StringBuilder targetFileName = new StringBuilder();
        targetFileName.append(artifact.getArtifactId());
        targetFileName.append("-").append(artifact.getVersion());
        targetFileName.append(".").append(FilenameUtils.getExtension((String)artifact.getFile().getName()));
        File targetFile = new File(modulesDirectory, targetFileName.toString());
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        FileUtils.copyFile((File)artifact.getFile(), (File)targetFile);
    }

    private void copyNativeExecutable(File targetDirectory) throws MojoExecutionException {
        try {
            URL nativeBinarySource = this.resolveNativeExecutable();
            String targetFileName = (String)StringUtils.defaultIfEmpty((CharSequence)this.getPlistConfiguration().CFBundleExecutable, (CharSequence)"JavaLauncher");
            File targetFile = new File(targetDirectory, targetFileName);
            this.getLog().info((CharSequence)("Copy native executable for binary type " + this.getNativeBinaryType() + " to: " + targetFile.getAbsolutePath()));
            try (InputStream nativeExecutableStream = nativeBinarySource.openStream();){
                FileUtils.copyInputStreamToFile((InputStream)nativeExecutableStream, (File)targetFile);
            }
            targetFile.setExecutable(true, false);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot copy native executable", (Exception)e);
        }
    }

    private URL resolveNativeExecutable() throws MojoExecutionException {
        URL nativeBinarySource = this.getClass().getClassLoader().getResource(this.getNativeBinaryType().getFilename());
        if (nativeBinarySource == null) {
            throw new MojoExecutionException("No native executable packaged in plugin for native binary type " + this.getNativeBinaryType().name() + " found at location: " + this.getNativeBinaryType().getFilename());
        }
        return nativeBinarySource;
    }

    private void generatePlist(MavenProject project, File contentsDirectory) throws MojoExecutionException {
        LinkedHashMap<String, String> additionalProperties = new LinkedHashMap<String, String>();
        String iconFileName = this.copyIcon(project, contentsDirectory);
        if (StringUtils.isNotEmpty((CharSequence)iconFileName)) {
            additionalProperties.put("CFBundleIconFile", iconFileName);
        }
        try {
            File plistFile = new File(contentsDirectory, "Info.plist");
            this.getLog().info((CharSequence)"Generating Info.plist");
            FileUtils.write((File)plistFile, (CharSequence)this.getPlistConfiguration().toXmlString(additionalProperties), (String)"UTF-8");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot generate Info.plist file", e);
        }
    }

    private String copyIcon(MavenProject project, File contentsDirectory) throws MojoExecutionException {
        String iconFileValue = this.getPlistConfiguration().CFBundleIconFile;
        if (StringUtils.isNotEmpty((CharSequence)iconFileValue)) {
            File iconFile = new File(project.getBasedir(), iconFileValue);
            if (!iconFile.exists()) {
                throw new MojoExecutionException("Cannot find declared icon file " + iconFile.getName() + " at: " + iconFile.getAbsolutePath());
            }
            File resourcesDirectory = new File(contentsDirectory, "Resources");
            File targetFile = new File(resourcesDirectory, iconFile.getName());
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            try {
                FileUtils.copyFile((File)iconFile, (File)targetFile);
                return targetFile.getName();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot copy icon file to: " + targetFile.getAbsolutePath(), (Exception)e);
            }
        }
        return null;
    }

    private void copyJdk(File targetDirectory) throws MojoExecutionException {
        if (this.isIncludeJdk()) {
            if (StringUtils.isEmpty((CharSequence)this.getJdkLocation())) {
                this.getLog().info((CharSequence)("Copy JDK from system default directory at: " + System.getProperty("java.home")));
                this.copyJdkFromDirectory(targetDirectory, new File(System.getProperty("java.home")));
            } else {
                File jdkDirectory = new File(this.getJdkLocation());
                if (!jdkDirectory.exists()) {
                    throw new MojoExecutionException("Specified JDK directory doesn't exist at: " + jdkDirectory.getAbsolutePath());
                }
                File contentsHomeDirectory = new File(jdkDirectory, "Contents/Home/");
                if (contentsHomeDirectory.exists() && contentsHomeDirectory.isDirectory()) {
                    jdkDirectory = contentsHomeDirectory;
                }
                this.getLog().info((CharSequence)("Copy JDK from explicit directory at: " + jdkDirectory.getAbsolutePath()));
                this.copyJdkFromDirectory(targetDirectory, jdkDirectory);
            }
        }
    }

    private void copyJdkFromDirectory(File targetDirectory, File sourceDirectory) throws MojoExecutionException {
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        try {
            FileUtils.copyDirectory((File)sourceDirectory, (File)targetDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot copy JDK from directory at: " + sourceDirectory.getAbsolutePath(), (Exception)e);
        }
    }

    private PlistConfiguration getPlistConfiguration() {
        return this.plistConfiguration;
    }

    private void setPlistConfiguration(PlistConfiguration plistConfiguration) {
        this.plistConfiguration = plistConfiguration;
    }

    public boolean isIncludeJdk() {
        return this.includeJdk;
    }

    public void setIncludeJdk(boolean includeJdk) {
        this.includeJdk = includeJdk;
    }

    public NativeBinaryType getNativeBinaryType() {
        return this.nativeBinaryType;
    }

    public void setNativeBinaryType(NativeBinaryType nativeBinaryType) {
        this.nativeBinaryType = nativeBinaryType;
    }

    public String getJdkLocation() {
        return this.jdkLocation;
    }

    public void setJdkLocation(String jdkLocation) {
        this.jdkLocation = jdkLocation;
    }

    private Log getLog() {
        return this.log;
    }

    private void setLog(Log log) {
        this.log = log;
    }
}

