/*
 * Decompiled with CFR 0.152.
 */
package de.perdian.maven.plugins.macosappbundler.mojo.impl;

import de.perdian.maven.plugins.macosappbundler.mojo.impl.support.IO;
import de.perdian.maven.plugins.macosappbundler.mojo.model.DmgConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.utils.cli.Commandline;

public class DmgGenerator {
    private DmgConfiguration dmgConfiguration = null;
    private String volumeName = null;
    private Log log = null;

    public DmgGenerator(DmgConfiguration dmgConfiguration, String volumeName, Log log) {
        this.setDmgConfiguration(dmgConfiguration);
        this.setVolumeName(volumeName);
        this.setLog(log);
    }

    public void generateDmg(MavenProject project, File appDirectory, File bundleDirectory, File dmgFile) throws MojoExecutionException {
        try {
            File bundleAppDirectory = new File(bundleDirectory, appDirectory.getName());
            if (!bundleAppDirectory.exists()) {
                this.getLog().debug((CharSequence)("Creating bundle app directory at: " + bundleAppDirectory.getAbsolutePath()));
                bundleAppDirectory.mkdirs();
            }
            Iterator files = Files.walk(appDirectory.toPath(), new FileVisitOption[0]).iterator();
            while (files.hasNext()) {
                Path sourcePathAbsolute = (Path)files.next();
                Path targetPathRelative = appDirectory.toPath().relativize(sourcePathAbsolute);
                Path targetPathAbsolute = bundleAppDirectory.toPath().resolve(targetPathRelative);
                Files.copy(sourcePathAbsolute, targetPathAbsolute, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Cannot copy app directory", (Throwable)e);
            throw new MojoExecutionException("Cannot copy app directory", (Exception)e);
        }
        if (this.getDmgConfiguration().additionalResources != null && !this.getDmgConfiguration().additionalResources.isEmpty()) {
            this.getLog().info((CharSequence)"Copy additional resources");
            this.copyAdditionalDmgResources(project, this.getDmgConfiguration().additionalResources, bundleDirectory);
        }
        if (this.getDmgConfiguration().createApplicationsSymlink) {
            this.getLog().info((CharSequence)"Create Applications symlink");
            try {
                Files.createSymbolicLink(new File(bundleDirectory, "Applications").toPath(), Paths.get("/Applications", new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot create link to Applications folder at: " + new File(bundleDirectory, "Applications").getAbsolutePath(), (Exception)e);
            }
        }
        this.getLog().info((CharSequence)"Generating DMG archive");
        this.generateDmgArchive(bundleDirectory, dmgFile);
    }

    private void generateDmgArchive(File bundleDirectory, File dmgFile) throws MojoExecutionException {
        try {
            if (this.getDmgConfiguration().useGenIsoImage) {
                this.generateDmgArchiveGenIsoImage(bundleDirectory, dmgFile, false);
            } else {
                this.generateDmgArchiveHdiUtil(bundleDirectory, dmgFile, false);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Cannot generate DMG archive at: " + dmgFile.getAbsolutePath(), e);
        }
    }

    private void generateDmgArchiveGenIsoImage(File bundleDirectory, File dmgFile, boolean fallback) throws Exception {
        Commandline dmgCommandLine = new Commandline();
        dmgCommandLine.setExecutable("genisoimage");
        dmgCommandLine.createArg().setValue("-D");
        dmgCommandLine.createArg().setValue("-V");
        dmgCommandLine.createArg().setValue(this.getVolumeName());
        dmgCommandLine.createArg().setValue("-no-pad");
        dmgCommandLine.createArg().setValue("-r");
        dmgCommandLine.createArg().setValue("-apple");
        dmgCommandLine.createArg().setValue("-quiet");
        dmgCommandLine.createArg().setValue("-o");
        dmgCommandLine.createArg().setValue(dmgFile.getAbsolutePath());
        dmgCommandLine.createArg().setValue(bundleDirectory.getAbsolutePath());
        int returnValue = dmgCommandLine.execute().waitFor();
        if (returnValue != 0) {
            if (this.getDmgConfiguration().autoFallback && !fallback) {
                this.generateDmgArchiveHdiUtil(bundleDirectory, dmgFile, true);
            } else {
                throw new Exception("Command 'genisoimage' exited with status " + returnValue);
            }
        }
    }

    private void generateDmgArchiveHdiUtil(File bundleDirectory, File dmgFile, boolean fallback) throws Exception {
        Commandline dmgCommandLine = new Commandline();
        dmgCommandLine.setExecutable("hdiutil");
        dmgCommandLine.createArg().setValue("create");
        dmgCommandLine.createArg().setValue("-srcfolder");
        dmgCommandLine.createArg().setValue(bundleDirectory.getAbsolutePath());
        dmgCommandLine.createArg().setValue(dmgFile.getAbsolutePath());
        dmgCommandLine.createArg().setValue("-volname");
        dmgCommandLine.createArg().setValue(this.getVolumeName());
        int returnValue = dmgCommandLine.execute().waitFor();
        if (returnValue != 0) {
            if (this.getDmgConfiguration().autoFallback && !fallback) {
                this.generateDmgArchiveGenIsoImage(bundleDirectory, dmgFile, true);
            } else {
                throw new Exception("Command 'hdiutil' exited with status " + returnValue);
            }
        }
    }

    private void copyAdditionalDmgResources(MavenProject project, List<FileSet> additionalResources, File bundleDirectory) throws MojoExecutionException {
        try {
            IO.copyFileSets(bundleDirectory, additionalResources);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Cannot copy additional resources", (Throwable)e);
            throw new MojoExecutionException("Cannot copy additional resources", e);
        }
    }

    private DmgConfiguration getDmgConfiguration() {
        return this.dmgConfiguration;
    }

    private void setDmgConfiguration(DmgConfiguration dmgConfiguration) {
        this.dmgConfiguration = dmgConfiguration;
    }

    private String getVolumeName() {
        return this.volumeName;
    }

    private void setVolumeName(String volumeName) {
        this.volumeName = volumeName;
    }

    private Log getLog() {
        return this.log;
    }

    private void setLog(Log log) {
        this.log = log;
    }
}

