/*
 * Decompiled with CFR 0.152.
 */
package de.perdoctus.fx;

import de.perdoctus.fx.Bundle;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.util.BuilderFactory;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionPoint;

public final class FxmlLoaderProducer {
    @Produces
    @Dependent
    public FXMLLoader produce(InjectionPoint injectionPoint) {
        Bundle annotation = (Bundle)injectionPoint.getAnnotated().getAnnotation(Bundle.class);
        ResourceBundle resourceBundle = annotation != null ? ResourceBundle.getBundle(annotation.value()) : null;
        return new FXMLLoader(null, resourceBundle, (BuilderFactory)new JavaFXBuilderFactory(), controllerClass -> {
            Object controller = CDI.current().select(controllerClass, new Annotation[0]).get();
            if (controller == null) {
                throw new RuntimeException("Failed to look up controller of type " + controllerClass.getName() + ".");
            }
            return controller;
        }, StandardCharsets.UTF_8);
    }
}

