/*
 * Decompiled with CFR 0.152.
 */
package de.phip1611;

import de.phip1611.StringFindUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Docx4JSRUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(Docx4JSRUtil.class);

    public static void searchAndReplace(WordprocessingMLPackage docxDocument, Map<String, String> replaceMap) {
        List<Text> texts = Docx4JSRUtil.getAllElementsOfType(docxDocument.getMainDocumentPart(), Text.class);
        String completeString = Docx4JSRUtil.getCompleteString(texts);
        if (completeString.isEmpty()) {
            return;
        }
        List<TextMetaItem> metaItemList = Docx4JSRUtil.buildMetaItemList(texts);
        TextMetaItem[] stringIndicesLookupArray = Docx4JSRUtil.buildIndexToTextMetaItemArray(metaItemList);
        List<ReplaceCommand> replaceCommandList = Docx4JSRUtil.buildAllReplaceCommands(completeString, replaceMap);
        replaceCommandList.forEach(rc -> Docx4JSRUtil.executeReplaceCommand(texts, rc, stringIndicesLookupArray));
    }

    public static <T> List<T> getAllElementsOfType(Object obj, Class<T> clazz) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (obj instanceof JAXBElement) {
            obj = ((JAXBElement)obj).getValue();
        }
        if (obj.getClass().equals(clazz)) {
            result.add(obj);
        } else if (obj instanceof ContentAccessor) {
            List children = ((ContentAccessor)obj).getContent();
            for (Object child : children) {
                result.addAll(Docx4JSRUtil.getAllElementsOfType(child, clazz));
            }
        }
        return result;
    }

    public static String getCompleteString(List<Text> texts) {
        return texts.stream().map(Text::getValue).filter(Objects::nonNull).reduce(String::concat).orElse("");
    }

    public static List<TextMetaItem> buildMetaItemList(List<Text> texts) {
        int index = 0;
        int iteration = 0;
        ArrayList<TextMetaItem> list = new ArrayList<TextMetaItem>();
        for (Text text : texts) {
            int length = text.getValue().length();
            list.add(new TextMetaItem(index, index + length - 1, text, iteration));
            index += length;
            ++iteration;
        }
        return list;
    }

    public static TextMetaItem[] buildIndexToTextMetaItemArray(List<TextMetaItem> metaItemList) {
        int currentStringIndicesToTextIndex = 0;
        int max = metaItemList.get(metaItemList.size() - 1).getEnd() + 1;
        TextMetaItem[] arr = new TextMetaItem[max];
        for (int i = 0; i < max; ++i) {
            TextMetaItem currentTextMetaItem;
            arr[i] = currentTextMetaItem = metaItemList.get(currentStringIndicesToTextIndex);
            if (i < currentTextMetaItem.getEnd()) continue;
            ++currentStringIndicesToTextIndex;
        }
        return arr;
    }

    private static List<ReplaceCommand> buildReplaceCommandsForOnePlaceholder(String completeString, Map.Entry<String, String> searchAndReplaceEntry) {
        return StringFindUtil.findAllOccurrencesInString(completeString, searchAndReplaceEntry.getKey()).stream().map(fmi -> new ReplaceCommand((String)searchAndReplaceEntry.getValue(), (StringFindUtil.FoundResult)fmi)).collect(Collectors.toList());
    }

    public static List<ReplaceCommand> buildAllReplaceCommands(String completeString, Map<String, String> replaceMap) {
        return replaceMap.entrySet().stream().map(e -> Docx4JSRUtil.buildReplaceCommandsForOnePlaceholder(completeString, e)).flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    public static void executeReplaceCommand(List<Text> texts, ReplaceCommand replaceCommand, TextMetaItem[] arr) {
        TextMetaItem tmi1 = arr[replaceCommand.getFoundResult().getStart()];
        TextMetaItem tmi2 = arr[replaceCommand.getFoundResult().getEnd()];
        if (tmi1.getPosition() == tmi2.getPosition()) {
            String t1 = tmi1.getText().getValue();
            int beginIndex = tmi1.getPositionInsideTextObject(replaceCommand.getFoundResult().getStart());
            int endIndex = tmi2.getPositionInsideTextObject(replaceCommand.getFoundResult().getEnd());
            String keepBefore = t1.substring(0, beginIndex);
            String keepAfter = t1.substring(endIndex + 1);
            tmi1.getText().setValue(keepBefore + replaceCommand.getNewValue() + keepAfter);
        } else {
            String newValue;
            if (tmi2.getPosition() - tmi1.getPosition() > 1) {
                int lowerBorder;
                int upperBorder = tmi2.getPosition();
                for (int i = lowerBorder = tmi1.getPosition() + 1; i < upperBorder; ++i) {
                    texts.get(i).setValue(null);
                }
            }
            String t1 = tmi1.getText().getValue();
            String t2 = tmi2.getText().getValue();
            int beginIndex = tmi1.getPositionInsideTextObject(replaceCommand.getFoundResult().getStart());
            int endIndex = tmi2.getPositionInsideTextObject(replaceCommand.getFoundResult().getEnd());
            if (replaceCommand.getNewValue() == null) {
                LOGGER.warn("replaceCommand.getNewValue() is null! Using '' instead!");
                newValue = "";
            } else {
                newValue = replaceCommand.getNewValue();
            }
            t1 = t1.substring(0, beginIndex);
            t1 = t1.concat(newValue);
            t2 = t2.substring(endIndex + 1);
            tmi1.getText().setValue(t1);
            tmi2.getText().setValue(t2);
        }
    }

    public static class TextMetaItem {
        private int position;
        private int start;
        private int end;
        private Text text;

        public TextMetaItem(int start, int end, Text text, int position) {
            this.start = start;
            this.end = end;
            this.text = text;
            this.position = position;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public Text getText() {
            return this.text;
        }

        public int getPosition() {
            return this.position;
        }

        public int getPositionInsideTextObject(int completeStringIndex) {
            return completeStringIndex - this.start;
        }
    }

    public static class ReplaceCommand
    implements Comparable<ReplaceCommand> {
        private String newValue;
        private StringFindUtil.FoundResult foundMetaItem;

        public ReplaceCommand(String newValue, StringFindUtil.FoundResult foundMetaItem) {
            this.newValue = newValue;
            this.foundMetaItem = foundMetaItem;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public StringFindUtil.FoundResult getFoundResult() {
            return this.foundMetaItem;
        }

        @Override
        public int compareTo(ReplaceCommand other) {
            return other.getFoundResult().getStart() - this.getFoundResult().getStart();
        }
    }
}

