/*
 * Decompiled with CFR 0.152.
 */
package de.pitkley.jmccs.osx;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import de.pitkley.jmccs.monitor.CapabilityStringParser;
import de.pitkley.jmccs.monitor.Monitor;
import de.pitkley.jmccs.monitor.VCPCode;
import de.pitkley.jmccs.monitor.VCPReply;
import de.pitkley.jmccs.monitor.VCPStringFormatException;
import de.pitkley.jmccs.monitor.VCPStringParser;
import de.pitkley.jmccs.osx.CoreGraphics;
import de.pitkley.jmccs.osx.LibMCCS;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class OSXMonitor
implements Monitor {
    private static final LibMCCS MCCS = LibMCCS.INSTANCE;
    private static final CoreGraphics CG = CoreGraphics.INSTANCE;
    private final CoreGraphics.CGDirectDisplayID displayId;
    private final Map<VCPCode, Optional<Set<Integer>>> supportedVCPCodes;

    protected OSXMonitor(CoreGraphics.CGDirectDisplayID displayId) throws VCPStringFormatException {
        this.displayId = displayId;
        PointerByReference ppCapabilityString = new PointerByReference();
        MCCS.MCCSGetCapabilityString(displayId, ppCapabilityString);
        Pointer pCapabilityString = ppCapabilityString.getValue();
        String capabilityString = pCapabilityString.getString(0L);
        MCCS.cleanup_pointer(pCapabilityString);
        if (capabilityString == null || capabilityString.isEmpty()) {
            throw new VCPStringFormatException("Unable to get capabilities string");
        }
        String vcpString = (String)CapabilityStringParser.parse((String)capabilityString).get("vcp");
        if (vcpString == null || vcpString.isEmpty()) {
            throw new VCPStringFormatException("Capabilities string is missing the supported VCP codes");
        }
        this.supportedVCPCodes = VCPStringParser.parse((String)vcpString);
    }

    public boolean isMainMonitor() {
        return CG.CGMainDisplayID().equals((Object)this.displayId);
    }

    public boolean isVCPCodeSupported(VCPCode vcpCode) {
        return this.supportedVCPCodes.containsKey(vcpCode);
    }

    public VCPReply getVCPFeature(VCPCode vcpCode) {
        LibMCCS.MCCSReadCommand.ByReference read = new LibMCCS.MCCSReadCommand.ByReference();
        read.control_id = (byte)vcpCode.getCode();
        MCCS.MCCSRead(this.displayId, read);
        VCPReply reply = new VCPReply((int)read.current_value, (int)read.max_value);
        return reply;
    }

    public boolean setVCPFeature(VCPCode vcpCode, int value) {
        LibMCCS.MCCSWriteCommand write = new LibMCCS.MCCSWriteCommand(vcpCode.getCode(), value);
        byte result = MCCS.MCCSWrite(this.displayId, write);
        return result != 0;
    }

    public boolean isClosed() {
        return true;
    }

    public void close() throws IOException {
    }
}

