/*
 * Decompiled with CFR 0.152.
 */
package de.pitkley.jmccs.osx;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import de.pitkley.jmccs.monitor.Monitor;
import de.pitkley.jmccs.monitor.MonitorManager;
import de.pitkley.jmccs.monitor.UnsupportedOperatingSystemException;
import de.pitkley.jmccs.monitor.VCPStringFormatException;
import de.pitkley.jmccs.osx.CoreGraphics;
import de.pitkley.jmccs.osx.OSXMonitor;
import java.util.ArrayList;
import java.util.List;

public class OSXMonitorManager
extends MonitorManager {
    private final CoreGraphics CG;
    private static final int MAX_DISPLAYS = 10;
    private final List<Monitor> monitors = new ArrayList<Monitor>();

    public OSXMonitorManager() throws UnsupportedOperatingSystemException {
        if (!Platform.isMac()) {
            throw new UnsupportedOperatingSystemException("OS X", System.getProperty("os.name"));
        }
        this.CG = CoreGraphics.INSTANCE;
    }

    public List<Monitor> getMonitors() {
        if (this.monitors.size() == 0) {
            Memory onlineDisplays = new Memory((long)(10 * Native.getNativeSize(Integer.TYPE)));
            IntByReference ptrDisplayCount = new IntByReference();
            this.CG.CGGetOnlineDisplayList(10, (Pointer)onlineDisplays, ptrDisplayCount);
            for (int i = 0; i < ptrDisplayCount.getValue(); ++i) {
                try {
                    this.monitors.add(new OSXMonitor(new CoreGraphics.CGDirectDisplayID(onlineDisplays.getInt((long)(i * Native.getNativeSize(Integer.TYPE))))));
                    continue;
                }
                catch (VCPStringFormatException ignored) {
                    ignored.printStackTrace();
                }
            }
        }
        return new ArrayList<Monitor>(this.monitors);
    }

    public void closeMonitors() {
    }
}

