/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.lombok;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class UserMapKeys {
    private static final String LOMBOK_HAS_IMPLICIT_USAGE_PROPERTY = "lombok.hasImplicitUsage";
    private static final String LOMBOK_HAS_IMPLICIT_READ_PROPERTY = "lombok.hasImplicitRead";
    private static final String LOMBOK_HAS_IMPLICIT_WRITE_PROPERTY = "lombok.hasImplicitWrite";
    public static final Key<Boolean> USAGE_KEY = Key.create((String)"lombok.hasImplicitUsage");
    public static final Key<Boolean> READ_KEY = Key.create((String)"lombok.hasImplicitRead");
    public static final Key<Boolean> WRITE_KEY = Key.create((String)"lombok.hasImplicitWrite");

    public static void removeAllUsagesFrom(@NotNull UserDataHolder userDataHolder) {
        if (null != userDataHolder.getUserData(READ_KEY)) {
            userDataHolder.putUserData(READ_KEY, null);
        }
        if (null != userDataHolder.getUserData(WRITE_KEY)) {
            userDataHolder.putUserData(WRITE_KEY, null);
        }
        if (null != userDataHolder.getUserData(USAGE_KEY)) {
            userDataHolder.putUserData(USAGE_KEY, null);
        }
    }

    public static void addGeneralUsageFor(@NotNull UserDataHolder userDataHolder) {
        userDataHolder.putUserData(USAGE_KEY, (Object)Boolean.TRUE);
    }

    public static void addReadUsageFor(@NotNull UserDataHolder userDataHolder) {
        userDataHolder.putUserData(READ_KEY, (Object)Boolean.TRUE);
    }

    public static void addWriteUsageFor(@NotNull UserDataHolder userDataHolder) {
        userDataHolder.putUserData(WRITE_KEY, (Object)Boolean.TRUE);
    }

    public static void addReadUsageFor(@NotNull Collection<? extends UserDataHolder> collection) {
        for (UserDataHolder userDataHolder : collection) {
            UserMapKeys.addReadUsageFor(userDataHolder);
        }
    }
}

