/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.xjc.lombok;

import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JDefinedClass;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.IOException;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.xml.sax.ErrorHandler;

public class XjcLombokPlugin
extends Plugin {
    public static final String OPTION_NAME = "Xlombok";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "  -Xlombok\t:  enable generation of lombok @ToString, @EqualsAndHashCode annotations";
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        return 0;
    }

    public boolean run(Outline outline, Options options, ErrorHandler errorHandler) {
        for (ClassOutline classOutline : outline.getClasses()) {
            JDefinedClass implClass = classOutline.implClass;
            this.generateLombokAnnotations(implClass);
        }
        return true;
    }

    protected void generateLombokAnnotations(JDefinedClass implClass) {
        JAnnotationUse toStringAnnotation = implClass.annotate(ToString.class);
        JAnnotationUse equalsAndHashCodeAnnotation = implClass.annotate(EqualsAndHashCode.class);
        if (implClass._extends() instanceof JDefinedClass) {
            toStringAnnotation.param("callSuper", true);
            equalsAndHashCodeAnnotation.param("callSuper", true);
        }
    }
}

