/*
 * Decompiled with CFR 0.152.
 */
package de.ppi.deepsampler.persistence.api;

import de.ppi.deepsampler.core.api.MatcherTools;
import de.ppi.deepsampler.core.model.ParameterMatcher;
import de.ppi.deepsampler.core.model.SampleRepository;
import de.ppi.deepsampler.persistence.api.ComboMatcher;
import de.ppi.deepsampler.persistence.api.PersistentMatcher;
import de.ppi.deepsampler.persistence.error.PersistenceException;
import java.util.Objects;

public class PersistentMatchers {
    private PersistentMatchers() {
    }

    public static <T> T anyRecorded() {
        PersistentMatchers.anyRecorded(new EqualsMatcher());
        return null;
    }

    public static <T> T anyRecorded(Class<T> type) {
        Objects.requireNonNull(type);
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher(parameter -> true, new EqualsMatcher()));
        return null;
    }

    public static String anyRecordedString() {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher(parameter -> true, new EqualsMatcher()));
        return "42";
    }

    public static int anyRecordedInt() {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher(parameter -> true, new EqualsMatcher()));
        return 42;
    }

    public static long anyRecordedLong() {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher(parameter -> true, new EqualsMatcher()));
        return 42L;
    }

    public static double anyRecordedDouble() {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher(parameter -> true, new EqualsMatcher()));
        return 42.0;
    }

    public static float anyRecordedFloat() {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher(parameter -> true, new EqualsMatcher()));
        return 2.0f;
    }

    public static char anyRecordedChar() {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher(parameter -> true, new EqualsMatcher()));
        return '4';
    }

    public static boolean anyRecordedBoolean() {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher(parameter -> true, new EqualsMatcher()));
        return false;
    }

    public static short anyRecordedShort() {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher(parameter -> true, new EqualsMatcher()));
        return 42;
    }

    public static byte anyRecordedByte() {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher(parameter -> true, new EqualsMatcher()));
        return 15;
    }

    public static <T> T anyRecorded(PersistentMatcher<T> persistentMatcher) {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher<T>(parameter -> true, persistentMatcher));
        return null;
    }

    public static <T> T match(ParameterMatcher<T> recordingMatcher, PersistentMatcher<T> playingMatcher) {
        SampleRepository.getInstance().addCurrentParameterMatchers(new ComboMatcher<T>(recordingMatcher, playingMatcher));
        return null;
    }

    public static <T> T combo(T recordingMatcher, PersistentMatcher<T> playingMatcher) {
        if (SampleRepository.getInstance().getCurrentParameterMatchers().isEmpty()) {
            throw new PersistenceException("It wasn't possible to retrieve the last ParameterMatcher. Did you passed a ParameterMatcher created with a static factory method in de.ppi.deepsampler.core.api.Matchers?", new Object[0]);
        }
        ParameterMatcher lastMatcher = SampleRepository.getInstance().getLastParameterMatcher();
        SampleRepository.getInstance().setCurrentParameterMatchers(new ComboMatcher<T>(lastMatcher, playingMatcher));
        return null;
    }

    public static <T> PersistentMatcher<T> equalsMatcher() {
        return new EqualsMatcher();
    }

    public static <T> PersistentMatcher<T> sameMatcher() {
        return (first, second) -> first == second;
    }

    public static class EqualsMatcher<T>
    implements PersistentMatcher<T> {
        @Override
        public boolean matches(T first, T second) {
            MatcherTools.checkObjectOverridesEquals(first);
            MatcherTools.checkObjectOverridesEquals(second);
            return Objects.equals(first, second);
        }
    }
}

