/*
 * Decompiled with CFR 0.152.
 */
package de.ppi.deepsampler.persistence.api;

import de.ppi.deepsampler.core.api.Matchers;
import de.ppi.deepsampler.core.error.NoMatchingParametersFoundException;
import de.ppi.deepsampler.core.internal.SampleHandling;
import de.ppi.deepsampler.core.model.Answer;
import de.ppi.deepsampler.core.model.ExecutionRepository;
import de.ppi.deepsampler.core.model.ParameterMatcher;
import de.ppi.deepsampler.core.model.SampleDefinition;
import de.ppi.deepsampler.core.model.SampleRepository;
import de.ppi.deepsampler.core.model.SampledMethod;
import de.ppi.deepsampler.persistence.PersistentSamplerContext;
import de.ppi.deepsampler.persistence.api.ComboMatcher;
import de.ppi.deepsampler.persistence.api.SourceManager;
import de.ppi.deepsampler.persistence.bean.PolymorphicPersistentBean;
import de.ppi.deepsampler.persistence.bean.ReflectionTools;
import de.ppi.deepsampler.persistence.bean.ext.BeanConverterExtension;
import de.ppi.deepsampler.persistence.error.NoMatchingSamplerFoundException;
import de.ppi.deepsampler.persistence.error.PersistenceException;
import de.ppi.deepsampler.persistence.model.PersistentMethodCall;
import de.ppi.deepsampler.persistence.model.PersistentModel;
import de.ppi.deepsampler.persistence.model.PersistentSampleMethod;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PersistentSampleManager {
    private final List<SourceManager> sourceManagerList = new ArrayList<SourceManager>();
    private final PersistentSamplerContext persistentSamplerContext = new PersistentSamplerContext();

    public PersistentSampleManager(SourceManager sourceManager) {
        this.addSourceProvider(sourceManager);
    }

    public PersistentSampleManager addSource(SourceManager sourceManager) {
        this.addSourceProvider(sourceManager);
        return this;
    }

    public PersistentSampleManager addBeanExtension(BeanConverterExtension beanConverterExtension) {
        this.persistentSamplerContext.addBeanConverterExtension(beanConverterExtension);
        return this;
    }

    public void recordSamples() {
        for (SourceManager sourceManager : this.sourceManagerList) {
            sourceManager.save(ExecutionRepository.getInstance().getAll(), this.persistentSamplerContext);
        }
    }

    public void load() {
        for (SourceManager sourceManager : this.sourceManagerList) {
            PersistentModel persistentModel = sourceManager.load();
            this.mergeSamplesFromPersistenceIntoSampleRepository(persistentModel);
        }
        if (SampleRepository.getInstance().isEmpty()) {
            throw new PersistenceException("No Samples from the file could be matched to predefined sampled methods. Did you define sampled methods using PersistentSample.of() in your test?", new Object[0]);
        }
    }

    private void mergeSamplesFromPersistenceIntoSampleRepository(PersistentModel persistentSamples) {
        SampleRepository sampleRepository = SampleRepository.getInstance();
        ArrayList<SampleDefinition> originallyDefinedSamplers = new ArrayList<SampleDefinition>(sampleRepository.getSamples());
        Set<String> unusedPersistentSampleIds = this.getPersistentSampleIds(persistentSamples);
        for (int i = 0; i < sampleRepository.size(); ++i) {
            SampleDefinition sampler = sampleRepository.get(i);
            if (!sampler.isMarkedForPersistence()) continue;
            List<SampleDefinition> mergedPersistentSamples = this.createSampleDefinitionForEachPersistentSample(persistentSamples, sampler);
            sampleRepository.replace(i, mergedPersistentSamples);
            i += mergedPersistentSamples.size() - 1;
            unusedPersistentSampleIds = this.filterUsedSampleIds(unusedPersistentSampleIds, mergedPersistentSamples);
        }
        if (!unusedPersistentSampleIds.isEmpty()) {
            throw new NoMatchingSamplerFoundException(unusedPersistentSampleIds, originallyDefinedSamplers);
        }
    }

    private Set<String> filterUsedSampleIds(Set<String> unusedPersistentSampleIds, List<SampleDefinition> mergedPersistentCalls) {
        List mergedSampleIds = mergedPersistentCalls.stream().map(SampleDefinition::getSampleId).collect(Collectors.toList());
        return unusedPersistentSampleIds.stream().filter(s -> !mergedSampleIds.contains(s)).collect(Collectors.toSet());
    }

    private Set<String> getPersistentSampleIds(PersistentModel persistentSamples) {
        return persistentSamples.getSampleMethodToSampleMap().keySet().stream().map(PersistentSampleMethod::getSampleMethodId).collect(Collectors.toSet());
    }

    private List<SampleDefinition> createSampleDefinitionForEachPersistentSample(PersistentModel persistentSamples, SampleDefinition sampler) {
        ArrayList<SampleDefinition> usedPersistentCalls = new ArrayList<SampleDefinition>();
        ArrayList<SampleDefinition> unusedPersistentCalls = new ArrayList<SampleDefinition>();
        for (PersistentSampleMethod persistentSampleMethod : persistentSamples.getSampleMethodToSampleMap().keySet()) {
            if (!persistentSampleMethod.getSampleMethodId().equals(sampler.getSampleId())) continue;
            List<PersistentMethodCall> calls = persistentSamples.getSampleMethodToSampleMap().get(persistentSampleMethod).getAllCalls();
            for (PersistentMethodCall call : calls) {
                SampleDefinition combinedSampleDefinition = this.combinePersistentSampleAndDefinedSampler(sampler, persistentSampleMethod, call);
                Object[] actualParameterValues = combinedSampleDefinition.getParameterValues().toArray();
                unusedPersistentCalls.add(combinedSampleDefinition);
                if (!SampleHandling.argumentsMatch((SampleDefinition)sampler, (Object[])actualParameterValues)) continue;
                usedPersistentCalls.add(combinedSampleDefinition);
                unusedPersistentCalls.remove(combinedSampleDefinition);
            }
        }
        if (!unusedPersistentCalls.isEmpty()) {
            throw new NoMatchingParametersFoundException(unusedPersistentCalls);
        }
        return usedPersistentCalls;
    }

    private SampleDefinition combinePersistentSampleAndDefinedSampler(SampleDefinition matchingSample, PersistentSampleMethod persistentSampleMethod, PersistentMethodCall call) {
        List<Object> parameterEnvelopes = call.getPersistentParameter().getParameter();
        Object returnValueEnvelope = call.getPersistentReturnValue();
        SampledMethod sampledMethod = matchingSample.getSampledMethod();
        Class<?> returnClass = returnValueEnvelope instanceof PolymorphicPersistentBean ? ReflectionTools.getOriginalClassFromPolymorphicPersistentBean((PolymorphicPersistentBean)returnValueEnvelope) : sampledMethod.getMethod().getReturnType();
        Type[] parameterTypes = sampledMethod.getMethod().getGenericParameterTypes();
        Type genericReturnType = sampledMethod.getMethod().getGenericReturnType();
        ParameterizedType parameterizedReturnType = genericReturnType instanceof ParameterizedType ? (ParameterizedType)genericReturnType : null;
        String joinPointId = persistentSampleMethod.getSampleMethodId();
        List<Object> parameterValues = this.unwrapValue(joinPointId, parameterTypes, parameterEnvelopes);
        List<ParameterMatcher<?>> parameterMatchers = this.toMatcher(parameterValues, matchingSample.getParameterMatchers());
        SampleDefinition sample = new SampleDefinition(sampledMethod);
        sample.setSampleId(joinPointId);
        sample.setParameterMatchers(parameterMatchers);
        sample.setParameterValues(parameterValues);
        Object returnValue = this.unwrapValue(returnClass, parameterizedReturnType, returnValueEnvelope);
        sample.setAnswer((Answer & Serializable)invocation -> returnValue);
        return sample;
    }

    private List<Object> unwrapValue(String id, Type[] parameterTypes, List<Object> parameterPersistentBeans) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (parameterTypes.length != parameterPersistentBeans.size()) {
            throw new PersistenceException("The number of parameters from the method of %s does not match the number of persistent parameters (%s:%s)!", id, parameterTypes, parameterPersistentBeans);
        }
        for (int i = 0; i < parameterPersistentBeans.size(); ++i) {
            ParameterizedType parameterType = parameterTypes[i] instanceof ParameterizedType ? (ParameterizedType)parameterTypes[i] : null;
            Class parameterClass = ReflectionTools.getRawClass(parameterTypes[i]);
            Object persistentBean = parameterPersistentBeans.get(i);
            params.add(this.unwrapValue(parameterClass, parameterType, persistentBean));
        }
        return params;
    }

    private Object unwrapValue(Class<?> targetClass, ParameterizedType type, Object persistentBean) {
        return this.persistentSamplerContext.getPersistentBeanConverter().revert(persistentBean, targetClass, type);
    }

    private List<ParameterMatcher<?>> toMatcher(List<Object> params, List<ParameterMatcher<?>> parameterMatchers) {
        ArrayList resultingParameterMatcher = new ArrayList();
        for (int i = 0; i < params.size(); ++i) {
            Object param = params.get(i);
            ParameterMatcher<?> parameterMatcher = parameterMatchers.get(i);
            if (parameterMatcher instanceof ComboMatcher) {
                resultingParameterMatcher.add(s -> ((ComboMatcher)parameterMatcher).getPersistentMatcher().matches(s, param));
                continue;
            }
            resultingParameterMatcher.add((ParameterMatcher<?>)new Matchers.EqualsMatcher(param));
        }
        return resultingParameterMatcher;
    }

    private void addSourceProvider(SourceManager sourceManager) {
        this.sourceManagerList.add(sourceManager);
    }
}

