/*
 * Decompiled with CFR 0.152.
 */
package de.ppi.deepsampler.persistence.bean;

import de.ppi.deepsampler.persistence.bean.DefaultPersistentBean;
import de.ppi.deepsampler.persistence.bean.PolymorphicPersistentBean;
import de.ppi.deepsampler.persistence.bean.ReflectionTools;
import de.ppi.deepsampler.persistence.bean.ext.BeanConverterExtension;
import de.ppi.deepsampler.persistence.bean.ext.StandardBeanConverterExtension;
import de.ppi.deepsampler.persistence.error.PersistenceException;
import de.ppi.deepsampler.persistence.model.PersistentBean;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public class PersistentBeanConverter {
    private final List<BeanConverterExtension> beanConverterExtensions = new ArrayList<BeanConverterExtension>();

    public void addExtension(BeanConverterExtension extension) {
        this.beanConverterExtensions.add(extension);
    }

    public <T> T revert(Object persistentBean, Class<T> originalBeanClass, ParameterizedType parameterizedType) {
        if (persistentBean == null) {
            return null;
        }
        Class<?> persistentBeanClass = persistentBean.getClass();
        Class<?> persistentBeanComponentType = ReflectionTools.getRootComponentType(persistentBeanClass);
        if (persistentBeanClass.isArray() && PersistentBean.class.isAssignableFrom(persistentBeanComponentType)) {
            return (T)this.revertPersistentBeanArray(persistentBean, originalBeanClass);
        }
        Optional<BeanConverterExtension> applicableExtension = this.findApplicableExtension(originalBeanClass, parameterizedType);
        if (applicableExtension.isPresent()) {
            T revertedByExtension = applicableExtension.get().revert(persistentBean, originalBeanClass, parameterizedType, this);
            if (!(revertedByExtension == null || originalBeanClass.isAssignableFrom(revertedByExtension.getClass()) || ReflectionTools.isPrimitiveOrWrapper(originalBeanClass) && ReflectionTools.isPrimitiveOrWrapper(revertedByExtension.getClass()))) {
                throw new PersistenceException("The %s#revert() returned an object of type %s, but a type of %s, or one of its subtypes, was requested.", applicableExtension.get().getClass().getName(), revertedByExtension.getClass().getName(), originalBeanClass.getName());
            }
            return revertedByExtension;
        }
        if (persistentBean instanceof PersistentBean) {
            return this.revertPersistentBean((PersistentBean)persistentBean, originalBeanClass);
        }
        if (!(originalBeanClass.isAssignableFrom(persistentBean.getClass()) || ReflectionTools.isPrimitiveOrWrapper(originalBeanClass) && ReflectionTools.isPrimitiveOrWrapper(persistentBean.getClass()))) {
            throw new PersistenceException("An object of type %s has been deserialized, but the type %s, or one of its subtypes, was requested.\n%1$s.toString() = \"%s\"", persistentBean.getClass().getName(), originalBeanClass.getName(), persistentBean.toString());
        }
        return (T)persistentBean;
    }

    public <T> T convert(Object originalBean, Type type) {
        ParameterizedType parameterizedReturnType;
        ParameterizedType parameterizedType = parameterizedReturnType = type instanceof ParameterizedType ? (ParameterizedType)type : null;
        if (this.isTransformationNotNecessary(originalBean, parameterizedReturnType)) {
            return (T)originalBean;
        }
        if (originalBean.getClass().isArray()) {
            return (T)this.convertObjectArray((Object[])originalBean);
        }
        Optional<BeanConverterExtension> applicableExtension = this.findApplicableExtension(originalBean.getClass(), parameterizedReturnType);
        if (applicableExtension.isPresent()) {
            return (T)applicableExtension.get().convert(originalBean, parameterizedReturnType, this);
        }
        if (originalBean.getClass().equals(type) || parameterizedReturnType != null && originalBean.getClass().equals(parameterizedReturnType.getRawType())) {
            return (T)this.convertToPersistentBean(originalBean);
        }
        return (T)this.convertToPolymorphicPersistentBean(originalBean.getClass().getTypeName(), originalBean);
    }

    private <T> T[] revertPersistentBeanArray(Object persistentBeanArray, Class<T> componentType) {
        T originalBeansArray = ReflectionTools.createEmptyArray(persistentBeanArray, componentType);
        for (int i = 0; i < Array.getLength(persistentBeanArray); ++i) {
            Object persistentEntry = Array.get(persistentBeanArray, i);
            Object entry = persistentEntry.getClass().isArray() ? this.revertPersistentBeanArray(persistentEntry, componentType.getComponentType()) : this.revertPersistentBean((PersistentBean)persistentEntry, componentType.getComponentType());
            Array.set(originalBeansArray, i, entry);
        }
        return (Object[])originalBeansArray;
    }

    private <T> T revertPersistentBean(PersistentBean value, Class<T> declaredOriginalBeanClass) {
        T instance;
        Class<Object> valueType = value instanceof PolymorphicPersistentBean ? ReflectionTools.getOriginalClassFromPolymorphicPersistentBean((PolymorphicPersistentBean)value) : declaredOriginalBeanClass;
        Map<Field, String> fields = this.getAllFields(valueType);
        if (this.hasFinalFields(fields)) {
            instance = this.instantiateUsingMatchingConstructor(valueType, value, fields);
        } else {
            instance = this.instantiate(valueType);
            for (Map.Entry<Field, String> entry : fields.entrySet()) {
                Field field = entry.getKey();
                String key = entry.getValue();
                this.transferFieldFromBean(value, instance, field, key);
            }
        }
        return instance;
    }

    private <T> T instantiateUsingMatchingConstructor(Class<T> type, PersistentBean persistentBean, Map<Field, String> fields) {
        try {
            return this.createInstance(type, persistentBean, fields);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PersistenceException("The type %s includes at least one final field. Therefore we tried to automatically detect a constructor accepting all field values, but weren't able to find any. If you still want to transform the bean you have to implement a %s which is able to construct the desired type %s.", e, type, StandardBeanConverterExtension.class.getName(), type);
        }
    }

    private <T> T createInstance(Class<T> type, PersistentBean persistentBean, Map<Field, String> fields) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class[] parameterTypes = (Class[])fields.keySet().stream().map(Field::getType).toArray(Class[]::new);
        List<Object> values = this.createValuesForConstructingInstance(persistentBean, fields);
        return type.getDeclaredConstructor(parameterTypes).newInstance(values.toArray());
    }

    private List<Object> createValuesForConstructingInstance(PersistentBean persistentBean, Map<Field, String> fields) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry<Field, String> entry : fields.entrySet()) {
            Field field = entry.getKey();
            String key = entry.getValue();
            Object lookedUpValueInBean = persistentBean.getValue(key);
            if (lookedUpValueInBean instanceof DefaultPersistentBean) {
                lookedUpValueInBean = this.revertPersistentBean((DefaultPersistentBean)lookedUpValueInBean, field.getType());
            }
            values.add(lookedUpValueInBean);
        }
        return values;
    }

    private boolean hasFinalFields(Map<Field, String> fields) {
        return fields.entrySet().stream().anyMatch(entry -> Modifier.isFinal(((Field)entry.getKey()).getModifiers()));
    }

    private <T> void transferFieldFromBean(PersistentBean persistentBean, T instance, Field field, String fieldKeyInPersistentBean) {
        Object lookedUpValueInBean = persistentBean.getValue(fieldKeyInPersistentBean);
        if (lookedUpValueInBean != null) {
            lookedUpValueInBean = this.revert(lookedUpValueInBean, field.getType(), null);
            this.setValue(instance, field, lookedUpValueInBean);
        }
    }

    private <T> T instantiate(Class<T> cls) {
        ObjenesisStd objenesis = new ObjenesisStd();
        ObjectInstantiator instantiatorOf = objenesis.getInstantiatorOf(cls);
        return (T)instantiatorOf.newInstance();
    }

    private Object convertObjectArray(Object[] objects) {
        int[] dimensions = ReflectionTools.getArrayDimensions(objects);
        Class<?> componentType = Array.newInstance(PersistentBean.class, dimensions).getClass();
        Object persistentBeans = ReflectionTools.createEmptyArray(objects, componentType);
        for (int i = 0; i < objects.length; ++i) {
            Object subElement = this.convert(objects[i], null);
            Array.set(persistentBeans, i, subElement);
        }
        return persistentBeans;
    }

    private PersistentBean convertToPolymorphicPersistentBean(String type, Object obj) {
        Map<String, Object> valuesForBean = this.getValueMapForObjects(obj);
        return new PolymorphicPersistentBean(valuesForBean, type);
    }

    private PersistentBean convertToPersistentBean(Object obj) {
        Map<String, Object> valuesForBean = this.getValueMapForObjects(obj);
        return new DefaultPersistentBean(valuesForBean);
    }

    private Map<String, Object> getValueMapForObjects(Object obj) {
        Map<Field, String> fieldStringMap = this.getAllFields(obj.getClass());
        HashMap<String, Object> valuesForBean = new HashMap<String, Object>();
        for (Map.Entry<Field, String> entry : fieldStringMap.entrySet()) {
            ParameterizedType parameterizedFieldType;
            String keyForField = entry.getValue();
            Field field = entry.getKey();
            Object fieldValue = this.retrieveValue(obj, field);
            Type fieldType = field.getGenericType();
            ParameterizedType parameterizedType = parameterizedFieldType = fieldType instanceof ParameterizedType ? (ParameterizedType)fieldType : null;
            if (fieldValue != null) {
                fieldValue = this.convert(fieldValue, parameterizedFieldType);
            }
            valuesForBean.put(keyForField, fieldValue);
        }
        return valuesForBean;
    }

    private void setValue(Object obj, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Object retrieveValue(Object obj, Field field) {
        Object fieldValue;
        try {
            field.setAccessible(true);
            fieldValue = field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        return fieldValue;
    }

    private Map<Field, String> getAllFields(Class<?> cls) {
        LinkedHashMap<Field, String> fields = new LinkedHashMap<Field, String>();
        int depth = 0;
        for (Class<?> currentCls = cls; currentCls != null; currentCls = currentCls.getSuperclass()) {
            for (Field field : currentCls.getDeclaredFields()) {
                if (field.isSynthetic() || Modifier.isStatic(field.getModifiers())) continue;
                fields.put(field, String.format("%s$%s", depth, field.getName()));
            }
            ++depth;
        }
        return fields;
    }

    private Optional<BeanConverterExtension> findApplicableExtension(Class<?> beanClass, ParameterizedType parameterizedType) {
        List allApplicableExtensions = this.beanConverterExtensions.stream().filter(ext -> ext.isProcessable(beanClass, parameterizedType)).collect(Collectors.toList());
        return allApplicableExtensions.isEmpty() ? Optional.empty() : Optional.of((BeanConverterExtension)allApplicableExtensions.get(allApplicableExtensions.size() - 1));
    }

    private boolean isTransformationNotNecessary(Object obj, ParameterizedType parameterizedType) {
        return obj == null || obj.getClass().isEnum() || ReflectionTools.isPrimitiveOrWrapper(obj.getClass()) || !ReflectionTools.isObjectArray(obj.getClass()) && obj.getClass().isArray() || this.findApplicableExtension(obj.getClass(), parameterizedType).map(ext -> ext.skip(obj.getClass(), parameterizedType)).orElse(false) != false;
    }
}

