/*
 * Decompiled with CFR 0.152.
 */
package de.ppi.deepsampler.persistence.bean;

import de.ppi.deepsampler.persistence.bean.PolymorphicPersistentBean;
import de.ppi.deepsampler.persistence.error.PersistenceException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class ReflectionTools {
    private ReflectionTools() {
    }

    public static boolean isObjectArray(Class<?> cls) {
        if (!cls.isArray()) {
            return false;
        }
        if (cls.getComponentType() != null && cls.getComponentType().isArray()) {
            return ReflectionTools.isObjectArray(cls.getComponentType());
        }
        return cls != int[].class && cls != Integer[].class && cls != boolean[].class && cls != Boolean[].class && cls != byte[].class && cls != Byte[].class && cls != short[].class && cls != Short[].class && cls != long[].class && cls != Long[].class && cls != char[].class && cls != String[].class && cls != Character[].class && cls != Float[].class && cls != float[].class && cls != Double[].class && cls != double[].class;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> cls) {
        return cls.isPrimitive() || cls == Integer.class || cls == Boolean.class || cls == Byte.class || cls == Short.class || cls == Long.class || cls == String.class || cls == Character.class || cls == Float.class || cls == Double.class;
    }

    public static boolean hasPrimitiveTypeParameters(Type type) {
        return ReflectionTools.hasPrimitiveTypeParameters(type, 1);
    }

    public static boolean hasPrimitiveTypeParameters(Type type, int numberOfParametersToCheck) {
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        if (numberOfParametersToCheck > parameterizedType.getActualTypeArguments().length) {
            throw new PersistenceException("We tried to check if the first %d generic type parameter of %s were primitive wrappers, but we have only %d parameters", numberOfParametersToCheck, type.getTypeName(), parameterizedType.getActualTypeArguments().length);
        }
        if (numberOfParametersToCheck == 0) {
            throw new PersistenceException("numberOfParameterToCheck must be > 0. It is not the index, but the number of the first parameters that should be checked.", new Object[0]);
        }
        if (parameterizedType.getRawType() instanceof Class) {
            for (int i = 0; i < numberOfParametersToCheck; ++i) {
                Type parameter = parameterizedType.getActualTypeArguments()[i];
                if (parameter instanceof Class) {
                    if (ReflectionTools.isPrimitiveOrWrapper((Class)parameter)) continue;
                    return false;
                }
                if (parameter instanceof ParameterizedType) {
                    return false;
                }
                throw new PersistenceException("We cannot determine the generic type parameter of %s because the actualTypeArgument is %s. Instead, we need a %s. This can be achieved e.g. by retrieving the type from Class::getMethod()::getGenericReturnType()", type.getTypeName(), parameterizedType.getActualTypeArguments()[0].getTypeName(), Class.class.getTypeName());
            }
        }
        return true;
    }

    public static <T> Class<T> getRawClass(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    public static ParameterizedType getParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        return null;
    }

    public static <T> T createEmptyArray(Object templateArray, Class<T> newArrayType) {
        Object copy = Array.newInstance(newArrayType.getComponentType(), Array.getLength(templateArray));
        if (newArrayType.getComponentType() != null && newArrayType.getComponentType().isArray()) {
            for (int i = 0; i < Array.getLength(templateArray); ++i) {
                Object subArray = ReflectionTools.createEmptyArray(Array.get(templateArray, i), newArrayType.getComponentType());
                Array.set(copy, i, subArray);
            }
        }
        return (T)copy;
    }

    public static int[] getArrayDimensions(Object array) {
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        dimensions.add(Array.getLength(array));
        Class<?> componentType = array.getClass().getComponentType();
        Object subArray = array;
        while (componentType.isArray()) {
            subArray = Array.get(subArray, 0);
            dimensions.add(Array.getLength(subArray));
            componentType = subArray.getClass().getComponentType();
        }
        int[] dimensionsArray = new int[dimensions.size()];
        for (int i = 0; i < dimensionsArray.length; ++i) {
            dimensionsArray[i] = (Integer)dimensions.get(i);
        }
        return dimensionsArray;
    }

    public static Class<?> getRootComponentType(Class<?> array) {
        Class<?> componentType = array.getComponentType();
        if (componentType == null) {
            return array;
        }
        if (ReflectionTools.getRawClass(componentType).isArray()) {
            return ReflectionTools.getRootComponentType(ReflectionTools.getRawClass(componentType).getComponentType());
        }
        return componentType;
    }

    public static <T> T parseString(String source, Class<T> wrapperType) {
        try {
            if (Character.class == wrapperType) {
                Constructor<T> constructor = wrapperType.getConstructor(Character.TYPE);
                return constructor.newInstance(Character.valueOf(source.charAt(0)));
            }
            Constructor<T> constructor = wrapperType.getConstructor(String.class);
            return constructor.newInstance(source);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PersistenceException("We were unable to parse %s from %s", e, wrapperType.getTypeName(), source);
        }
    }

    public static Class<?> getOriginalClassFromPolymorphicPersistentBean(PolymorphicPersistentBean polymorphicPersistentBean) {
        try {
            return Class.forName(polymorphicPersistentBean.getPolymorphicBeanType());
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException("The Polymorphic Class %s was not found. This occurs if a polymorphic class was recorded but is not in the classpath (anymore?)", e, polymorphicPersistentBean.getPolymorphicBeanType());
        }
    }
}

