/*
 * Decompiled with CFR 0.152.
 */
package de.ppi.deepsampler.persistence.bean.ext;

import de.ppi.deepsampler.persistence.bean.PersistentBeanConverter;
import de.ppi.deepsampler.persistence.bean.ReflectionTools;
import de.ppi.deepsampler.persistence.bean.ext.BeanConverterExtension;
import de.ppi.deepsampler.persistence.bean.ext.StandardBeanConverterExtension;
import de.ppi.deepsampler.persistence.error.PersistenceException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CollectionExtension
extends StandardBeanConverterExtension {
    @Override
    public boolean isProcessable(Class<?> beanClass, ParameterizedType parameterizedType) {
        return Collection.class.isAssignableFrom(beanClass);
    }

    @Override
    public boolean skip(Class<?> beanClass, ParameterizedType beanType) {
        return ReflectionTools.hasPrimitiveTypeParameters(beanType);
    }

    @Override
    public Object convert(Object originalBean, ParameterizedType parameterizedType, PersistentBeanConverter persistentBeanConverter) {
        if (!(originalBean instanceof Collection)) {
            throw new PersistenceException("The type %s is not a Collection but we tried to apply the %s on it.", originalBean.getClass().getName(), this.getClass().getName());
        }
        Type entryType = this.getCollectionsEntryType(originalBean.getClass(), parameterizedType);
        Collection<Object> convertedCollection = this.getNewCollection(originalBean.getClass());
        ((Collection)originalBean).stream().map(entry -> persistentBeanConverter.convert(entry, entryType)).forEach(convertedCollection::add);
        return convertedCollection;
    }

    @Override
    public <T> T revert(Object persistentBean, Class<T> targetBeanClass, ParameterizedType targetBeanType, PersistentBeanConverter persistentBeanConverter) {
        Class collectionElementClass;
        ParameterizedType collectionElementType;
        Type entryType = this.getCollectionsEntryType(targetBeanClass, targetBeanType);
        if (entryType instanceof ParameterizedType) {
            collectionElementType = (ParameterizedType)entryType;
            collectionElementClass = (Class)collectionElementType.getRawType();
        } else {
            collectionElementType = null;
            collectionElementClass = (Class)entryType;
        }
        Collection<Object> originalCollection = this.getNewCollection(persistentBean.getClass());
        ((Collection)persistentBean).stream().map(o -> persistentBeanConverter.revert(o, collectionElementClass, collectionElementType)).forEach(originalCollection::add);
        return (T)originalCollection;
    }

    private Collection<Object> getNewCollection(Class<?> persistentBeanClass) {
        try {
            Constructor<?> defaultConstructor = persistentBeanClass.getConstructor(new Class[0]);
            return (Collection)defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            if (Set.class.isAssignableFrom(persistentBeanClass)) {
                return new HashSet<Object>();
            }
            return new ArrayList<Object>();
        }
    }

    private Type getCollectionsEntryType(Class<?> originalBeanClass, ParameterizedType parameterizedType) {
        if (parameterizedType == null) {
            throw new PersistenceException("%s is only able to serialize subtypes of Collections, that declare exactly one generic type parameter. %s does not have any generic type parameters. The type parameter is necessary to detect the type of the objects inside of the Collection. %s's can be used to tell DeepSampler, how to de/serialize beans, that cannot be serialized by DeepSampler out of the box.", this.getClass().getSimpleName(), originalBeanClass.getName(), BeanConverterExtension.class.getName());
        }
        if (parameterizedType.getActualTypeArguments().length != 1) {
            throw new PersistenceException("%s is only able to serialize subtypes of Collections, that declare exactly one generic type parameter. %s declares %d type parameters. The type parameter is necessary to detect the type of the objects inside of the Collection. %s's can be used to tell DeepSampler, how to de/serialize beans, that cannot be serialized by DeepSampler out of the box.", this.getClass().getSimpleName(), originalBeanClass.getName(), parameterizedType.getActualTypeArguments().length, BeanConverterExtension.class.getName());
        }
        return parameterizedType.getActualTypeArguments()[0];
    }
}

