/*
 * Decompiled with CFR 0.152.
 */
package de.ppi.deepsampler.persistence.bean.ext;

import de.ppi.deepsampler.persistence.bean.PersistentBeanConverter;
import de.ppi.deepsampler.persistence.bean.ReflectionTools;
import de.ppi.deepsampler.persistence.bean.ext.StandardBeanConverterExtension;
import de.ppi.deepsampler.persistence.error.PersistenceException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class MapPrimitiveKeyExtension
extends StandardBeanConverterExtension {
    @Override
    public boolean isProcessable(Class<?> beanClass, ParameterizedType beanType) {
        return Map.class.isAssignableFrom(ReflectionTools.getRawClass(beanClass)) && beanType.getActualTypeArguments().length == 2 && ReflectionTools.hasPrimitiveTypeParameters(beanType);
    }

    @Override
    public Object convert(Object originalBean, ParameterizedType beanType, PersistentBeanConverter persistentBeanConverter) {
        if (!(originalBean instanceof Map)) {
            throw new PersistenceException("The type %s is not a Map but we tried to apply the %s on it.", originalBean.getClass().getName(), this.getClass().getName());
        }
        Map<Object, Object> convertedMap = this.createNewMap(originalBean.getClass());
        ParameterizedType entryType = beanType.getActualTypeArguments()[1] instanceof ParameterizedType ? (ParameterizedType)beanType.getActualTypeArguments()[1] : null;
        for (Map.Entry entry : ((Map)originalBean).entrySet()) {
            Object value = persistentBeanConverter.convert(entry.getValue(), entryType);
            String key = entry.getKey() != null ? entry.getKey().toString() : "null";
            convertedMap.put(key, value);
        }
        return convertedMap;
    }

    private Map<Object, Object> createNewMap(Class<?> originalBeanClass) {
        try {
            return this.instantiateMap(originalBeanClass);
        }
        catch (PersistenceException e) {
            return new HashMap<Object, Object>();
        }
    }

    private Map<Object, Object> instantiateMap(Class<?> persistentBeanClass) {
        try {
            Constructor<?> defaultConstructor = persistentBeanClass.getConstructor(new Class[0]);
            return (Map)defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new PersistenceException("The targetType %s cannot be instantiated.", e, persistentBeanClass.getTypeName());
        }
    }

    @Override
    public <T> T revert(Object persistentBean, Class<T> targetClass, ParameterizedType type, PersistentBeanConverter persistentBeanConverter) {
        Class valueClass;
        ParameterizedType valueType;
        Type[] genericParameterTypes = type.getActualTypeArguments();
        if (genericParameterTypes.length != 2) {
            throw new PersistenceException("%s is only able to deserialize to Map<String, V>. But we try to deserialize %s", this.getClass().getTypeName(), targetClass.getTypeName());
        }
        if (genericParameterTypes[1] instanceof ParameterizedType) {
            valueType = (ParameterizedType)genericParameterTypes[1];
            valueClass = (Class)valueType.getRawType();
        } else {
            valueType = null;
            valueClass = (Class)genericParameterTypes[1];
        }
        Class keyClass = (Class)genericParameterTypes[0];
        Map<Object, Object> valueMap = this.instantiateMap(persistentBean.getClass());
        for (Map.Entry entry : ((Map)persistentBean).entrySet()) {
            Object key = ReflectionTools.parseString((String)entry.getKey(), keyClass);
            Object value = persistentBeanConverter.revert(entry.getValue(), valueClass, valueType);
            valueMap.put(key, value);
        }
        return (T)valueMap;
    }
}

