/*
 * Decompiled with CFR 0.152.
 */
package de.ppi.deepsampler.persistence.bean.ext;

import de.ppi.deepsampler.persistence.bean.DefaultPersistentBean;
import de.ppi.deepsampler.persistence.bean.PersistentBeanConverter;
import de.ppi.deepsampler.persistence.bean.ReflectionTools;
import de.ppi.deepsampler.persistence.bean.ext.StandardBeanConverterExtension;
import de.ppi.deepsampler.persistence.model.PersistentBean;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public class OptionalExtension
extends StandardBeanConverterExtension {
    public static final String OPTIONAL_PROPERTY = "optionalValue";

    @Override
    public boolean isProcessable(Class<?> beanClass, ParameterizedType beanType) {
        return Optional.class.isAssignableFrom(beanClass);
    }

    @Override
    public Object convert(Object originalBean, ParameterizedType beanType, PersistentBeanConverter persistentBeanConverter) {
        Type optionalsValueType = beanType.getActualTypeArguments()[0];
        Object convertedOptionalValue = ((Optional)originalBean).map(o -> persistentBeanConverter.convert(o, optionalsValueType)).orElse(null);
        DefaultPersistentBean persistentBean = new DefaultPersistentBean();
        persistentBean.putValue(OPTIONAL_PROPERTY, convertedOptionalValue);
        return persistentBean;
    }

    @Override
    public <T> T revert(Object persistentBean, Class<T> targetClass, ParameterizedType type, PersistentBeanConverter persistentBeanConverter) {
        Object optionalValue = ((PersistentBean)persistentBean).getValue(OPTIONAL_PROPERTY);
        Class optionalsValueType = ReflectionTools.getRawClass(type.getActualTypeArguments()[0]);
        ParameterizedType optionalsValueParameterizedType = ReflectionTools.getParameterizedType(type.getActualTypeArguments()[0]);
        Object revertedValue = persistentBeanConverter.revert(optionalValue, optionalsValueType, optionalsValueParameterizedType);
        return (T)Optional.ofNullable(revertedValue);
    }
}

