/*
 * Decompiled with CFR 0.152.
 */
package de.ppi.deepsampler.persistence.error;

import de.ppi.deepsampler.core.internal.FuzzySearchUtility;
import de.ppi.deepsampler.core.model.SampleDefinition;
import de.ppi.deepsampler.persistence.error.PersistenceException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class NoMatchingSamplerFoundException
extends PersistenceException {
    public NoMatchingSamplerFoundException(String unusedSamplerId, List<SampleDefinition> definedSampleDefinitions) {
        super("The persistent Sample with the id '%s' doesn't have a corresponding Sampler. %sPlease define a Sampler using PersistentSampler.of(...)", unusedSamplerId, NoMatchingSamplerFoundException.guessCorrectSampler(unusedSamplerId, definedSampleDefinitions));
    }

    public NoMatchingSamplerFoundException(Collection<String> unusedSamplerIds, List<SampleDefinition> definedSampleDefinitions) {
        super("The following persistent Samples don't have a corresponding Sampler. Please define a Sampler using PersistentSampler.of(...):\n%s", NoMatchingSamplerFoundException.formatMissingSamplerIds(unusedSamplerIds, definedSampleDefinitions));
    }

    private static String formatMissingSamplerIds(Collection<String> unusedSamplerIds, List<SampleDefinition> definedSampleDefinitions) {
        return unusedSamplerIds.stream().map(id -> "\t" + id + NoMatchingSamplerFoundException.guessCorrectSampler(id, definedSampleDefinitions)).collect(Collectors.joining("\n"));
    }

    private static String guessCorrectSampler(String unusedSamplerId, List<SampleDefinition> definedSampleDefinitions) {
        FuzzySearchUtility.Match match = FuzzySearchUtility.findClosestObject((String)unusedSamplerId, definedSampleDefinitions, SampleDefinition::getSampleId);
        if (match != null && match.getEquality() > 0.5) {
            if (!((SampleDefinition)match.getMatchedObject()).isMarkedForPersistence()) {
                return "\n\t\t" + ((SampleDefinition)match.getMatchedObject()).getSampleId() + " seems to be quite similar, but it was not marked for persistence. Use PersistentSampler.of() instead of Sampler.of(), if the Sample should be provided from persistence.";
            }
            return "\n\t\t did you mean " + ((SampleDefinition)match.getMatchedObject()).getSampleId() + "?";
        }
        return "";
    }
}

