package de.ppi.oss.kzulip.api.common

/**
 * Based on <a href="https://raw.githubusercontent.com/zulip/zulip/a2a695dfa7a3fbd9d406dcce9c6299e41c6a445d/tools/setup/emoji/emoji_map.json">emoji_map.json</a>
 * emoji_codes.js which can be found at installation there the point exports.name_to_codepoint
 * created via
 * '(.*)': '(.*)' - \U$1\E(0x$2), "$1"),
 * ^([0-9]) - _$1
 * +1 - PLUS1
 * -1 - MINUS1
 * E-MAIL - E_MAIL2
 * NON-POTABLE_WATER - NON_POTABLE_WATER2
 * <p>
 */
@Suppress("unused")
enum class Emoji(val unicodeCodePoint: Int, val nameInZulip: String) {
    SPACE_INVADER(0x1f47e, "space_invader"),
    SCIENTIST(0x1f52c, "scientist"),
    SHOPPING_CART(0x1f6d2, "shopping_cart"),
    CONSTRUCTION(0x1f3d7, "construction"),
    FOUNTAIN_PEN(0x1f58b, "fountain_pen"),
    HONEY(0x1f36f, "honey"),
    LIPSTICK_KISS(0x1f48b, "lipstick_kiss"),
    JEEP(0x1f699, "jeep"),
    POTABLE_WATER(0x1f6b0, "potable_water"),
    TROPICAL_DRINK(0x1f379, "tropical_drink"),
    HUSHED(0x1f62f, "hushed"),
    NAME_BADGE(0x1f4db, "name_badge"),
    NUMBER_ONE(0x1f947, "number_one"),
    ASTONISHED(0x1f632, "astonished"),
    RED_BOOK(0x1f4d5, "red_book"),
    BLUE_BOOK(0x1f4d8, "blue_book"),
    PIRATE(0x2620, "pirate"),
    WHITE_MEDIUM_SQUARE(0x25fb, "white_medium_square"),
    BLACK_BELT(0x1f94b, "black_belt"),
    PING_PONG(0x1f3d3, "ping_pong"),
    TIMES_UP(0x231b, "times_up"),
    EMPTY_MAILBOX(0x1f4ed, "empty_mailbox"),
    WARNING(0x26a0, "warning"),
    STRAWBERRY(0x1f353, "strawberry"),
    CHILDREN_CROSSING(0x1f6b8, "children_crossing"),
    GRINNING(0x1f600, "grinning"),
    WRENCH(0x1f527, "wrench"),
    DANCER(0x1f483, "dancer"),
    BLANK(0x1f636, "blank"),
    POISON(0x2620, "poison"),
    HEARTACHE(0x1f494, "heartache"),
    MUSHROOM(0x1f344, "mushroom"),
    ROBOT(0x1f916, "robot"),
    PRESENT(0x1f381, "present"),
    MENORAH(0x1f54e, "menorah"),
    RED_CIRCLE(0x1f534, "red_circle"),
    SMUG(0x1f60f, "smug"),
    UNLOCKED(0x1f513, "unlocked"),
    FENCING(0x1f93a, "fencing"),
    MIDDLE_FINGER(0x1f595, "middle_finger"),
    TWO_WOMEN_HOLDING_HANDS(0x1f46d, "two_women_holding_hands"),
    SPEAKING_HEAD(0x1f5e3, "speaking_head"),
    NOT_ALLOWED(0x1f6ab, "not_allowed"),
    DETECTIVE(0x1f575, "detective"),
    SATCHEL(0x1f392, "satchel"),
    COFFEE(0x2615, "coffee"),
    POINT_RIGHT(0x1f449, "point_right"),
    STEW(0x1f372, "stew"),
    MEAL(0x1f37d, "meal"),
    DEBIT_CARD(0x1f4b3, "debit_card"),
    GUESTROOMS(0x1f6cc, "guestrooms"),
    PERSON_TIPPING_HAND(0x1f481, "person_tipping_hand"),
    SWEET_POTATO(0x1f360, "sweet_potato"),
    NATIONAL_PARK(0x1f3de, "national_park"),
    KIWI(0x1f95d, "kiwi"),
    REVOLVING_HEARTS(0x1f49e, "revolving_hearts"),
    PEAR(0x1f350, "pear"),
    POUND_NOTES(0x1f4b7, "pound_notes"),
    CUSTARD(0x1f36e, "custard"),
    FOOTBALL(0x26bd, "football"),
    _1234(0x1f522, "1234"),
    MINUS1(0x1f44e, "-1"),
    CHICK(0x1f424, "chick"),
    OPEN_MOUTH(0x1f62e, "open_mouth"),
    BLUSHING(0x1f633, "blushing"),
    DOLLAR_BILLS(0x1f4b5, "dollar_bills"),
    LOVE(0x2764, "love"),
    LOLLIPOP(0x1f36d, "lollipop"),
    AERIAL_TRAMWAY(0x1f6a1, "aerial_tramway"),
    KING(0x1f451, "king"),
    MAIL_RECEIVED(0x1f4e8, "mail_received"),
    SEASHELL(0x1f41a, "seashell"),
    DARTS(0x1f3af, "darts"),
    AGENT(0x1f575, "agent"),
    MOTHER_NATURE(0x1f32c, "mother_nature"),
    HAMBURGER(0x1f354, "hamburger"),
    WHITE_CIRCLE(0x26aa, "white_circle"),
    KICK_SCOOTER(0x1f6f4, "kick_scooter"),
    OOPS(0x1f643, "oops"),
    LEFT_HOOK(0x21a9, "left_hook"),
    SCORPIUS(0x264f, "scorpius"),
    BRAVERY(0x1f49c, "bravery"),
    COOKING(0x1f373, "cooking"),
    HAMMER_AND_PICK(0x2692, "hammer_and_pick"),
    HAT(0x1f452, "hat"),
    CANCER(0x264b, "cancer"),
    HOT(0x1f525, "hot"),
    RUNNING_SHIRT(0x1f3bd, "running_shirt"),
    FLIPPER(0x1f42c, "flipper"),
    THUMBS_DOWN(0x1f44e, "thumbs_down"),
    OPEN_BOOK(0x1f4d6, "open_book"),
    CHERRIES(0x1f352, "cherries"),
    IMP(0x1f47f, "imp"),
    BED(0x1f6cf, "bed"),
    METEOR(0x2604, "meteor"),
    SPOCK(0x1f596, "spock"),
    ADD(0x2795, "add"),
    DISTRAUGHT(0x1f629, "distraught"),
    LARGE_BLUE_DIAMOND(0x1f537, "large_blue_diamond"),
    RACECAR(0x1f3ce, "racecar"),
    SICK(0x1f912, "sick"),
    EAST(0x27a1, "east"),
    FORK_AND_KNIFE(0x1f374, "fork_and_knife"),
    COLLISION(0x1f4a5, "collision"),
    MOUTH(0x1f444, "mouth"),
    HI(0x1f44b, "hi"),
    ATOM(0x269b, "atom"),
    WRONG_WAY(0x26d4, "wrong_way"),
    ENGINEER(0x2699, "engineer"),
    RADIOACTIVE(0x2622, "radioactive"),
    CHILI_PEPPER(0x1f336, "chili_pepper"),
    HIGH_BRIGHTNESS(0x1f506, "high_brightness"),
    TURTLE(0x1f422, "turtle"),
    BATH(0x1f6c0, "bath"),
    DOWN_BUTTON(0x1f53d, "down_button"),
    HUG(0x1f917, "hug"),
    DOUGHNUT(0x1f369, "doughnut"),
    MOON(0x1f319, "moon"),
    BELL(0x1f514, "bell"),
    FAST_REVERSE(0x23ea, "fast_reverse"),
    CONFOUNDED(0x1f616, "confounded"),
    MONEY_FACE(0x1f911, "money_face"),
    BLACK_MEDIUM_SMALL_SQUARE(0x25fe, "black_medium_small_square"),
    A(0x1f170, "a"),
    SCREAM_CAT(0x1f640, "scream_cat"),
    KEY_SIGNING(0x1f50f, "key_signing"),
    MEOW(0x1f408, "meow"),
    CHAMPAGNE(0x1f37e, "champagne"),
    SMILING_FACE_WITH_HORNS(0x1f608, "smiling_face_with_horns"),
    HAND(0x270b, "hand"),
    ENCRYPTED(0x1f5dd, "encrypted"),
    MANTELPIECE_CLOCK(0x1f570, "mantelpiece_clock"),
    LADYBUG(0x1f41e, "ladybug"),
    SMITTEN(0x1f498, "smitten"),
    OK_SIGNAL(0x1f646, "ok_signal"),
    FLOPPY_DISK(0x1f4be, "floppy_disk"),
    PLAY(0x25b6, "play"),
    DASH(0x1f4a8, "dash"),
    MINUS(0x2796, "minus"),
    MUTE(0x1f507, "mute"),
    VHS(0x1f4fc, "vhs"),
    PIZZA(0x1f355, "pizza"),
    SNOWMAN(0x2603, "snowman"),
    KITTEN(0x1f431, "kitten"),
    TRADEMARK(0x2122, "trademark"),
    GEEK(0x1f913, "geek"),
    FLIP_FLOPS(0x1f461, "flip_flops"),
    POUCH(0x1f45d, "pouch"),
    DISAPPOINTED_RELIEVED(0x1f625, "disappointed_relieved"),
    FREE(0x1f193, "free"),
    CAR(0x1f697, "car"),
    NEW_MOON(0x1f311, "new_moon"),
    PRIVACY(0x1f50f, "privacy"),
    WALKING(0x1f6b6, "walking"),
    CONVENIENCE_STORE(0x1f3ea, "convenience_store"),
    BUNNY(0x1f430, "bunny"),
    MOTORWAY(0x1f6e3, "motorway"),
    RECEPTION(0x1f6ce, "reception"),
    DRESS(0x1f457, "dress"),
    BIOHAZARD(0x2623, "biohazard"),
    TRAIN_TRACKS(0x1f6e4, "train_tracks"),
    IN_BED(0x1f6cc, "in_bed"),
    MAINTENANCE(0x1f528, "maintenance"),
    CRAB(0x1f980, "crab"),
    WOMAN(0x1f469, "woman"),
    LOOP(0x27b0, "loop"),
    STADIUM(0x1f3df, "stadium"),
    DOGI(0x1f94b, "dogi"),
    MEDICINE(0x1f48a, "medicine"),
    GONDOLA(0x1f6a0, "gondola"),
    HATCHING(0x1f423, "hatching"),
    WEST(0x2b05, "west"),
    PARTY_BALL(0x1f38a, "party_ball"),
    SURRENDER(0x1f3f3, "surrender"),
    LOUDER(0x1f50a, "louder"),
    GOT_IT(0x1f44c, "got_it"),
    FERRIS_WHEEL(0x1f3a1, "ferris_wheel"),
    NIGHT(0x1f303, "night"),
    BRIGHTNESS(0x1f506, "brightness"),
    EAR(0x1f442, "ear"),
    BAT(0x1f987, "bat"),
    ROLLING_ON_THE_FLOOR_LAUGHING(0x1f923, "rolling_on_the_floor_laughing"),
    CAMPSITE(0x1f3d5, "campsite"),
    ARRIVAL(0x1f6ec, "arrival"),
    DOWN(0x2b07, "down"),
    DESKTOP_COMPUTER(0x1f5a5, "desktop_computer"),
    OLD_KEY(0x1f5dd, "old_key"),
    STAR_OF_DAVID(0x2721, "star_of_david"),
    SUNGLASSES(0x1f60e, "sunglasses"),
    CRAYON(0x1f58d, "crayon"),
    POW(0x1f4a2, "pow"),
    NAUSEATED(0x1f922, "nauseated"),
    HINT(0x1f5dd, "hint"),
    DANGER(0x26a0, "danger"),
    HOLE_IN_ONE(0x26f3, "hole_in_one"),
    HUNGRY(0x1f37d, "hungry"),
    BULLHORN(0x1f4e2, "bullhorn"),
    SPEAK_NO_EVIL(0x1f64a, "speak_no_evil"),
    MOUNTAIN_SUNRISE(0x1f304, "mountain_sunrise"),
    VIOLIN(0x1f3bb, "violin"),
    CONDEMNED(0x1f3da, "condemned"),
    WOLF(0x1f43a, "wolf"),
    TEA(0x1f375, "tea"),
    MANDARIN(0x1f34a, "mandarin"),
    BALL(0x26f9, "ball"),
    SUSHI(0x1f363, "sushi"),
    REMINDER_RIBBON(0x1f397, "reminder_ribbon"),
    RAT(0x1f400, "rat"),
    OVERCAST(0x2601, "overcast"),
    BEGINNER(0x1f530, "beginner"),
    PLANT(0x1f33f, "plant"),
    ICE_HOCKEY(0x1f3d2, "ice_hockey"),
    SUNFLOWER(0x1f33b, "sunflower"),
    AT_WORK(0x2692, "at_work"),
    BILLIARDS(0x1f3b1, "billiards"),
    DECREASING(0x1f4c9, "decreasing"),
    HORIZONTAL_TRAFFIC_LIGHT(0x1f6a5, "horizontal_traffic_light"),
    MOUSE(0x1f401, "mouse"),
    LEO(0x264c, "leo"),
    OFFICE(0x1f3e2, "office"),
    AGONY(0x1f616, "agony"),
    CASTLE(0x1f3f0, "castle"),
    CAMPING(0x26fa, "camping"),
    PAINTBRUSH(0x1f58c, "paintbrush"),
    FACTORY(0x1f3ed, "factory"),
    MUSIC(0x1f3b5, "music"),
    WHITE_FLOWER(0x1f4ae, "white_flower"),
    HALF_FROWN(0x1f615, "half_frown"),
    AMPHORA(0x1f3fa, "amphora"),
    NON_POTABLE_WATER(0x1f6b1, "non-potable_water"),
    PLACE_OF_WORSHIP(0x1f6d0, "place_of_worship"),
    PRIDE(0x1f308, "pride"),
    COOKIE(0x1f36a, "cookie"),
    FOGGY(0x1f301, "foggy"),
    RESCUE_WORKER(0x26d1, "rescue_worker"),
    FOUR_LEAF_CLOVER(0x1f340, "four_leaf_clover"),
    BABY_CHICK(0x1f424, "baby_chick"),
    BOOM(0x1f4a5, "boom"),
    UNDERAGE(0x1f51e, "underage"),
    PERFORMING_ARTS(0x1f3ad, "performing_arts"),
    ANCHOR(0x2693, "anchor"),
    SUBTRACT(0x2796, "subtract"),
    DONE_DEAL(0x1f91d, "done_deal"),
    SLIGHT_SMILE(0x1f642, "slight_smile"),
    PAGE(0x1f4c4, "page"),
    GLASSES(0x1f453, "glasses"),
    OLDER_MAN(0x1f474, "older_man"),
    SKIP_BACK(0x23ee, "skip_back"),
    HANDYMAN(0x1f528, "handyman"),
    CAKE(0x1f370, "cake"),
    ONCOMING_POLICE_CAR(0x1f694, "oncoming_police_car"),
    INNOCENT(0x1f607, "innocent"),
    STOPWATCH(0x23f1, "stopwatch"),
    STUCK_OUT_TONGUE(0x1f61d, "stuck_out_tongue"),
    TM(0x2122, "tm"),
    BUTTERFLY(0x1f98b, "butterfly"),
    HEART_ARROW(0x1f498, "heart_arrow"),
    PIG_NOSE(0x1f43d, "pig_nose"),
    SPIRAL_SHELL(0x1f41a, "spiral_shell"),
    BOO(0x1f47b, "boo"),
    SMUG_CAT(0x1f63c, "smug_cat"),
    RECORD(0x23fa, "record"),
    SUNSHOWERS(0x1f326, "sunshowers"),
    MONORAIL(0x1f69d, "monorail"),
    ALIEN(0x1f47d, "alien"),
    SANDAL(0x1f461, "sandal"),
    JOY(0x1f602, "joy"),
    BUS(0x1f68c, "bus"),
    DOWNVOTE(0x1f53d, "downvote"),
    DECREASE(0x1f53d, "decrease"),
    WIND_CHIME(0x1f390, "wind_chime"),
    CARTWHEEL(0x1f938, "cartwheel"),
    ACCESSIBLE(0x267f, "accessible"),
    BREAKFAST(0x1f95e, "breakfast"),
    FROWNING(0x1f626, "frowning"),
    STOP_BUTTON(0x23f9, "stop_button"),
    POODLE(0x1f429, "poodle"),
    CARROT(0x1f955, "carrot"),
    NEW_BABY(0x1f425, "new_baby"),
    WHALE(0x1f433, "whale"),
    HEART_EYES(0x1f60d, "heart_eyes"),
    PARTLY_CLOUDY(0x26c5, "partly_cloudy"),
    POTATO(0x1f954, "potato"),
    TELEVISION(0x1f4fa, "television"),
    BOAT(0x26f5, "boat"),
    WAVE(0x1f44b, "wave"),
    PAINED(0x1f627, "pained"),
    ZZZ(0x1f4a4, "zzz"),
    ROWBOAT(0x1f6a3, "rowboat"),
    GECKO(0x1f98e, "gecko"),
    POPCORN(0x1f37f, "popcorn"),
    SMARTPHONE(0x1f4f1, "smartphone"),
    VIDEO_CAMERA(0x1f4f9, "video_camera"),
    SAD(0x2639, "sad"),
    HANDSHAKE(0x1f91d, "handshake"),
    CANDLE(0x1f56f, "candle"),
    MOUNT_FUJI(0x1f5fb, "mount_fuji"),
    HALO(0x1f607, "halo"),
    HEART_EXCLAMATION(0x2763, "heart_exclamation"),
    SNEAKER(0x1f45f, "sneaker"),
    JUSTICE(0x2696, "justice"),
    CLOTHING(0x1f45a, "clothing"),
    EURO_BANKNOTES(0x1f4b6, "euro_banknotes"),
    BAR_CHART(0x1f4ca, "bar_chart"),
    PHONE(0x260e, "phone"),
    ONCOMING_STREETCAR(0x1f68a, "oncoming_streetcar"),
    FIST(0x270a, "fist"),
    M(0x24c2, "m"),
    NEW(0x1f195, "new"),
    MELON(0x1f348, "melon"),
    HAZARD(0x2620, "hazard"),
    BULLS_EYE(0x1f3af, "bulls_eye"),
    GEAR(0x2699, "gear"),
    CANOE(0x1f6f6, "canoe"),
    HEART(0x2764, "heart"),
    VIRGO(0x264d, "virgo"),
    BANGBANG(0x203c, "bangbang"),
    PRINTER(0x1f5a8, "printer"),
    IN_LOVE(0x1f60d, "in_love"),
    POINT_OF_INFORMATION(0x261d, "point_of_information"),
    SKULL_AND_CROSSBONES(0x2620, "skull_and_crossbones"),
    SEMI_TRUCK(0x1f69b, "semi_truck"),
    MAPLE_LEAF(0x1f341, "maple_leaf"),
    CLUE(0x1f5dd, "clue"),
    EYES(0x1f440, "eyes"),
    FAST_DOWN(0x23ec, "fast_down"),
    FLAGS(0x1f38f, "flags"),
    DREAM(0x1f4ad, "dream"),
    FRIES(0x1f35f, "fries"),
    SUN_FACE(0x1f31e, "sun_face"),
    KEIKOGI(0x1f94b, "keikogi"),
    SOS(0x1f198, "sos"),
    CRICKET_BAT(0x1f3cf, "cricket_bat"),
    ONIGIRI(0x1f359, "onigiri"),
    TRASH_CAN(0x1f5d1, "trash_can"),
    COMMITMENT(0x1f510, "commitment"),
    SHEEP(0x1f411, "sheep"),
    CAPITAL_LETTERS(0x1f520, "capital_letters"),
    HARVEST(0x1f33e, "harvest"),
    CROCODILE(0x1f40a, "crocodile"),
    UNREAD_MAIL(0x1f4ec, "unread_mail"),
    SWAT(0x1f5de, "swat"),
    RIBBON(0x1f380, "ribbon"),
    CACTUS(0x1f335, "cactus"),
    NARUTO(0x1f365, "naruto"),
    MEGAPHONE(0x1f4e3, "megaphone"),
    ATM(0x1f3e7, "atm"),
    EMAIL(0x2709, "email"),
    CLOVER(0x2618, "clover"),
    O(0x1f17e, "o"),
    DICE(0x1f3b2, "dice"),
    SCHOOL(0x1f3eb, "school"),
    PASSENGER_SHIP(0x1f6f3, "passenger_ship"),
    ROCK_ON(0x1f918, "rock_on"),
    NOODLES(0x1f35c, "noodles"),
    LIVING_ROOM(0x1f6cb, "living_room"),
    VOLUME(0x1f39a, "volume"),
    SCIENCE(0x1f52c, "science"),
    CANDY(0x1f36c, "candy"),
    MECHANICAL(0x2699, "mechanical"),
    KEYBOARD(0x2328, "keyboard"),
    UNAMUSED(0x1f612, "unamused"),
    SHUFFLE(0x1f500, "shuffle"),
    INJECTION(0x1f489, "injection"),
    RAISED_HAND(0x270b, "raised_hand"),
    PRINCESS(0x1f478, "princess"),
    BARBER(0x1f488, "barber"),
    NUT_AND_BOLT(0x1f529, "nut_and_bolt"),
    PALETTE(0x1f3a8, "palette"),
    OLDER_WOMAN(0x1f475, "older_woman"),
    LIFT(0x1f3cb, "lift"),
    QUEEN(0x1f451, "queen"),
    SOCCER(0x26bd, "soccer"),
    RAILWAY_CAR(0x1f683, "railway_car"),
    DISAPPOINTED(0x1f61e, "disappointed"),
    POOP(0x1f4a9, "poop"),
    CLOUDY(0x1f325, "cloudy"),
    PUSH_PIN(0x1f4cc, "push_pin"),
    LOWER_RIGHT(0x2198, "lower_right"),
    FIND(0x1f50d, "find"),
    ANGRY(0x1f620, "angry"),
    TAKING_A_PICTURE(0x1f4f8, "taking_a_picture"),
    HIGH_HEELS(0x1f460, "high_heels"),
    CONGRATULATIONS(0x1f389, "congratulations"),
    WATER_BUFFALO(0x1f403, "water_buffalo"),
    MEMO(0x1f4dd, "memo"),
    RIGHT_HOOK(0x21aa, "right_hook"),
    REPLY(0x21a9, "reply"),
    TROLLEY(0x1f68e, "trolley"),
    FORTUNE_TELLING(0x1f52e, "fortune_telling"),
    DRIVE_WITH_CARE(0x1f6b8, "drive_with_care"),
    ROFL(0x1f923, "rofl"),
    HOT_SPRINGS(0x2668, "hot_springs"),
    CHICKEN(0x1f414, "chicken"),
    CONFETTI(0x1f38a, "confetti"),
    MOYAI(0x1f5ff, "moyai"),
    COOL(0x1f192, "cool"),
    BEAR(0x1f43b, "bear"),
    TEARS(0x1f602, "tears"),
    STOP_SIGN(0x1f6d1, "stop_sign"),
    VIDEOCASSETTE(0x1f4fc, "videocassette"),
    DRAGON(0x1f409, "dragon"),
    AIRPLANE_DEPARTURE(0x1f6eb, "airplane_departure"),
    EARTH_AMERICAS(0x1f30e, "earth_americas"),
    SMALL_BLUE_DIAMOND(0x1f539, "small_blue_diamond"),
    NO_SIGNAL(0x1f645, "no_signal"),
    RUGBY(0x1f3c9, "rugby"),
    EARTH_AFRICA(0x1f30d, "earth_africa"),
    ODEN(0x1f362, "oden"),
    MAIL(0x2709, "mail"),
    BOW_AND_ARROW(0x1f3f9, "bow_and_arrow"),
    HOVER(0x1f574, "hover"),
    TIE(0x1f454, "tie"),
    SCREW(0x1f529, "screw"),
    SELFIE(0x1f933, "selfie"),
    PLUS1(0x1f44d, "+1"),
    WOMENS(0x1f6ba, "womens"),
    LIBRA(0x264e, "libra"),
    RECEIPT(0x1f4c3, "receipt"),
    LIVE_LONG_AND_PROSPER(0x1f596, "live_long_and_prosper"),
    FACE_WITH_THERMOMETER(0x1f912, "face_with_thermometer"),
    JOY_CAT(0x1f639, "joy_cat"),
    SMALL_GLASS(0x1f943, "small_glass"),
    YAM(0x1f360, "yam"),
    SHOPPING_BAGS(0x1f6cd, "shopping_bags"),
    CONTROL_KNOBS(0x1f39b, "control_knobs"),
    DANCING(0x1f57a, "dancing"),
    ANGER_BUBBLE(0x1f5ef, "anger_bubble"),
    SPORTS(0x26f9, "sports"),
    COUNTERCLOCKWISE(0x1f504, "counterclockwise"),
    SLIGHT_FROWN(0x1f641, "slight_frown"),
    SHOOTING_STAR(0x1f320, "shooting_star"),
    FLASHLIGHT(0x1f526, "flashlight"),
    THANK_YOU(0x1f64f, "thank_you"),
    RACE(0x1f3c1, "race"),
    CROSS_MARK(0x274c, "cross_mark"),
    SHRUG(0x1f937, "shrug"),
    DIVIDE(0x2797, "divide"),
    ELEVATED_TRAIN(0x1f69d, "elevated_train"),
    POOL(0x1f3b1, "pool"),
    IMMIGRATION(0x1f6c2, "immigration"),
    BAGUETTE(0x1f956, "baguette"),
    CORN(0x1f33d, "corn"),
    ENVY(0x1f49a, "envy"),
    WATER_CLOSET(0x1f6be, "water_closet"),
    ARCHERY(0x1f3f9, "archery"),
    REPEAT(0x1f501, "repeat"),
    RELIEVED(0x1f60c, "relieved"),
    JOKING(0x1f61c, "joking"),
    WELCOME(0x1f64f, "welcome"),
    NEW_YORK(0x1f5fd, "new_york"),
    OCTAGONAL_SIGN(0x1f6d1, "octagonal_sign"),
    LINKED(0x1f587, "linked"),
    RUNNING(0x1f3c3, "running"),
    STOCK_MARKET(0x1f4b9, "stock_market"),
    SETTINGS(0x2699, "settings"),
    ONCOMING_AUTOMOBILE(0x1f698, "oncoming_automobile"),
    WARM(0x1f321, "warm"),
    EXPRESSIONLESS(0x1f611, "expressionless"),
    WINE(0x1f377, "wine"),
    CURRY(0x1f35b, "curry"),
    WEIGHT_LIFT(0x1f3cb, "weight_lift"),
    BEE(0x1f41d, "bee"),
    REWIND(0x23ea, "rewind"),
    SAKE(0x1f376, "sake"),
    MAN_AND_WOMAN_HOLDING_HANDS(0x1f46b, "man_and_woman_holding_hands"),
    LIGHT_RAIL(0x1f688, "light_rail"),
    DECIDUOUS_TREE(0x1f333, "deciduous_tree"),
    ROTATING_LIGHT(0x1f6a8, "rotating_light"),
    ANGER(0x1f4a2, "anger"),
    SPIRAL_NOTEBOOK(0x1f4d2, "spiral_notebook"),
    LOVE_YOU(0x2764, "love_you"),
    MILKY_WAY(0x1f30c, "milky_way"),
    HELMET(0x26d1, "helmet"),
    PONY(0x1f434, "pony"),
    KISSING_CAT(0x1f63d, "kissing_cat"),
    HIBISCUS(0x1f33a, "hibiscus"),
    SEALED(0x1f4e9, "sealed"),
    TEMPERATURE(0x1f321, "temperature"),
    ABC(0x1f524, "abc"),
    BANK(0x1f3e6, "bank"),
    GYMNASTICS(0x1f938, "gymnastics"),
    DIRECT_HIT(0x1f3af, "direct_hit"),
    RUNNER(0x1f3c3, "runner"),
    SHOUT(0x1f4e3, "shout"),
    BABY_BOTTLE(0x1f37c, "baby_bottle"),
    PLAY_REVERSE(0x25c0, "play_reverse"),
    DAGGER(0x1f5e1, "dagger"),
    HOTDOG(0x1f32d, "hotdog"),
    PAWS(0x1f43e, "paws"),
    BLACK_AND_WHITE_SQUARE(0x1f533, "black_and_white_square"),
    BACKPACK(0x1f392, "backpack"),
    OPEN_HANDS(0x1f450, "open_hands"),
    WHITE_AND_BLACK_SQUARE(0x1f532, "white_and_black_square"),
    GROWING_HEART(0x1f497, "growing_heart"),
    BEETLE(0x1f41e, "beetle"),
    AQUARIUS(0x2652, "aquarius"),
    TRANSPORT_TRUCK(0x1f69b, "transport_truck"),
    PLAY_PAUSE(0x23ef, "play_pause"),
    BETRAYED(0x1f52a, "betrayed"),
    FIELD_HOCKEY(0x1f3d1, "field_hockey"),
    CLOCK(0x1f557, "clock"),
    PEACE(0x262e, "peace"),
    MOTOR_BOAT(0x1f6e5, "motor_boat"),
    BEACH_UMBRELLA(0x26f1, "beach_umbrella"),
    E_MAIL(0x1f4e7, "e-mail"),
    BACK(0x1f519, "back"),
    OX(0x1f402, "ox"),
    MOON_CEREMONY(0x1f391, "moon_ceremony"),
    NORTH(0x2b06, "north"),
    SKI_LIFT(0x1f6a1, "ski_lift"),
    CHECKBOX(0x2611, "checkbox"),
    HOT_PEPPER(0x1f336, "hot_pepper"),
    PAINTING(0x1f3a8, "painting"),
    BIKINI(0x1f459, "bikini"),
    METRO(0x24c2, "metro"),
    VIDEO_RECORDER(0x1f4f9, "video_recorder"),
    BAA(0x1f411, "baa"),
    INVINCIBLE(0x26d1, "invincible"),
    KISS_SMILING_EYES(0x1f619, "kiss_smiling_eyes"),
    SOFT_ICE_CREAM(0x1f366, "soft_ice_cream"),
    STATION(0x1f689, "station"),
    POULTRY(0x1f357, "poultry"),
    PLUS(0x2795, "plus"),
    _8_BALL(0x1f3b1, "8_ball"),
    LABEL(0x1f3f7, "label"),
    TRACKBALL(0x1f5b2, "trackball"),
    PHYSICS(0x269b, "physics"),
    APPLE(0x1f34e, "apple"),
    ROWING(0x1f6a3, "rowing"),
    TOP_HAT(0x1f3a9, "top_hat"),
    CHERRY_BLOSSOM(0x1f338, "cherry_blossom"),
    SECURE(0x1f510, "secure"),
    MUTE_NOTIFICATIONS(0x1f515, "mute_notifications"),
    WAIT_ONE_SECOND(0x261d, "wait_one_second"),
    NEXT_TRACK(0x23ed, "next_track"),
    DORMOUSE(0x1f42d, "dormouse"),
    SNOWBOARDER(0x1f3c2, "snowboarder"),
    HUSH(0x1f910, "hush"),
    PAELLA(0x1f958, "paella"),
    WISH(0x1f320, "wish"),
    DIAMOND_WITH_A_DOT(0x1f4a0, "diamond_with_a_dot"),
    VS(0x1f19a, "vs"),
    RELAXED(0x263a, "relaxed"),
    AB(0x1f18e, "ab"),
    PAW_PRINTS(0x1f43e, "paw_prints"),
    HEART_OF_GOLD(0x1f49b, "heart_of_gold"),
    NO_MAIL(0x1f4ed, "no_mail"),
    SAY_CHEESE(0x1f4f8, "say_cheese"),
    ELDERLY_WOMAN(0x1f475, "elderly_woman"),
    NG(0x1f196, "ng"),
    SHADOW(0x1f464, "shadow"),
    ISLAND(0x1f3dd, "island"),
    SNEEZING(0x1f927, "sneezing"),
    STEAM_LOCOMOTIVE(0x1f682, "steam_locomotive"),
    HANDYWOMAN(0x1f528, "handywoman"),
    PROJECTOR(0x1f4fd, "projector"),
    SNAIL(0x1f40c, "snail"),
    SCARED(0x1f628, "scared"),
    CIRCUS(0x1f3aa, "circus"),
    MRS_CLAUS(0x1f936, "mrs_claus"),
    FRAMED_PICTURE(0x1f5bc, "framed_picture"),
    NOPE(0x1f645, "nope"),
    CONCH(0x1f41a, "conch"),
    DOCUMENT(0x1f4c4, "document"),
    BEDROOM(0x1f6cf, "bedroom"),
    DESERT(0x1f3dc, "desert"),
    THUMB_TACK(0x1f4cc, "thumb_tack"),
    DRENCHED(0x1f327, "drenched"),
    SWAP(0x2194, "swap"),
    CLINK(0x1f942, "clink"),
    PICTURE(0x1f5bc, "picture"),
    WEARY_CAT(0x1f640, "weary_cat"),
    SCORPION(0x1f982, "scorpion"),
    RED_TRIANGLE_UP(0x1f53a, "red_triangle_up"),
    BOAR(0x1f417, "boar"),
    SYRINGE(0x1f489, "syringe"),
    LAPTOP(0x1f4bb, "laptop"),
    PICK_ME(0x1f64b, "pick_me"),
    TURKEY(0x1f983, "turkey"),
    CALLING(0x1f4f2, "calling"),
    HORSE(0x1f40e, "horse"),
    HEART_BOX(0x1f49f, "heart_box"),
    ORANGE_BOOK(0x1f4d9, "orange_book"),
    PUMPKIN(0x1f383, "pumpkin"),
    GYM(0x1f3cb, "gym"),
    POLICE_CAR(0x1f693, "police_car"),
    HEADING_UP(0x2934, "heading_up"),
    SAFETY_FIRST(0x26d1, "safety_first"),
    FUNERAL_URN(0x26b1, "funeral_urn"),
    FORWARD(0x21aa, "forward"),
    FAST_FORWARD(0x23e9, "fast_forward"),
    CATERPILLAR(0x1f41b, "caterpillar"),
    SHAMROCK(0x2618, "shamrock"),
    BOMB(0x1f4a3, "bomb"),
    NERVOUS(0x1f62c, "nervous"),
    JUGGLING(0x1f939, "juggling"),
    CLIPBOARD(0x1f4cb, "clipboard"),
    VISE(0x1f5dc, "vise"),
    TROPHY(0x1f3c6, "trophy"),
    DEPARTURE(0x1f6eb, "departure"),
    TRAIN_CAR(0x1f683, "train_car"),
    DECORATION(0x1f380, "decoration"),
    FOOTPRINTS(0x1f463, "footprints"),
    SANTA(0x1f385, "santa"),
    ROLODEX(0x1f4c7, "rolodex"),
    VASE(0x1f3fa, "vase"),
    APPLAUSE(0x1f44f, "applause"),
    RETURN(0x1f504, "return"),
    CLUCK(0x1f414, "cluck"),
    KACHING(0x1f911, "kaching"),
    MAHJONG(0x1f004, "mahjong"),
    COW(0x1f404, "cow"),
    GIRL(0x1f467, "girl"),
    ASKING_A_QUESTION(0x261d, "asking_a_question"),
    DENIM(0x1f456, "denim"),
    HURT(0x1f915, "hurt"),
    COUCH_AND_LAMP(0x1f6cb, "couch_and_lamp"),
    START(0x1f3c1, "start"),
    CAMERA(0x1f4f7, "camera"),
    MAD(0x1f621, "mad"),
    WATCH(0x231a, "watch"),
    NORTH_WEST(0x2196, "north_west"),
    CALENDAR(0x1f4c5, "calendar"),
    FUTURE(0x1f52e, "future"),
    ARABIAN_CAMEL(0x1f42a, "arabian_camel"),
    YUM(0x1f60b, "yum"),
    TYPHOON(0x1f300, "typhoon"),
    COMPUTER(0x1f4bb, "computer"),
    BASEBALL(0x26be, "baseball"),
    NC17(0x1f51e, "nc17"),
    GEMINI(0x264a, "gemini"),
    PIN(0x1f4cd, "pin"),
    DANCERS(0x1f46f, "dancers"),
    CHRISTIANITY(0x271d, "christianity"),
    BACON(0x1f953, "bacon"),
    COMPRESSION(0x1f5dc, "compression"),
    ZIP_IT(0x1f910, "zip_it"),
    YIN_YANG(0x262f, "yin_yang"),
    GROWING(0x1f4c8, "growing"),
    RAISING_HAND(0x1f64b, "raising_hand"),
    BALLPOINT_PEN(0x1f58a, "ballpoint_pen"),
    CLOWN(0x1f921, "clown"),
    JOYSTICK(0x1f579, "joystick"),
    NEUTRAL(0x1f610, "neutral"),
    DIAMONDS(0x2666, "diamonds"),
    DUEL(0x2694, "duel"),
    FOG(0x1f32b, "fog"),
    SNOWFLAKE(0x2744, "snowflake"),
    OGRE(0x1f479, "ogre"),
    CHART(0x1f4c8, "chart"),
    LYING(0x1f925, "lying"),
    SKIP_FORWARD(0x23ed, "skip_forward"),
    MOON_FACE(0x1f31d, "moon_face"),
    MOVIE_CAMERA(0x1f3a5, "movie_camera"),
    CRUISE(0x1f6f3, "cruise"),
    SIGNAL_STRENGTH(0x1f4f6, "signal_strength"),
    MENS(0x1f6b9, "mens"),
    MOSTLY_SUNNY(0x1f324, "mostly_sunny"),
    ARIES(0x2648, "aries"),
    SMOKING(0x1f6ac, "smoking"),
    BLUE_HEART(0x1f499, "blue_heart"),
    EARTH_ASIA(0x1f30f, "earth_asia"),
    HOSPITAL(0x1f3e5, "hospital"),
    LINK(0x1f517, "link"),
    SPOON(0x1f944, "spoon"),
    CUCUMBER(0x1f952, "cucumber"),
    ANGEL(0x1f47c, "angel"),
    SMILE(0x263a, "smile"),
    HEADLINES(0x1f4f0, "headlines"),
    BIG_SMILE(0x1f604, "big_smile"),
    HOUSES(0x1f3d8, "houses"),
    ARCHIVE(0x1f5c3, "archive"),
    MAGNIFYING_GLASS(0x1f50d, "magnifying_glass"),
    ANGUISH(0x1f62b, "anguish"),
    GRAVE(0x26b0, "grave"),
    BOOK(0x1f4d6, "book"),
    SATELLITE_ANTENNA(0x1f4e1, "satellite_antenna"),
    SMIRK(0x1f60f, "smirk"),
    SWEAT(0x1f613, "sweat"),
    ANGUISHED(0x1f627, "anguished"),
    WOOF(0x1f415, "woof"),
    MAN(0x1f468, "man"),
    UP_BUTTON(0x1f53c, "up_button"),
    PAPERCLIP_CHAIN(0x1f587, "paperclip_chain"),
    SORT(0x1f5c2, "sort"),
    BLUSH(0x1f60a, "blush"),
    ACCOMMODATIONS(0x1f6cc, "accommodations"),
    FILM(0x1f39e, "film"),
    SALAD(0x1f957, "salad"),
    KISS_WITH_BLUSH(0x1f61a, "kiss_with_blush"),
    CHECK(0x2705, "check"),
    HURRICANE(0x1f300, "hurricane"),
    THIS(0x1f446, "this"),
    CHECK_MARK(0x2714, "check_mark"),
    ROLLER_COASTER(0x1f3a2, "roller_coaster"),
    UP_DOWN(0x2195, "up_down"),
    TOWER(0x1f5fc, "tower"),
    FALLEN_LEAF(0x1f342, "fallen_leaf"),
    JAPAN(0x1f5fe, "japan"),
    PIG(0x1f416, "pig"),
    DISABLED(0x267f, "disabled"),
    TRIANGULAR_RULER(0x1f4d0, "triangular_ruler"),
    FULL_MOON(0x1f315, "full_moon"),
    HOUSE(0x1f3e0, "house"),
    ENVELOPE(0x2709, "envelope"),
    ROSETTE(0x1f3f5, "rosette"),
    COMET(0x2604, "comet"),
    DOLLS(0x1f38e, "dolls"),
    SHIELD(0x1f6e1, "shield"),
    FOUNTAIN(0x26f2, "fountain"),
    MICROPHONE(0x1f3a4, "microphone"),
    EATING_UTENSILS(0x1f374, "eating_utensils"),
    GUITAR(0x1f3b8, "guitar"),
    HELICOPTER(0x1f681, "helicopter"),
    SPEAKER(0x1f508, "speaker"),
    PENCIL(0x270f, "pencil"),
    KIMONO(0x1f458, "kimono"),
    PERSON_FROWNING(0x1f64d, "person_frowning"),
    PINEAPPLE(0x1f34d, "pineapple"),
    ICE_SKATE(0x26f8, "ice_skate"),
    TOXIC(0x2620, "toxic"),
    HEART_EYES_CAT(0x1f63b, "heart_eyes_cat"),
    LIGHTNING_STORM(0x1f329, "lightning_storm"),
    RIGHT(0x27a1, "right"),
    HEARTBEAT(0x1f493, "heartbeat"),
    TOKYO_TOWER(0x1f5fc, "tokyo_tower"),
    AIRPLANE(0x2708, "airplane"),
    ANGRY_CAT(0x1f63e, "angry_cat"),
    SPIDER_WEB(0x1f578, "spider_web"),
    OH_NO(0x1f615, "oh_no"),
    HEADING_DOWN(0x2935, "heading_down"),
    GREEN_BOOK(0x1f4d7, "green_book"),
    CRYSTAL_BALL(0x1f52e, "crystal_ball"),
    CYCLONE(0x1f300, "cyclone"),
    BLACK_MEDIUM_SQUARE(0x25fc, "black_medium_square"),
    GOODNIGHT(0x1f31b, "goodnight"),
    POINT_DOWN(0x1f447, "point_down"),
    LIZARD(0x1f98e, "lizard"),
    RATED_FOR_VIOLENCE(0x1f5e1, "rated_for_violence"),
    JOKER(0x1f0cf, "joker"),
    WHEEL_OF_DHARMA(0x2638, "wheel_of_dharma"),
    THOUGHT(0x1f4ad, "thought"),
    NOTE(0x1f4dd, "note"),
    MIKE(0x1f3a4, "mike"),
    THUNDERSTORM(0x26c8, "thunderstorm"),
    FISHING(0x1f3a3, "fishing"),
    PACKAGE(0x1f4e6, "package"),
    STREETCAR(0x1f68b, "streetcar"),
    OIL_DRUM(0x1f6e2, "oil_drum"),
    CROSSED_FLAGS(0x1f38c, "crossed_flags"),
    COWBOY(0x1f920, "cowboy"),
    SCISSORS(0x2702, "scissors"),
    FLUSHED(0x1f633, "flushed"),
    TABLE_TENNIS(0x1f3d3, "table_tennis"),
    ROOSTER(0x1f413, "rooster"),
    HUNDRED(0x1f4af, "hundred"),
    TRAIN(0x1f682, "train"),
    TURBAN(0x1f473, "turban"),
    GOAL(0x1f945, "goal"),
    TOAST(0x1f942, "toast"),
    VOLCANO(0x1f30b, "volcano"),
    ARMS_OPEN(0x1f917, "arms_open"),
    SHRIMP(0x1f990, "shrimp"),
    LEDGER(0x1f4d2, "ledger"),
    FEET(0x1f463, "feet"),
    BOUQUET(0x1f490, "bouquet"),
    SHELL(0x1f41a, "shell"),
    SQUARED_UP(0x1f199, "squared_up"),
    CRAZY(0x1f61c, "crazy"),
    MASK(0x1f637, "mask"),
    OFFICE_SUPPLIES(0x1f587, "office_supplies"),
    LOCK_WITH_KEY(0x1f510, "lock_with_key"),
    HORN(0x1f4ef, "horn"),
    LOCKED_BAG(0x1f6c5, "locked_bag"),
    RHINOCEROS(0x1f98f, "rhinoceros"),
    SHOCK(0x1f628, "shock"),
    SPOOKY(0x1f47b, "spooky"),
    LOWER_LEFT(0x2199, "lower_left"),
    QUESTION(0x2753, "question"),
    PUNCH(0x1f44a, "punch"),
    COLD_SWEAT(0x1f630, "cold_sweat"),
    KISS(0x1f617, "kiss"),
    EXPLOSION(0x1f4a5, "explosion"),
    DUCK(0x1f986, "duck"),
    INCREASING(0x1f4c8, "increasing"),
    BOXING_GLOVE(0x1f94a, "boxing_glove"),
    DOLPHIN(0x1f42c, "dolphin"),
    HEAD_BANDAGE(0x1f915, "head_bandage"),
    HIGH_VOLTAGE(0x26a1, "high_voltage"),
    TAURUS(0x2649, "taurus"),
    SURF(0x1f3c4, "surf"),
    ONCOMING_TROLLEY(0x1f68a, "oncoming_trolley"),
    MEAT(0x1f356, "meat"),
    WATER_DROP(0x1f4a7, "water_drop"),
    FUEL_PUMP(0x26fd, "fuel_pump"),
    GREY_EXCLAMATION(0x2755, "grey_exclamation"),
    RADIO(0x1f4fb, "radio"),
    SUNSET(0x1f306, "sunset"),
    HERB(0x1f33f, "herb"),
    BLACK_SMALL_SQUARE(0x25aa, "black_small_square"),
    SHOWER(0x1f6bf, "shower"),
    BLOSSOM(0x1f33c, "blossom"),
    PALM(0x1f590, "palm"),
    HEAR_NO_EVIL(0x1f649, "hear_no_evil"),
    SMILEY_CAT(0x1f63a, "smiley_cat"),
    EMBARRASSED(0x1f633, "embarrassed"),
    STATUE_OF_LIBERTY(0x1f5fd, "statue_of_liberty"),
    SEE_NO_EVIL(0x1f648, "see_no_evil"),
    DEPARTMENT_STORE(0x1f3ec, "department_store"),
    SKI(0x1f3bf, "ski"),
    GRUMPY(0x1f621, "grumpy"),
    DIE(0x1f3b2, "die"),
    NO_SOUND(0x1f507, "no_sound"),
    DARK_SUNGLASSES(0x1f576, "dark_sunglasses"),
    INFORMATION_DESK_PERSON(0x1f481, "information_desk_person"),
    EXCLAMATION(0x2757, "exclamation"),
    HOCHO(0x1f52a, "hocho"),
    CLOSED_BOOK(0x1f4d5, "closed_book"),
    RAILWAY_TRACK(0x1f6e4, "railway_track"),
    FROSTY(0x26c4, "frosty"),
    NORTH_EAST(0x2197, "north_east"),
    LION(0x1f981, "lion"),
    BLACK_HEART(0x1f5a4, "black_heart"),
    SMILEY(0x1f603, "smiley"),
    SNOWY_MOUNTAIN(0x1f3d4, "snowy_mountain"),
    CRYSTAL(0x1f48e, "crystal"),
    NERD(0x1f913, "nerd"),
    CHECKERED_FLAG(0x1f3c1, "checkered_flag"),
    PEDESTRIAN(0x1f6b6, "pedestrian"),
    TAG(0x1f3f7, "tag"),
    FIST_BUMP(0x1f44a, "fist_bump"),
    BIG_RIG(0x1f69b, "big_rig"),
    FLAME(0x1f525, "flame"),
    BUZZ(0x1f41d, "buzz"),
    BLOW_A_KISS(0x1f618, "blow_a_kiss"),
    DANGO(0x1f361, "dango"),
    BOW(0x1f647, "bow"),
    SUBWAY(0x1f687, "subway"),
    COP(0x1f46e, "cop"),
    HAUNTED(0x1f47b, "haunted"),
    KEY(0x1f511, "key"),
    UPWARDS_TREND(0x1f4c8, "upwards_trend"),
    PREVIOUS_TRACK(0x23ee, "previous_track"),
    FLEUR_DE_LIS(0x269c, "fleur_de_lis"),
    RUNNING_SHOE(0x1f45f, "running_shoe"),
    CARD_INDEX(0x1f4c7, "card_index"),
    HEARTS(0x2665, "hearts"),
    GOAT(0x1f410, "goat"),
    TENNIS(0x1f3be, "tennis"),
    TAP_WATER(0x1f6b0, "tap_water"),
    MONEY_WITH_WINGS(0x1f4b8, "money_with_wings"),
    GUARD(0x1f482, "guard"),
    TRACTOR_TRAILER(0x1f69b, "tractor-trailer"),
    BASKETBALL(0x1f3c0, "basketball"),
    ORANGE(0x1f34a, "orange"),
    LGBTQ(0x1f308, "lgbtq"),
    CAUTION(0x26a0, "caution"),
    INCREASE(0x1f53c, "increase"),
    SPEEDBOAT(0x1f6a4, "speedboat"),
    GRADUATE(0x1f393, "graduate"),
    TV(0x1f4fa, "tv"),
    INTERROBANG(0x2049, "interrobang"),
    LARGE_ORANGE_DIAMOND(0x1f536, "large_orange_diamond"),
    GRIMACING(0x1f62c, "grimacing"),
    TAXI(0x1f695, "taxi"),
    HANDBALL(0x1f93e, "handball"),
    PIANO(0x1f3b9, "piano"),
    WRITING(0x270d, "writing"),
    TRIDENT(0x1f531, "trident"),
    RAINY(0x1f327, "rainy"),
    UMBRELLA_WITH_RAIN(0x2614, "umbrella_with_rain"),
    DO_NOT_LITTER(0x1f6af, "do_not_litter"),
    ATTACHMENT(0x1f4ce, "attachment"),
    UPPER_RIGHT(0x2197, "upper_right"),
    WHITE_FLAG(0x1f3f3, "white_flag"),
    SLEEPY(0x1f62a, "sleepy"),
    CALF(0x1f42e, "calf"),
    SOON(0x1f51c, "soon"),
    PIGLET(0x1f437, "piglet"),
    CROWN(0x1f451, "crown"),
    TAKE_OFF(0x1f6eb, "take_off"),
    SNOWSTORM(0x1f328, "snowstorm"),
    _100(0x1f4af, "100"),
    ZAP(0x26a1, "zap"),
    TWO_MEN_HOLDING_HANDS(0x1f46c, "two_men_holding_hands"),
    END(0x1f51a, "end"),
    TREE(0x1f333, "tree"),
    THINKING(0x1f914, "thinking"),
    NURSERY(0x1f6bc, "nursery"),
    CL(0x1f191, "cl"),
    BOWLING(0x1f3b3, "bowling"),
    DING(0x1f6ce, "ding"),
    FILE_FOLDER(0x1f4c1, "file_folder"),
    MOVIE_THEATER(0x1f3a6, "movie_theater"),
    INCORRECT(0x274c, "incorrect"),
    CHESTNUT(0x1f330, "chestnut"),
    FIRE_ENGINE(0x1f692, "fire_engine"),
    HAIRCUT(0x1f487, "haircut"),
    THERMOMETER(0x1f321, "thermometer"),
    WORK_IN_PROGRESS(0x1f6a7, "work_in_progress"),
    TORTOISE(0x1f422, "tortoise"),
    MOUNTAIN(0x26f0, "mountain"),
    HOTEL(0x1f3e8, "hotel"),
    RAGE(0x1f621, "rage"),
    SNOWY(0x1f328, "snowy"),
    MAIZE(0x1f33d, "maize"),
    SAFE(0x1f510, "safe"),
    POINT_UP(0x1f446, "point_up"),
    HELPLESS(0x1f623, "helpless"),
    MERRY_GO_ROUND(0x1f3a0, "merry_go_round"),
    CHURCH(0x26ea, "church"),
    PURPLE_HEART(0x1f49c, "purple_heart"),
    JACK_O_LANTERN(0x1f383, "jack-o-lantern"),
    WEDDING(0x1f492, "wedding"),
    LOUDSPEAKER(0x1f4e2, "loudspeaker"),
    PLAYING_CARDS(0x1f3b4, "playing_cards"),
    FIXING(0x1f527, "fixing"),
    MEN_COUPLE(0x1f46c, "men_couple"),
    HORSE_RIDING(0x1f3c7, "horse_riding"),
    SLEUTH(0x1f575, "sleuth"),
    VERTICAL_TRAFFIC_LIGHT(0x1f6a6, "vertical_traffic_light"),
    SPARKLE(0x2747, "sparkle"),
    ART(0x1f3a8, "art"),
    MIC(0x1f3a4, "mic"),
    TRUCK(0x1f69b, "truck"),
    CHEESE(0x1f9c0, "cheese"),
    PALM_TREE(0x1f334, "palm_tree"),
    NAIL_CARE(0x1f485, "nail_care"),
    WOMEN_COUPLE(0x1f46d, "women_couple"),
    CINEMA(0x1f3a6, "cinema"),
    DEVIL(0x1f47f, "devil"),
    ACTION(0x1f3ac, "action"),
    SOUP(0x1f372, "soup"),
    SPY(0x1f575, "spy"),
    ONCOMING_CAR(0x1f698, "oncoming_car"),
    STAR_AND_CRESCENT(0x262a, "star_and_crescent"),
    MAP(0x1f5fa, "map"),
    RAM(0x1f40f, "ram"),
    MOUNTAIN_BIKER(0x1f6b5, "mountain_biker"),
    FLU(0x1f912, "flu"),
    SCHOOL_BUS(0x1f68c, "school_bus"),
    SPECTACLES(0x1f453, "spectacles"),
    SKIER(0x26f7, "skier"),
    NOTEBOOK(0x1f4d3, "notebook"),
    FOLDER(0x1f4c2, "folder"),
    SPARKLER(0x1f387, "sparkler"),
    OWL(0x1f989, "owl"),
    FIRE_TRUCK(0x1f692, "fire_truck"),
    EIGHT_POINTED_STAR(0x2734, "eight_pointed_star"),
    BLACK_FLAG(0x1f3f4, "black_flag"),
    PLACE_HOLDER(0x1f4d1, "place_holder"),
    DIZZY(0x1f635, "dizzy"),
    TANABATA_TREE(0x1f38b, "tanabata_tree"),
    CLOSED_MAILBOX(0x1f4ea, "closed_mailbox"),
    SEEING_STARS(0x1f4ab, "seeing_stars"),
    BLACK_CIRCLE(0x26ab, "black_circle"),
    FEAR(0x1f628, "fear"),
    THUNDER_AND_RAIN(0x26c8, "thunder_and_rain"),
    HISS(0x1f40d, "hiss"),
    TORNADO(0x1f32a, "tornado"),
    CUPID(0x1f498, "cupid"),
    SUNNY(0x2600, "sunny"),
    FLAN(0x1f36e, "flan"),
    MUSCLE(0x1f4aa, "muscle"),
    BALLOT_BOX(0x1f5f3, "ballot_box"),
    LANDLINE(0x1f4de, "landline"),
    DISCO(0x1f57a, "disco"),
    STRAIGHTEDGE(0x1f4cf, "straightedge"),
    HAPPY(0x1f600, "happy"),
    ISLAM(0x262a, "islam"),
    LOYALTY(0x1f510, "loyalty"),
    RIDESHARE(0x1f695, "rideshare"),
    CROSS(0x271d, "cross"),
    LOVE_HOTEL(0x1f3e9, "love_hotel"),
    THIRD_PLACE(0x1f949, "third_place"),
    COMPUTER_MOUSE(0x1f5b1, "computer_mouse"),
    TIGER_CUB(0x1f42f, "tiger_cub"),
    CYCLIST(0x1f6b4, "cyclist"),
    ANT(0x1f41c, "ant"),
    TEMPURA(0x1f364, "tempura"),
    FAMILY(0x1f46a, "family"),
    SEAT(0x1f4ba, "seat"),
    SYMBOLS(0x1f523, "symbols"),
    SMILING_IMP(0x1f608, "smiling_imp"),
    MUSICAL_KEYBOARD(0x1f3b9, "musical_keyboard"),
    MONEY(0x1f4b0, "money"),
    EAR_OF_RICE(0x1f33e, "ear_of_rice"),
    UPSIDE_DOWN(0x1f643, "upside_down"),
    BATTERY(0x1f50b, "battery"),
    DOVE_OF_PEACE(0x1f54a, "dove_of_peace"),
    POWER(0x270a, "power"),
    WEARY(0x1f629, "weary"),
    SPAGHETTI(0x1f35d, "spaghetti"),
    DEATH(0x2620, "death"),
    P(0x1f17f, "p"),
    SQUID(0x1f991, "squid"),
    SMALL_ORANGE_DIAMOND(0x1f538, "small_orange_diamond"),
    LEFT(0x2b05, "left"),
    BABY_CHANGE_STATION(0x1f6bc, "baby_change_station"),
    PAGER(0x1f4df, "pager"),
    CALL_ME(0x1f919, "call_me"),
    CLOUD(0x2601, "cloud"),
    UNICORN(0x1f984, "unicorn"),
    SUSPENSION_RAILWAY(0x1f69f, "suspension_railway"),
    MAN_AND_WOMAN_COUPLE(0x1f46b, "man_and_woman_couple"),
    PARKING(0x1f17f, "parking"),
    CHAINS(0x26d3, "chains"),
    WORK_OUT(0x1f3cb, "work_out"),
    LEFT_RIGHT(0x2194, "left_right"),
    LOCKER(0x1f6c5, "locker"),
    SATELLITE(0x1f6f0, "satellite"),
    BIRD(0x1f426, "bird"),
    OK(0x1f44c, "ok"),
    BULB(0x1f4a1, "bulb"),
    TOMATO(0x1f345, "tomato"),
    PAPER(0x1f4c4, "paper"),
    SMILING_DEVIL(0x1f608, "smiling_devil"),
    PARTLY_SUNNY_WITH_RAIN(0x1f326, "partly_sunny_with_rain"),
    NEWSPAPER(0x1f5de, "newspaper"),
    HAMSTER(0x1f439, "hamster"),
    TEN(0x1f51f, "ten"),
    APPROVED(0x2705, "approved"),
    BATHTUB(0x1f6c1, "bathtub"),
    BIG_FROWN(0x2639, "big_frown"),
    CELL_RECEPTION(0x1f4f6, "cell_reception"),
    MOUNTAIN_RAILWAY(0x1f69e, "mountain_railway"),
    TUXEDO(0x1f935, "tuxedo"),
    ROAD(0x1f6e3, "road"),
    SQUARED_OK(0x1f197, "squared_ok"),
    SCROLL(0x1f4dc, "scroll"),
    TWO_HEARTS(0x1f495, "two_hearts"),
    PISCES(0x2653, "pisces"),
    NOSE(0x1f443, "nose"),
    DOLLARS(0x1f4b2, "dollars"),
    SOUTH(0x2b07, "south"),
    LIGHT_BULB(0x1f4a1, "light_bulb"),
    ID(0x1f194, "id"),
    MOUNTAIN_CABLEWAY(0x1f6a0, "mountain_cableway"),
    MARTIAL_ARTS(0x1f94b, "martial_arts"),
    SLOT_MACHINE(0x1f3b0, "slot_machine"),
    STUCK_OUT_TONGUE_WINK(0x1f61c, "stuck_out_tongue_wink"),
    SILVER(0x1f948, "silver"),
    SHIRO(0x1f3ef, "shiro"),
    POUTING_CAT(0x1f63e, "pouting_cat"),
    WEB(0x1f578, "web"),
    DIGITAL_SECURITY(0x1f50f, "digital_security"),
    NO_PEDESTRIANS(0x1f6b7, "no_pedestrians"),
    DIVISION(0x2797, "division"),
    MILK(0x1f95b, "milk"),
    CAT(0x1f408, "cat"),
    OINK(0x1f416, "oink"),
    GIFT_HEART(0x1f49d, "gift_heart"),
    SWIM(0x1f3ca, "swim"),
    ONCOMING_TRAM(0x1f68a, "oncoming_tram"),
    MOTORCYCLE(0x1f3cd, "motorcycle"),
    LEOPARD(0x1f406, "leopard"),
    MOTHER_CHRISTMAS(0x1f936, "mother_christmas"),
    ROLLING_EYES(0x1f644, "rolling_eyes"),
    MILITARY_MEDAL(0x1f396, "military_medal"),
    BURRITO(0x1f32f, "burrito"),
    ARCADE(0x1f579, "arcade"),
    FALL(0x1f343, "fall"),
    CUTE(0x1f4a0, "cute"),
    BLUE_CIRCLE(0x1f535, "blue_circle"),
    PEACE_SIGN(0x270c, "peace_sign"),
    SPADES(0x2660, "spades"),
    BAM(0x1f4a2, "bam"),
    RING(0x1f48d, "ring"),
    LIPSTICK(0x1f484, "lipstick"),
    BOY(0x1f466, "boy"),
    INBOX(0x1f4e5, "inbox"),
    SHAWARMA(0x1f959, "shawarma"),
    SPEECH_BUBBLE(0x1f5e8, "speech_bubble"),
    BUS_STOP(0x1f68f, "bus_stop"),
    DOOR(0x1f6aa, "door"),
    INBOX_ZERO(0x1f4ed, "inbox_zero"),
    LOW_BRIGHTNESS(0x1f505, "low_brightness"),
    SILENCE(0x1f910, "silence"),
    ANDROID(0x1f4f1, "android"),
    DUNGEON(0x1f5dd, "dungeon"),
    SPEECH_BALLOON(0x1f4ac, "speech_balloon"),
    PAUSE(0x23f8, "pause"),
    MINIBUS(0x1f690, "minibus"),
    IZAKAYA_LANTERN(0x1f3ee, "izakaya_lantern"),
    LIT(0x1f525, "lit"),
    LOL(0x1f606, "lol"),
    HAZY(0x1f32b, "hazy"),
    GRAPES(0x1f347, "grapes"),
    SHIP(0x1f6a2, "ship"),
    GEM(0x1f48e, "gem"),
    PASS(0x1f3ab, "pass"),
    LEVITATING(0x1f574, "levitating"),
    PETROL_PUMP(0x26fd, "petrol_pump"),
    TRACTOR(0x1f69c, "tractor"),
    LOCKED(0x1f512, "locked"),
    PART_ALTERNATION(0x303d, "part_alternation"),
    BELLHOP_BELL(0x1f6ce, "bellhop_bell"),
    PRINCE(0x1f934, "prince"),
    MONKEY(0x1f412, "monkey"),
    TIME_TICKING(0x23f3, "time_ticking"),
    STAR(0x2b50, "star"),
    AMBULANCE(0x1f691, "ambulance"),
    BROKEN_HEART(0x1f494, "broken_heart"),
    MAIL_DROPOFF(0x1f4ee, "mail_dropoff"),
    LIPS(0x1f444, "lips"),
    WHITE_SMALL_SQUARE(0x25ab, "white_small_square"),
    SHRINKING(0x1f4c9, "shrinking"),
    FLOWER(0x1f337, "flower"),
    SOFTER(0x1f509, "softer"),
    JAPAN_POST(0x1f3e3, "japan_post"),
    CAPITAL_ABCD(0x1f520, "capital_abcd"),
    BIRTHDAY(0x1f382, "birthday"),
    WRESTLING(0x1f93c, "wrestling"),
    MEDAL(0x1f3c5, "medal"),
    SOUND(0x1f50a, "sound"),
    SPEECHLESS(0x1f636, "speechless"),
    ROAD_TRIP(0x1f5fa, "road_trip"),
    SWEAT_SMILE(0x1f605, "sweat_smile"),
    STRESSED(0x1f625, "stressed"),
    ONCOMING_TAXI(0x1f696, "oncoming_taxi"),
    SOUVLAKI(0x1f959, "souvlaki"),
    WIND(0x1f343, "wind"),
    JUDIASM(0x2721, "judiasm"),
    GLASS_OF_MILK(0x1f95b, "glass_of_milk"),
    CLOCKWISE(0x1f503, "clockwise"),
    CIRCLE(0x2b55, "circle"),
    PROTECTED(0x1f50f, "protected"),
    CARPENTER_SQUARE(0x1f4d0, "carpenter_square"),
    HORSE_RACING(0x1f3c7, "horse_racing"),
    BRIDGE(0x1f309, "bridge"),
    WAVY_DASH(0x3030, "wavy_dash"),
    SWORDS(0x2694, "swords"),
    OCEAN(0x1f30a, "ocean"),
    NO_MOUTH(0x1f636, "no_mouth"),
    INFO(0x2139, "info"),
    SILHOUETTES(0x1f465, "silhouettes"),
    NO_PHONES(0x1f4f5, "no_phones"),
    DONER_KEBAB(0x1f959, "doner_kebab"),
    ROCKET(0x1f680, "rocket"),
    UFO(0x1f47d, "ufo"),
    HELLO(0x1f44b, "hello"),
    RIGHT_FIST(0x1f91c, "right_fist"),
    LEVEL_SLIDER(0x1f39a, "level_slider"),
    LAUGHING(0x1f606, "laughing"),
    HINDUISM(0x1f549, "hinduism"),
    DOUBLE_LOOP(0x27bf, "double_loop"),
    SUN_AND_RAIN(0x1f326, "sun_and_rain"),
    PENSIVE(0x1f614, "pensive"),
    RAMEN(0x1f35c, "ramen"),
    GAS_PUMP(0x26fd, "gas_pump"),
    FILE_CABINET(0x1f5c4, "file_cabinet"),
    BABY(0x1f476, "baby"),
    SECRET(0x1f5dd, "secret"),
    SLEEPING(0x1f634, "sleeping"),
    SPARKLING_HEART(0x1f496, "sparkling_heart"),
    SOB(0x1f62d, "sob"),
    MINIDISC(0x1f4bd, "minidisc"),
    SPIRAL_NOTEPAD(0x1f5d2, "spiral_notepad"),
    NAMASTE(0x1f64f, "namaste"),
    SUNRISE(0x1f305, "sunrise"),
    GREEN_APPLE(0x1f34f, "green_apple"),
    PEN(0x1f58a, "pen"),
    BRIEFCASE(0x1f4bc, "briefcase"),
    PARTLY_SUNNY(0x26c5, "partly_sunny"),
    CREW(0x1f6a3, "crew"),
    ALARM_CLOCK(0x23f0, "alarm_clock"),
    BALLOON(0x1f388, "balloon"),
    NOTIFICATIONS(0x1f514, "notifications"),
    BOOT(0x1f462, "boot"),
    CD(0x1f4bf, "cd"),
    TABLE_SETTING(0x1f37d, "table_setting"),
    COFFIN(0x26b0, "coffin"),
    CRASH(0x1f4a5, "crash"),
    SMILE_CAT(0x1f638, "smile_cat"),
    THEATER(0x1f3ad, "theater"),
    HANDBAG(0x1f45c, "handbag"),
    GOLF(0x1f3cc, "golf"),
    TRIANGULAR_FLAG(0x1f6a9, "triangular_flag"),
    DROP(0x1f4a7, "drop"),
    EXPECTING(0x1f930, "expecting"),
    GOBLIN(0x1f47a, "goblin"),
    GOLD(0x1f947, "gold"),
    BREAD(0x1f35e, "bread"),
    GUN(0x1f52b, "gun"),
    UP(0x2b06, "up"),
    DONUT(0x1f369, "donut"),
    ALPHABET(0x1f521, "alphabet"),
    UMM(0x1f4ac, "umm"),
    SKULL(0x1f480, "skull"),
    CLASSICAL_BUILDING(0x1f3db, "classical_building"),
    YELLOW_HEART(0x1f49b, "yellow_heart"),
    BAGGAGE_CLAIM(0x1f6c4, "baggage_claim"),
    BULLET_TRAIN(0x1f685, "bullet_train"),
    ELEPHANT(0x1f418, "elephant"),
    SERVICES(0x1f6ce, "services"),
    GRINNING_FACE_WITH_SMILING_EYES(0x1f601, "grinning_face_with_smiling_eyes"),
    GLOWING_STAR(0x1f31f, "glowing_star"),
    VICTORY(0x270c, "victory"),
    LANTERN(0x1f3ee, "lantern"),
    SOAKED(0x1f327, "soaked"),
    GREEN_HEART(0x1f49a, "green_heart"),
    WHITE_LARGE_SQUARE(0x2b1c, "white_large_square"),
    SIGN_OF_THE_HORNS(0x1f918, "sign_of_the_horns"),
    MOTOR_BIKE(0x1f6f5, "motor_bike"),
    GO(0x1f3c1, "go"),
    BOOKMARK(0x1f516, "bookmark"),
    WHEELCHAIR(0x267f, "wheelchair"),
    HOME_PHONE(0x1f4de, "home_phone"),
    TELESCOPE(0x1f52d, "telescope"),
    PILL(0x1f48a, "pill"),
    EYE(0x1f441, "eye"),
    SCULLING(0x1f6a3, "sculling"),
    B(0x1f171, "b"),
    TRAM(0x1f68b, "tram"),
    LAUGHTER_TEARS(0x1f602, "laughter_tears"),
    CREDIT_CARD(0x1f4b3, "credit_card"),
    WORLD_MAP(0x1f5fa, "world_map"),
    TROPICAL_FISH(0x1f420, "tropical_fish"),
    OPHIUCHUS(0x26ce, "ophiuchus"),
    CUSTOMS(0x1f6c3, "customs"),
    TADA(0x1f389, "tada"),
    YEN_BANKNOTES(0x1f4b4, "yen_banknotes"),
    TACO(0x1f32e, "taco"),
    POLICE(0x1f46e, "police"),
    SHOE(0x1f45e, "shoe"),
    MAILBOX(0x1f4eb, "mailbox"),
    RICE(0x1f35a, "rice"),
    NUCLEAR(0x2622, "nuclear"),
    HOURGLASS_DONE(0x231b, "hourglass_done"),
    LOVE_LETTER(0x1f48c, "love_letter"),
    DRUMSTICK(0x1f357, "drumstick"),
    MISCHIEVOUS(0x1f61b, "mischievous"),
    PREGNANT(0x1f930, "pregnant"),
    TIGER(0x1f405, "tiger"),
    NO_ENTRY(0x26d4, "no_entry"),
    CAROUSEL(0x1f3a0, "carousel"),
    ALCHEMY(0x2697, "alchemy"),
    RECREATIONAL_VEHICLE(0x1f699, "recreational_vehicle"),
    JEANS(0x1f456, "jeans"),
    SYNAGOGUE(0x1f54d, "synagogue"),
    ONCOMING_TRAIN(0x1f686, "oncoming_train"),
    GOOOOOOOOAL(0x1f945, "gooooooooal"),
    QUEASY(0x1f922, "queasy"),
    WHITE_MEDIUM_SMALL_SQUARE(0x25fd, "white_medium_small_square"),
    RABBIT(0x1f407, "rabbit"),
    PANDA(0x1f43c, "panda"),
    SHIRT(0x1f455, "shirt"),
    RULER(0x1f4cf, "ruler"),
    AIRPLANE_ARRIVAL(0x1f6ec, "airplane_arrival"),
    SIREN(0x1f6a8, "siren"),
    MUSICAL_SCORE(0x1f3bc, "musical_score"),
    CONSTRUCTION_ZONE(0x1f6a7, "construction_zone"),
    CRYING_CAT(0x1f63f, "crying_cat"),
    ORGANIZE(0x1f4c1, "organize"),
    RADIO_BUTTON(0x1f518, "radio_button"),
    CAMEL(0x1f42b, "camel"),
    DOG(0x1f415, "dog"),
    STRIKE(0x1f3b3, "strike"),
    SAXOPHONE(0x1f3b7, "saxophone"),
    UPPER_LEFT(0x2196, "upper_left"),
    VERY_ANGRY(0x1f621, "very_angry"),
    SAGITTARIUS(0x2650, "sagittarius"),
    PICK(0x26cf, "pick"),
    CREMATION(0x26b1, "cremation"),
    TOOLS(0x1f6e0, "tools"),
    GORILLA(0x1f98d, "gorilla"),
    FULL_BATTERY(0x1f50b, "full_battery"),
    DECORATIVE_NOTEBOOK(0x1f4d4, "decorative_notebook"),
    SEEDLING(0x1f331, "seedling"),
    MOBILE_PHONE(0x1f4f1, "mobile_phone"),
    DRUM(0x1f941, "drum"),
    CELEBRATION(0x1f388, "celebration"),
    PRAISE(0x1f64c, "praise"),
    HAMMER_AND_WRENCH(0x1f6e0, "hammer_and_wrench"),
    DOUBLE_UP(0x23eb, "double_up"),
    COMMODITIES(0x1f6e2, "commodities"),
    SMIRK_CAT(0x1f63c, "smirk_cat"),
    STUDIO_MICROPHONE(0x1f399, "studio_microphone"),
    TSHIRT(0x1f455, "tshirt"),
    FILE(0x1f4c4, "file"),
    HIGH_FIVE(0x1f590, "high_five"),
    PANCAKES(0x1f95e, "pancakes"),
    SURPRISE(0x1f62e, "surprise"),
    FIRE(0x1f525, "fire"),
    BIKE(0x1f6b2, "bike"),
    TENT(0x26fa, "tent"),
    TIRED(0x1f614, "tired"),
    LEFT_FIST(0x1f91b, "left_fist"),
    LEMON(0x1f34b, "lemon"),
    NUMBERS(0x1f522, "numbers"),
    ON(0x1f51b, "on"),
    PEACH(0x1f351, "peach"),
    BICYCLE(0x1f6b2, "bicycle"),
    LIFESTYLES(0x1f6cb, "lifestyles"),
    YACHT(0x1f6f3, "yacht"),
    MOVING_TRUCK(0x1f69a, "moving_truck"),
    CONSTRUCTION_WORKER(0x1f477, "construction_worker"),
    STRIPED_POLE(0x1f488, "striped_pole"),
    TUMBLING(0x1f938, "tumbling"),
    WRONG(0x274c, "wrong"),
    SOUTH_WEST(0x2199, "south_west"),
    EIGHT_SPOKED_ASTERISK(0x2733, "eight_spoked_asterisk"),
    SEARCH(0x1f50d, "search"),
    PHONE_OFF(0x1f4f4, "phone_off"),
    HEART_KISS(0x1f618, "heart_kiss"),
    NIGHT_SKY(0x1f30c, "night_sky"),
    ROSE(0x1f339, "rose"),
    AVOCADO(0x1f951, "avocado"),
    PRAYER_BEADS(0x1f4ff, "prayer_beads"),
    SOUTH_EAST(0x2198, "south_east"),
    BLACK_LARGE_SQUARE(0x2b1b, "black_large_square"),
    RICE_CRACKER(0x1f358, "rice_cracker"),
    ORTHODOX_CROSS(0x2626, "orthodox_cross"),
    POST_OFFICE(0x1f3e4, "post_office"),
    EVERGREEN_TREE(0x1f332, "evergreen_tree"),
    RECYCLE(0x267b, "recycle"),
    PERSEVERE(0x1f623, "persevere"),
    UPVOTE(0x1f53c, "upvote"),
    WINK(0x1f609, "wink"),
    COMPOSITION_BOOK(0x1f4d3, "composition_book"),
    SHARK(0x1f988, "shark"),
    BAMBOO(0x1f38d, "bamboo"),
    X(0x274e, "x"),
    OCEAN_SUNRISE(0x1f305, "ocean_sunrise"),
    CONFUSED(0x1f615, "confused"),
    INJURED(0x1f915, "injured"),
    KAABA(0x1f54b, "kaaba"),
    ICE_CREAM(0x1f368, "ice_cream"),
    CITY_SUNRISE(0x1f307, "city_sunrise"),
    DIM(0x1f505, "dim"),
    RAINBOW(0x1f308, "rainbow"),
    BURIAL(0x26b0, "burial"),
    ONCOMING_BUS(0x1f68d, "oncoming_bus"),
    PASSPORT_CONTROL(0x1f6c2, "passport_control"),
    BANANA(0x1f34c, "banana"),
    SAILBOAT(0x26f5, "sailboat"),
    HOLIDAY_TREE(0x1f384, "holiday_tree"),
    UMBRELLA(0x2602, "umbrella"),
    BLOWFISH(0x1f421, "blowfish"),
    PEANUTS(0x1f95c, "peanuts"),
    TRIUMPH(0x1f624, "triumph"),
    EGG(0x1f95a, "egg"),
    NO_BICYCLES(0x1f6b3, "no_bicycles"),
    EASY_COME_EASY_GO(0x1f4b8, "easy_come_easy_go"),
    STOP(0x1f91a, "stop"),
    RESTROOM(0x1f6bb, "restroom"),
    ALERT(0x1f6a8, "alert"),
    FINGERS_CROSSED(0x1f91e, "fingers_crossed"),
    FOOD(0x1f372, "food"),
    TOILET(0x1f6bd, "toilet"),
    BEERS(0x1f37b, "beers"),
    SNAKE(0x1f40d, "snake"),
    WORKING_ON_IT(0x1f6e0, "working_on_it"),
    EGGPLANT(0x1f346, "eggplant"),
    CHOCOLATE(0x1f36b, "chocolate"),
    PRAY(0x1f64f, "pray"),
    POINT_LEFT(0x1f448, "point_left"),
    NO_SMOKING(0x1f6ad, "no_smoking"),
    CLAP(0x1f44f, "clap"),
    MUSICAL_NOTES(0x1f3b6, "musical_notes"),
    TANGERINE(0x1f34a, "tangerine"),
    WC(0x1f6be, "wc"),
    BUG(0x1f41b, "bug"),
    DOUBLE_EXCLAMATION(0x203c, "double_exclamation"),
    MULTIPLY(0x2716, "multiply"),
    GOLD_RECORD(0x1f4bd, "gold_record"),
    EXHAUSTED(0x1f625, "exhausted"),
    OM(0x1f549, "om"),
    DOWNWARDS_TREND(0x1f4c9, "downwards_trend"),
    SHADOWS(0x1f465, "shadows"),
    NEW_MOON_FACE(0x1f31a, "new_moon_face"),
    BRONZE(0x1f949, "bronze"),
    ANGRY_DEVIL(0x1f47f, "angry_devil"),
    CARP_STREAMER(0x1f38f, "carp_streamer"),
    HATCHING_CHICK(0x1f423, "hatching_chick"),
    RED_TRIANGLE_DOWN(0x1f53b, "red_triangle_down"),
    DVD(0x1f4c0, "dvd"),
    CAPRICORN(0x2651, "capricorn"),
    DOUBLE_DOWN(0x23ec, "double_down"),
    BUDDHISM(0x2638, "buddhism"),
    SHAVED_ICE(0x1f367, "shaved_ice"),
    RAISED_HANDS(0x1f64c, "raised_hands"),
    SPROUT(0x1f331, "sprout"),
    CRY(0x1f622, "cry"),
    LOOKING(0x1f440, "looking"),
    ALARM(0x1f413, "alarm"),
    PUPPY(0x1f436, "puppy"),
    SCHOOL_CROSSING(0x1f6b8, "school_crossing"),
    SPIDER(0x1f577, "spider"),
    POKER_FACE(0x1f636, "poker_face"),
    DROOLING(0x1f924, "drooling"),
    SHINTO_SHRINE(0x26e9, "shinto_shrine"),
    FAX(0x1f4e0, "fax"),
    TULIP(0x1f337, "tulip"),
    GELATO(0x1f368, "gelato"),
    LOSING_MONEY(0x1f4b8, "losing_money"),
    FOX(0x1f98a, "fox"),
    KNIFE(0x1f52a, "knife"),
    BRIDE(0x1f470, "bride"),
    WAXING_MOON(0x1f314, "waxing_moon"),
    LANDING(0x1f6ec, "landing"),
    GUA_PI_MAO(0x1f472, "gua_pi_mao"),
    CRUSHED(0x1f940, "crushed"),
    TRUMPET(0x1f3ba, "trumpet"),
    TONGUE(0x1f445, "tongue"),
    ABCD(0x1f521, "abcd"),
    SNEAKY(0x1f575, "sneaky"),
    BALANCE(0x2696, "balance"),
    SOLIDARITY(0x1f38c, "solidarity"),
    WINDY(0x1f32c, "windy"),
    DRAMA(0x1f3ad, "drama"),
    VOICEMAIL(0x27bf, "voicemail"),
    REPEAT_ONE(0x1f502, "repeat_one"),
    EXCHANGE(0x1f4b1, "exchange"),
    SWEAT_DROPS(0x1f4a6, "sweat_drops"),
    HONEYBEE(0x1f41d, "honeybee"),
    FISH(0x1f41f, "fish"),
    MULTIPLICATION(0x2716, "multiplication"),
    HEADPHONES(0x1f3a7, "headphones"),
    PERSON_POUTING(0x1f64e, "person_pouting"),
    SUBURB(0x1f3e1, "suburb"),
    VOLLEYBALL(0x1f3d0, "volleyball"),
    FROWN(0x1f641, "frown"),
    MOSQUE(0x1f54c, "mosque"),
    FAST_UP(0x23eb, "fast_up"),
    OUTBOX(0x1f4e4, "outbox"),
    DOVE(0x1f54a, "dove"),
    BEER(0x1f37a, "beer"),
    TICKET(0x1f39f, "ticket"),
    SCALES(0x2696, "scales"),
    TIME(0x1f557, "time"),
    SKYLINE(0x1f3d9, "skyline"),
    ATHLETIC_SHOE(0x1f45f, "athletic_shoe"),
    GLOBE(0x1f310, "globe"),
    LEAVES(0x1f343, "leaves"),
    CROISSANT(0x1f950, "croissant"),
    IPHONE(0x1f4f1, "iphone"),
    WISH_TREE(0x1f38b, "wish_tree"),
    FURNITURE(0x1f6cb, "furniture"),
    ACROBATICS(0x1f938, "acrobatics"),
    WWW(0x1f310, "www"),
    BULL(0x1f402, "bull"),
    HEART_PULSE(0x1f497, "heart_pulse"),
    MONKEY_FACE(0x1f435, "monkey_face"),
    WATER_POLO(0x1f93d, "water_polo"),
    DERELICT_HOUSE(0x1f3da, "derelict_house"),
    DRAGON_FACE(0x1f432, "dragon_face"),
    STUFFED_FLATBREAD(0x1f959, "stuffed_flatbread"),
    SMALL_AIRPLANE(0x1f6e9, "small_airplane"),
    ALL_GOOD(0x2705, "all_good"),
    CITY(0x1f3d9, "city"),
    AMERICAN_FOOTBALL(0x1f3c8, "american_football"),
    KAWAII(0x1f4a0, "kawaii"),
    PROHIBITED(0x1f6ab, "prohibited"),
    SIGNAL_BARS(0x1f4f6, "signal_bars"),
    GLAMOUR(0x2728, "glamour"),
    QUIET(0x1f910, "quiet"),
    TRAFFIC_LIGHT(0x1f6a6, "traffic_light"),
    HIGH_SPEED_TRAIN(0x1f684, "high_speed_train"),
    FIREWORKS(0x1f386, "fireworks"),
    WORRIED(0x1f61f, "worried"),
    THUMBS_UP(0x1f44d, "thumbs_up"),
    TELEPHONE(0x260e, "telephone"),
    SHOPPING_TROLLEY(0x1f6d2, "shopping_trolley"),
    IDEA(0x1f4a1, "idea"),
    FERRY(0x26f4, "ferry"),
    SECOND_PLACE(0x1f948, "second_place"),
    WINNER(0x1f3c6, "winner"),
    FORK_AND_KNIFE_WITH_PLATE(0x1f37d, "fork_and_knife_with_plate"),
    CLOSED_UMBRELLA(0x1f302, "closed_umbrella"),
    PENGUIN(0x1f427, "penguin"),
    GREY_QUESTION(0x2754, "grey_question"),
    CANT_TALK(0x1f637, "cant_talk"),
    TOP(0x1f51d, "top"),
    PILE_OF_POO(0x1f4a9, "pile_of_poo"),
    VIBRATION_MODE(0x1f4f3, "vibration_mode"),
    VIDEO_GAME(0x1f3ae, "video_game"),
    SPARKLES(0x2728, "sparkles"),
    ELDERLY_MAN(0x1f474, "elderly_man"),
    LETS_EAT(0x1f37d, "lets_eat"),
    MICROSCOPE(0x1f52c, "microscope"),
    COCKTAIL(0x1f378, "cocktail"),
    SEWING_PIN(0x1f4cd, "sewing_pin"),
    HARD_HAT(0x26d1, "hard_hat"),
    BEACH(0x1f3d6, "beach"),
    LUCKY(0x1f340, "lucky"),
    HUMPBACK_WHALE(0x1f40b, "humpback_whale"),
    NAIL_POLISH(0x1f485, "nail_polish"),
    ANXIOUS(0x1f62c, "anxious"),
    PUT_LITTER_IN_ITS_PLACE(0x1f6ae, "put_litter_in_its_place"),
    KOALA(0x1f428, "koala"),
    FIRST_PLACE(0x1f947, "first_place"),
    TIMER(0x23f2, "timer"),
    MOVIE(0x1f4fd, "movie"),
    PAPERCLIP(0x1f4ce, "paperclip"),
    MINE(0x26cf, "mine"),
    MASSAGE(0x1f486, "massage"),
    DATE(0x1f4c6, "date"),
    SCREAM(0x1f631, "scream"),
    SCOOTER(0x1f6f5, "scooter"),
    FROG(0x1f438, "frog"),
    BENTO(0x1f371, "bento"),
    CLUBS(0x2663, "clubs"),
    GHOST(0x1f47b, "ghost"),
    EAGLE(0x1f985, "eagle"),
    SOFT_SERVE(0x1f366, "soft_serve"),
    BOOKS(0x1f4da, "books"),
    ROCK_CARVING(0x1f5ff, "rock_carving"),
    MORTAR_BOARD(0x1f393, "mortar_board"),
    CHIPMUNK(0x1f43f, "chipmunk"),
    DRINKING_WATER(0x1f6b0, "drinking_water"),
    HAMMER(0x1f528, "hammer"),
    SILHOUETTE(0x1f464, "silhouette"),
    PRICE_TAG(0x1f3f7, "price_tag"),
    OCTOPUS(0x1f419, "octopus"),
    ELECTRIC_PLUG(0x1f50c, "electric_plug"),
    FACE_PALM(0x1f926, "face_palm"),
    ALEMBIC(0x2697, "alembic"),
    CONCERNED(0x1f615, "concerned"),
    WASTEBASKET(0x1f5d1, "wastebasket"),
    MAIL_SENT(0x1f4e9, "mail_sent"),
    WILTED_FLOWER(0x1f940, "wilted_flower"),
    LIGHTNING(0x1f329, "lightning"),
    DEER(0x1f98c, "deer"),
    HOLE(0x1f573, "hole"),
    STATUE(0x1f5fd, "statue"),
    GIFT(0x1f381, "gift"),
    CRICKET(0x1f3cf, "cricket"),
    ORACLE(0x1f52e, "oracle"),
    LIPS_ARE_SEALED(0x1f910, "lips_are_sealed"),
    SENBEI(0x1f358, "senbei"),
    WATERMELON(0x1f349, "watermelon"),
    PURSE(0x1f45b, "purse"),
    BADMINTON(0x1f3f8, "badminton"),
    HOURGLASS(0x23f3, "hourglass");

    // The extra varibale is needed to prevend to much inlines see KT-31100.
    val unicode: String = String(Character.toChars(unicodeCodePoint))
}