/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.hugo.documentation;

import de.quantummaid.documaid.collecting.fastLookup.FileObjectsFastLookUpTable;
import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.FileObject;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.collecting.structure.ProjectFile;
import de.quantummaid.documaid.domain.hugo.documentation.DocumentationDirectory;
import de.quantummaid.documaid.domain.hugo.documentation.HugoDocumentationGenerationInformation;
import de.quantummaid.documaid.domain.hugo.documentation.HugoIndexedDirectoryMarkdownFile;
import de.quantummaid.documaid.domain.hugo.documentationWeights.HugoDirectoryWeightPadder;
import de.quantummaid.documaid.domain.hugo.documentationWeights.HugoWeight;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.paths.IndexedPath;
import de.quantummaid.documaid.domain.paths.PathUtilsKt;
import de.quantummaid.documaid.processing.ProcessingResult;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\"\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0004J\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0004J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lde/quantummaid/documaid/domain/hugo/documentation/AbstractDocumentationDirectory;", "Lde/quantummaid/documaid/domain/hugo/documentation/DocumentationDirectory;", "directory", "Lde/quantummaid/documaid/collecting/structure/Directory;", "(Lde/quantummaid/documaid/collecting/structure/Directory;)V", "getDirectory", "()Lde/quantummaid/documaid/collecting/structure/Directory;", "fillRemainingLevelsWithZeros", "", "generationInformation", "Lde/quantummaid/documaid/domain/hugo/documentation/HugoDocumentationGenerationInformation;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "generateHugoIndexFileIfNotPresent", "Lde/quantummaid/documaid/processing/ProcessingResult;", "getFileIndex", "", "getLevelWithinDocumentationHierarchy", "getParent", "indexFileNotPresent", "", "documaid"})
abstract class AbstractDocumentationDirectory
implements DocumentationDirectory {
    @NotNull
    private final Directory directory;

    @NotNull
    protected final DocumentationDirectory getParent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path absolutePath = this.directory.absolutePath();
        FileObjectsFastLookUpTable lookUpTable = project.getInformation(FileObjectsFastLookUpTable.Companion.getFILES_LOOKUP_TABLE_KEY());
        Path path = absolutePath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"absolutePath.parent");
        FileObject parent = lookUpTable.getFileObject(path);
        if (parent != null) {
            return DocumentationDirectory.Companion.aDocumentationDirectory((Directory)parent);
        }
        throw (Throwable)new IllegalArgumentException("Could not obtain parent " + absolutePath.getParent() + " for " + absolutePath);
    }

    protected final int getFileIndex(@NotNull HugoDocumentationGenerationInformation generationInformation) {
        Intrinsics.checkNotNullParameter((Object)generationInformation, (String)"generationInformation");
        Path path = generationInformation.getTargetPath();
        if (path == null) {
            throw (Throwable)new IllegalArgumentException("Can not obtain index for " + generationInformation.getOriginalPath() + ", " + "because 'targetpath' not set in generation information.");
        }
        Path targetPath = path;
        IndexedPath indexedPath = IndexedPath.Companion.anIndexedPath(targetPath);
        return indexedPath.getIndex();
    }

    @NotNull
    protected final String fillRemainingLevelsWithZeros(@NotNull HugoDocumentationGenerationInformation generationInformation, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)generationInformation, (String)"generationInformation");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String zeroPadded = HugoDirectoryWeightPadder.Companion.padIndex(0);
        int docuMaxLevel = ((Number)project.getInformation(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_MAX_LEVEL())).intValue();
        Integer n = generationInformation.getLevelWithinDocumentation();
        Intrinsics.checkNotNull((Object)n);
        int levelsToFillUp = docuMaxLevel - n;
        int increaseByOneDueToTheLevelAddedByTheFilesWithinTheDirectoryItself = levelsToFillUp + 1;
        return StringsKt.repeat((CharSequence)zeroPadded, (int)increaseByOneDueToTheLevelAddedByTheFilesWithinTheDirectoryItself);
    }

    protected final boolean indexFileNotPresent() {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.directory.children();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileObject it = (FileObject)element$iv;
                boolean bl = false;
                if (!PathUtilsKt.pathMatchesFileNameExactly(it.absolutePath(), "_index.md")) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        FileObject indexFile = v0;
        return indexFile == null;
    }

    @Override
    public int getLevelWithinDocumentationHierarchy() {
        HugoDocumentationGenerationInformation generationInformation = this.directory.getData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
        Integer n = generationInformation.getLevelWithinDocumentation();
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ProcessingResult generateHugoIndexFileIfNotPresent() {
        ProcessingResult processingResult;
        if (this.indexFileNotPresent()) {
            void mdFile;
            HugoDocumentationGenerationInformation generationInformation = this.directory.getData(HugoDocumentationGenerationInformation.Companion.getDOCUMENTATION_GEN_INFO_KEY());
            Path path = generationInformation.getTargetPath();
            Intrinsics.checkNotNull((Object)path);
            Path targetPath = path;
            Path fileName = targetPath.resolve("_index.md");
            String string = generationInformation.getWeight();
            Intrinsics.checkNotNull((Object)string);
            String rawHugoWeight = string;
            HugoWeight hugoWeight = HugoWeight.Companion.createForMultiLevelWeight(rawHugoWeight);
            String name = IndexedPath.Companion.isIndexedPath(targetPath) ? IndexedPath.Companion.anIndexedPath(targetPath).getName() : this.directory.name();
            Path path2 = fileName;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"fileName");
            Pair<MarkdownFile, String> pair = HugoIndexedDirectoryMarkdownFile.Companion.create(path2, name, hugoWeight);
            MarkdownFile markdownFile = (MarkdownFile)pair.component1();
            String content = (String)pair.component2();
            this.directory.addChild((FileObject)mdFile);
            processingResult = ProcessingResult.Companion.successfulProcessingResult((ProjectFile)mdFile, content);
        } else {
            processingResult = null;
        }
        return processingResult;
    }

    @NotNull
    protected final Directory getDirectory() {
        return this.directory;
    }

    protected AbstractDocumentationDirectory(@NotNull Directory directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.directory = directory;
    }
}

