/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents;

import de.quantummaid.documaid.collecting.fastLookup.FileObjectsFastLookUpTable;
import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.collecting.structure.FileObject;
import de.quantummaid.documaid.collecting.structure.Project;
import de.quantummaid.documaid.domain.markdown.MarkdownFile;
import de.quantummaid.documaid.domain.markdown.tagBased.DirectiveTag;
import de.quantummaid.documaid.domain.markdown.tagBased.OptionsString;
import de.quantummaid.documaid.domain.markdown.tagBased.RawMarkdownDirective;
import de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents.TableOfContentsDirectiveOptions;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/tableOfContents/TableOfContentsDirective;", "", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "scanBaseDirectory", "Lde/quantummaid/documaid/collecting/structure/Directory;", "(Lde/quantummaid/documaid/domain/markdown/MarkdownFile;Lde/quantummaid/documaid/collecting/structure/Directory;)V", "getFile", "()Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "getScanBaseDirectory", "()Lde/quantummaid/documaid/collecting/structure/Directory;", "Companion", "documaid"})
public final class TableOfContentsDirective {
    @NotNull
    private final MarkdownFile file;
    @NotNull
    private final Directory scanBaseDirectory;
    @NotNull
    private static final DirectiveTag TOC_TAG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final MarkdownFile getFile() {
        return this.file;
    }

    @NotNull
    public final Directory getScanBaseDirectory() {
        return this.scanBaseDirectory;
    }

    private TableOfContentsDirective(MarkdownFile file, Directory scanBaseDirectory) {
        this.file = file;
        this.scanBaseDirectory = scanBaseDirectory;
    }

    static {
        Companion = new Companion(null);
        TOC_TAG = new DirectiveTag("TOC");
    }

    public /* synthetic */ TableOfContentsDirective(MarkdownFile file, Directory scanBaseDirectory, DefaultConstructorMarker $constructor_marker) {
        this(file, scanBaseDirectory);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lde/quantummaid/documaid/domain/markdown/tagBased/tableOfContents/TableOfContentsDirective$Companion;", "", "()V", "TOC_TAG", "Lde/quantummaid/documaid/domain/markdown/tagBased/DirectiveTag;", "getTOC_TAG", "()Lde/quantummaid/documaid/domain/markdown/tagBased/DirectiveTag;", "create", "Lde/quantummaid/documaid/domain/markdown/tagBased/tableOfContents/TableOfContentsDirective;", "rawMarkdownDirective", "Lde/quantummaid/documaid/domain/markdown/tagBased/RawMarkdownDirective;", "file", "Lde/quantummaid/documaid/domain/markdown/MarkdownFile;", "project", "Lde/quantummaid/documaid/collecting/structure/Project;", "documaid"})
    public static final class Companion {
        @NotNull
        public final DirectiveTag getTOC_TAG() {
            return TOC_TAG;
        }

        @NotNull
        public final TableOfContentsDirective create(@NotNull RawMarkdownDirective rawMarkdownDirective, @NotNull MarkdownFile file, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)rawMarkdownDirective, (String)"rawMarkdownDirective");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Path directoryBasePath = file.absolutePath().getParent();
            OptionsString optionsString = rawMarkdownDirective.getOptionsString();
            Path path = directoryBasePath;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"directoryBasePath");
            TableOfContentsDirectiveOptions options = TableOfContentsDirectiveOptions.Companion.create(optionsString, path, file);
            Path tocScanBaseDirectory = options.getTocScanBaseDirectory();
            FileObjectsFastLookUpTable lookUpTable = project.getInformation(FileObjectsFastLookUpTable.Companion.getFILES_LOOKUP_TABLE_KEY());
            FileObject fileObject = lookUpTable.getFileObject(tocScanBaseDirectory);
            if (fileObject == null) {
                throw new NullPointerException("null cannot be cast to non-null type de.quantummaid.documaid.collecting.structure.Directory");
            }
            Directory scanBaseDirectory = (Directory)fileObject;
            return new TableOfContentsDirective(file, scanBaseDirectory, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

