/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.tableOfContents;

import de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents.GithubTableOfContentsMarkdownTagHandler;
import de.quantummaid.documaid.domain.markdown.tagBased.tableOfContents.TableOfContentsDirective;
import de.quantummaid.documaid.domain.tableOfContents.TableOfContentsDataStructuresKt;
import de.quantummaid.documaid.domain.tableOfContents.TocDataFileObject;
import de.quantummaid.documaid.errors.DocuMaidException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a$\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"convertToNormalCase", "", "name", "parseName", "Lkotlin/Pair;", "", "path", "Ljava/nio/file/Path;", "verifyIndicesCorrect", "", "list", "", "Lde/quantummaid/documaid/domain/tableOfContents/TocDataFileObject;", "absolutePath", "documaid"})
public final class TableOfContentsDataStructuresKt {
    private static final Pair<Integer, String> parseName(String name, Path path) {
        MatchResult matchResult = GithubTableOfContentsMarkdownTagHandler.Companion.getINDEX_MARKDOWN_FILE_NAME_PATTERN().matchEntire((CharSequence)name);
        if (matchResult != null) {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"index");
            Intrinsics.checkNotNull((Object)matchGroup);
            MatchGroup matchGroup2 = matchGroup;
            String indexString = matchGroup2.component1();
            int index = Integer.parseInt(indexString);
            MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"name");
            Intrinsics.checkNotNull((Object)matchGroup3);
            MatchGroup matchGroup4 = matchGroup3;
            String title = matchGroup4.component1();
            String normalCaseName = TableOfContentsDataStructuresKt.convertToNormalCase(title);
            return new Pair((Object)index, (Object)normalCaseName);
        }
        throw (Throwable)DocuMaidException.Companion.aDocuMaidException("" + '[' + TableOfContentsDirective.Companion.getTOC_TAG() + "] Cannot parse Toc indexed name '" + name + '\'', path);
    }

    private static final String convertToNormalCase(String name) {
        String string = name;
        int n = 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String nameWithOutFirstCharacter = string3;
        String string4 = "\\p{Lu}";
        bl = false;
        Regex regex = new Regex(string4);
        CharSequence charSequence = nameWithOutFirstCharacter;
        Function1 function1 = convertToNormalCase.normalCaseRest.1.INSTANCE;
        char c = '\u0000';
        String normalCaseRest2 = regex.replace(charSequence, function1);
        char c2 = name.charAt(0);
        boolean bl2 = false;
        c = c2;
        boolean bl3 = false;
        c2 = Character.toUpperCase(c);
        bl2 = false;
        return String.valueOf(c2) + normalCaseRest2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void verifyIndicesCorrect(List<? extends TocDataFileObject> list, Path absolutePath) {
        for (TocDataFileObject tocDataFileObject : list) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            Collection collection;
            void $this$mapTo$iv$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TocDataFileObject it = (TocDataFileObject)element$iv$iv;
                boolean bl = false;
                if (!(it.getIndex() == tocDataFileObject.getIndex())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List sameIndexTocDataFiles = (List)destination$iv$iv;
            if (sameIndexTocDataFiles.size() <= 1) continue;
            Iterable $this$map$iv2 = sameIndexTocDataFiles;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv32422 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                TocDataFileObject bl = (TocDataFileObject)item$iv$iv;
                collection = destination$iv$iv32422;
                boolean bl2 = false;
                object = it.getIndex();
                collection.add(object);
            }
            List conflictingIndexes = CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv32422)));
            Iterable $this$sortedBy$iv = sameIndexTocDataFiles;
            boolean $i$f$sortedBy = false;
            boolean destination$iv$iv32422 = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    TocDataFileObject it = (TocDataFileObject)a;
                    boolean bl2 = false;
                    Comparable comparable = it.getAbsolutePath();
                    it = (TocDataFileObject)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Path path = it.getAbsolutePath();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)path);
                }
            });
            boolean $i$f$map2 = false;
            void destination$iv$iv32422 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TocDataFileObject bl2 = (TocDataFileObject)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                object = String.valueOf(it.getScanRootRelativeDirectory());
                collection.add(object);
            }
            List conflictingIndexFiles = (List)destination$iv$iv2;
            String message2 = "" + '[' + TableOfContentsDirective.Companion.getTOC_TAG() + "] Same TOC indices" + conflictingIndexes + " used by multiple files " + conflictingIndexFiles;
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message2, absolutePath);
        }
        Iterable iterable = list;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : iterable) {
            void tocDataFileObject;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TocDataFileObject $this$mapTo$iv$iv = (TocDataFileObject)item$iv;
            int index = n;
            boolean bl3 = false;
            int expectedIndex = index + 1;
            if (expectedIndex == tocDataFileObject.getIndex()) continue;
            String message3 = "" + '[' + TableOfContentsDirective.Companion.getTOC_TAG() + "] Missing index " + expectedIndex + " for TOC in directory '" + absolutePath.getFileName() + '\'';
            throw (Throwable)DocuMaidException.Companion.aDocuMaidException(message3, absolutePath);
        }
    }

    public static final /* synthetic */ void access$verifyIndicesCorrect(List list, Path absolutePath) {
        TableOfContentsDataStructuresKt.verifyIndicesCorrect(list, absolutePath);
    }

    public static final /* synthetic */ Pair access$parseName(String name, Path path) {
        return TableOfContentsDataStructuresKt.parseName(name, path);
    }
}

