/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.documaid.domain.tableOfContents;

import de.quantummaid.documaid.collecting.structure.Directory;
import de.quantummaid.documaid.domain.tableOfContents.TableOfContentsDataStructuresKt;
import de.quantummaid.documaid.domain.tableOfContents.TocDataFileObject;
import de.quantummaid.documaid.errors.VerificationError;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\u0002\u0010\fR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lde/quantummaid/documaid/domain/tableOfContents/TocDataDirectory;", "Lde/quantummaid/documaid/domain/tableOfContents/TocDataFileObject;", "index", "", "title", "", "scanRootRelativeDirectory", "Ljava/nio/file/Path;", "directory", "Lde/quantummaid/documaid/collecting/structure/Directory;", "children", "", "(ILjava/lang/String;Ljava/nio/file/Path;Lde/quantummaid/documaid/collecting/structure/Directory;Ljava/util/List;)V", "getChildren", "()Ljava/util/List;", "Companion", "documaid"})
public final class TocDataDirectory
extends TocDataFileObject {
    @NotNull
    private final List<TocDataFileObject> children;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<TocDataFileObject> getChildren() {
        return this.children;
    }

    public TocDataDirectory(int index, @NotNull String title, @NotNull Path scanRootRelativeDirectory, @NotNull Directory directory, @NotNull List<? extends TocDataFileObject> children) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)scanRootRelativeDirectory, (String)"scanRootRelativeDirectory");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        super(index, title, scanRootRelativeDirectory, directory);
        this.children = children;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006\u00a8\u0006\u000e"}, d2={"Lde/quantummaid/documaid/domain/tableOfContents/TocDataDirectory$Companion;", "", "()V", "create", "Lkotlin/Pair;", "Lde/quantummaid/documaid/domain/tableOfContents/TocDataDirectory;", "", "Lde/quantummaid/documaid/errors/VerificationError;", "directory", "Lde/quantummaid/documaid/collecting/structure/Directory;", "scanBaseDir", "Ljava/nio/file/Path;", "children", "Lde/quantummaid/documaid/domain/tableOfContents/TocDataFileObject;", "documaid"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<TocDataDirectory, List<VerificationError>> create(@NotNull Directory directory, @NotNull Path scanBaseDir, @NotNull List<? extends TocDataFileObject> children) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)scanBaseDir, (String)"scanBaseDir");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            try {
                void index;
                Path relativePath;
                Path dirAbsolutePath = directory.absolutePath();
                String fileName = ((Object)dirAbsolutePath.getFileName()).toString();
                Pair pair2 = TableOfContentsDataStructuresKt.access$parseName(fileName, dirAbsolutePath);
                int n = ((Number)pair2.component1()).intValue();
                String title = (String)pair2.component2();
                Iterable $this$sortedBy$iv = children;
                boolean $i$f$sortedBy = false;
                boolean bl = false;
                List sortedChildren = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        TocDataFileObject it = (TocDataFileObject)a;
                        boolean bl2 = false;
                        Comparable comparable = Integer.valueOf(it.getIndex());
                        it = (TocDataFileObject)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Integer n = it.getIndex();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                });
                TableOfContentsDataStructuresKt.access$verifyIndicesCorrect(sortedChildren, dirAbsolutePath);
                Path path = relativePath = scanBaseDir.relativize(dirAbsolutePath);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativePath");
                TocDataDirectory tocDataDirectory = new TocDataDirectory((int)index, title, path, directory, sortedChildren);
                pair = new Pair((Object)tocDataDirectory, (Object)CollectionsKt.emptyList());
            }
            catch (Exception e) {
                VerificationError verificationError = VerificationError.Companion.createFromException(e, directory);
                pair = new Pair(null, (Object)CollectionsKt.listOf((Object)verificationError));
            }
            return pair;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

